/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.approximate;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.IntsRef;
import org.opensearch.search.approximate.ApproximateQuery;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortOrder;

public class ApproximatePointRangeQuery
extends ApproximateQuery {
    public static final Function<byte[], String> LONG_FORMAT = bytes -> Long.toString(LongPoint.decodeDimension((byte[])bytes, (int)0));
    private int size;
    private SortOrder sortOrder;
    public final PointRangeQuery pointRangeQuery;

    public ApproximatePointRangeQuery(String field, byte[] lowerPoint, byte[] upperPoint, int numDims, Function<byte[], String> valueToString) {
        this(field, lowerPoint, upperPoint, numDims, 10000, null, valueToString);
    }

    protected ApproximatePointRangeQuery(String field, byte[] lowerPoint, byte[] upperPoint, int numDims, int size, SortOrder sortOrder, final Function<byte[], String> valueToString) {
        this.size = size;
        this.sortOrder = sortOrder;
        this.pointRangeQuery = new PointRangeQuery(this, field, lowerPoint, upperPoint, numDims){

            protected String toString(int dimension, byte[] value) {
                return (String)valueToString.apply(value);
            }
        };
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return super.rewrite(indexSearcher);
    }

    public void visit(QueryVisitor visitor) {
        this.pointRangeQuery.visit(visitor);
    }

    public final ConstantScoreWeight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight pointRangeQueryWeight = this.pointRangeQuery.createWeight(searcher, scoreMode, boost);
        return new ConstantScoreWeight(this, boost){
            private final ArrayUtil.ByteArrayComparator comparator;
            {
                super(query, score);
                this.comparator = ArrayUtil.getUnsignedComparator((int)ApproximatePointRangeQuery.this.pointRangeQuery.getBytesPerDim());
            }

            private boolean matches(byte[] packedValue) {
                for (int dim = 0; dim < ApproximatePointRangeQuery.this.pointRangeQuery.getNumDims(); ++dim) {
                    int offset = dim * ApproximatePointRangeQuery.this.pointRangeQuery.getBytesPerDim();
                    if (this.comparator.compare(packedValue, offset, ApproximatePointRangeQuery.this.pointRangeQuery.getLowerPoint(), offset) < 0) {
                        return false;
                    }
                    if (this.comparator.compare(packedValue, offset, ApproximatePointRangeQuery.this.pointRangeQuery.getUpperPoint(), offset) <= 0) continue;
                    return false;
                }
                return true;
            }

            private PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
                boolean crosses = false;
                for (int dim = 0; dim < ApproximatePointRangeQuery.this.pointRangeQuery.getNumDims(); ++dim) {
                    int offset = dim * ApproximatePointRangeQuery.this.pointRangeQuery.getBytesPerDim();
                    if (this.comparator.compare(minPackedValue, offset, ApproximatePointRangeQuery.this.pointRangeQuery.getUpperPoint(), offset) > 0 || this.comparator.compare(maxPackedValue, offset, ApproximatePointRangeQuery.this.pointRangeQuery.getLowerPoint(), offset) < 0) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    crosses |= this.comparator.compare(minPackedValue, offset, ApproximatePointRangeQuery.this.pointRangeQuery.getLowerPoint(), offset) < 0 || this.comparator.compare(maxPackedValue, offset, ApproximatePointRangeQuery.this.pointRangeQuery.getUpperPoint(), offset) > 0;
                }
                if (crosses) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }

            public PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result, final long[] docCount) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    public void visit(int docID) {
                        if (docCount[0] >= (long)ApproximatePointRangeQuery.this.size) {
                            return;
                        }
                        this.adder.add(docID);
                        docCount[0] = docCount[0] + 1L;
                    }

                    public void visit(DocIdSetIterator iterator) throws IOException {
                        this.adder.add(iterator);
                    }

                    public void visit(IntsRef ref) {
                        for (int i = 0; i < ref.length; ++i) {
                            this.adder.add(ref.ints[ref.offset + i]);
                        }
                    }

                    public void visit(int docID, byte[] packedValue) {
                        if (this.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (this.matches(packedValue)) {
                            this.adder.add(iterator);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return this.relate(minPackedValue, maxPackedValue);
                    }
                };
            }

            private boolean checkValidPointValues(PointValues values) throws IOException {
                if (values == null) {
                    return false;
                }
                if (values.getNumIndexDimensions() != ApproximatePointRangeQuery.this.pointRangeQuery.getNumDims()) {
                    throw new IllegalArgumentException("field=\"" + ApproximatePointRangeQuery.this.pointRangeQuery.getField() + "\" was indexed with numIndexDimensions=" + values.getNumIndexDimensions() + " but this query has numDims=" + ApproximatePointRangeQuery.this.pointRangeQuery.getNumDims());
                }
                if (ApproximatePointRangeQuery.this.pointRangeQuery.getBytesPerDim() != values.getBytesPerDimension()) {
                    throw new IllegalArgumentException("field=\"" + ApproximatePointRangeQuery.this.pointRangeQuery.getField() + "\" was indexed with bytesPerDim=" + values.getBytesPerDimension() + " but this query has bytesPerDim=" + ApproximatePointRangeQuery.this.pointRangeQuery.getBytesPerDim());
                }
                return true;
            }

            private void intersectLeft(PointValues.PointTree pointTree, PointValues.IntersectVisitor visitor, long[] docCount) throws IOException {
                this.intersectLeft(visitor, pointTree, docCount);
                assert (!pointTree.moveToParent());
            }

            private void intersectRight(PointValues.PointTree pointTree, PointValues.IntersectVisitor visitor, long[] docCount) throws IOException {
                this.intersectRight(visitor, pointTree, docCount);
                assert (!pointTree.moveToParent());
            }

            public void intersectLeft(PointValues.IntersectVisitor visitor, PointValues.PointTree pointTree, long[] docCount) throws IOException {
                PointValues.Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
                if (docCount[0] >= (long)ApproximatePointRangeQuery.this.size) {
                    return;
                }
                switch (r) {
                    case CELL_OUTSIDE_QUERY: {
                        break;
                    }
                    case CELL_INSIDE_QUERY: {
                        if (pointTree.moveToChild() && docCount[0] < (long)ApproximatePointRangeQuery.this.size) {
                            do {
                                this.intersectLeft(visitor, pointTree, docCount);
                            } while (pointTree.moveToSibling() && docCount[0] < (long)ApproximatePointRangeQuery.this.size);
                            pointTree.moveToParent();
                            break;
                        }
                        if (docCount[0] >= (long)ApproximatePointRangeQuery.this.size) break;
                        pointTree.visitDocIDs(visitor);
                        break;
                    }
                    case CELL_CROSSES_QUERY: {
                        if (pointTree.moveToChild() && docCount[0] < (long)ApproximatePointRangeQuery.this.size) {
                            do {
                                this.intersectLeft(visitor, pointTree, docCount);
                            } while (pointTree.moveToSibling() && docCount[0] < (long)ApproximatePointRangeQuery.this.size);
                            pointTree.moveToParent();
                            break;
                        }
                        if (docCount[0] >= (long)ApproximatePointRangeQuery.this.size) break;
                        pointTree.visitDocValues(visitor);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unreachable code");
                    }
                }
            }

            public void intersectRight(PointValues.IntersectVisitor visitor, PointValues.PointTree pointTree, long[] docCount) throws IOException {
                PointValues.Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
                if (docCount[0] >= (long)ApproximatePointRangeQuery.this.size) {
                    return;
                }
                switch (r) {
                    case CELL_OUTSIDE_QUERY: {
                        break;
                    }
                    case CELL_INSIDE_QUERY: {
                        if (pointTree.size() > (long)ApproximatePointRangeQuery.this.size && docCount[0] < (long)ApproximatePointRangeQuery.this.size && this.moveRight(pointTree)) {
                            this.intersectRight(visitor, pointTree, docCount);
                            pointTree.moveToParent();
                            break;
                        }
                        if (pointTree.size() <= (long)ApproximatePointRangeQuery.this.size && docCount[0] < (long)ApproximatePointRangeQuery.this.size) {
                            pointTree.moveToParent();
                            this.intersectLeft(visitor, pointTree, docCount);
                            break;
                        }
                        if (docCount[0] >= (long)ApproximatePointRangeQuery.this.size) break;
                        pointTree.visitDocIDs(visitor);
                        break;
                    }
                    case CELL_CROSSES_QUERY: {
                        if (pointTree.size() > (long)ApproximatePointRangeQuery.this.size && docCount[0] < (long)ApproximatePointRangeQuery.this.size && this.moveRight(pointTree)) {
                            this.intersectRight(visitor, pointTree, docCount);
                            pointTree.moveToParent();
                            break;
                        }
                        if (pointTree.size() <= (long)ApproximatePointRangeQuery.this.size && docCount[0] < (long)ApproximatePointRangeQuery.this.size) {
                            pointTree.moveToParent();
                            this.intersectLeft(visitor, pointTree, docCount);
                            break;
                        }
                        if (docCount[0] >= (long)ApproximatePointRangeQuery.this.size) break;
                        pointTree.visitDocValues(visitor);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unreachable code");
                    }
                }
            }

            public boolean moveRight(PointValues.PointTree pointTree) throws IOException {
                return pointTree.moveToChild() && pointTree.moveToSibling();
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final long[] docCount = new long[]{0L};
                final PointValues values = reader.getPointValues(ApproximatePointRangeQuery.this.pointRangeQuery.getField());
                if (!this.checkValidPointValues(values)) {
                    return null;
                }
                if ((long)ApproximatePointRangeQuery.this.size > values.size()) {
                    return pointRangeQueryWeight.scorerSupplier(context);
                }
                if (ApproximatePointRangeQuery.this.sortOrder == null || ApproximatePointRangeQuery.this.sortOrder.equals((Object)SortOrder.ASC)) {
                    return new ScorerSupplier(){
                        final DocIdSetBuilder result;
                        final PointValues.IntersectVisitor visitor;
                        long cost;
                        {
                            this.result = new DocIdSetBuilder(reader.maxDoc(), values, ApproximatePointRangeQuery.this.pointRangeQuery.getField());
                            this.visitor = this.getIntersectVisitor(this.result, docCount);
                            this.cost = -1L;
                        }

                        public Scorer get(long leadCost) throws IOException {
                            this.intersectLeft(values.getPointTree(), this.visitor, docCount);
                            DocIdSetIterator iterator = this.result.build().iterator();
                            return new ConstantScoreScorer(this.score(), scoreMode, iterator);
                        }

                        public long cost() {
                            if (this.cost == -1L) {
                                this.cost = values.estimateDocCount(this.visitor);
                                assert (this.cost >= 0L);
                            }
                            return this.cost;
                        }
                    };
                }
                int deletedDocs = reader.numDeletedDocs();
                ApproximatePointRangeQuery.this.size += deletedDocs;
                return new ScorerSupplier(){
                    final DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    long cost;
                    {
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, ApproximatePointRangeQuery.this.pointRangeQuery.getField());
                        this.visitor = this.getIntersectVisitor(this.result, docCount);
                        this.cost = -1L;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        this.intersectRight(values.getPointTree(), this.visitor, docCount);
                        DocIdSetIterator iterator = this.result.build().iterator();
                        return new ConstantScoreScorer(this.score(), scoreMode, iterator);
                    }

                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(this.visitor);
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            public int count(LeafReaderContext context) throws IOException {
                return pointRangeQueryWeight.count(context);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    @Override
    public boolean canApproximate(SearchContext context) {
        if (context == null) {
            return false;
        }
        if (context.aggregations() != null) {
            return false;
        }
        if (context.trackTotalHitsUpTo() == Integer.MAX_VALUE) {
            return false;
        }
        if (context.from() + context.size() == 0) {
            this.setSize(10000);
        } else {
            this.setSize(Math.max(context.from() + context.size(), context.trackTotalHitsUpTo() + 1));
        }
        if (context.request() != null && context.request().source() != null) {
            FieldSortBuilder primarySortField = FieldSortBuilder.getPrimaryFieldSortOrNull(context.request().source());
            if (primarySortField != null) {
                if (!primarySortField.fieldName().equals(this.pointRangeQuery.getField())) {
                    return false;
                }
                if (primarySortField.missing() != null) {
                    return false;
                }
                if (context.request().source().searchAfter() != null) {
                    return false;
                }
                this.setSortOrder(primarySortField.order());
            }
            return context.request().source().terminateAfter() == 0;
        }
        return true;
    }

    public final int hashCode() {
        return this.pointRangeQuery.hashCode();
    }

    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((ApproximatePointRangeQuery)((Object)((Object)((Object)this)).getClass().cast(o)));
    }

    private boolean equalsTo(ApproximatePointRangeQuery other) {
        return Objects.equals(this.pointRangeQuery, other.pointRangeQuery);
    }

    public final String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("Approximate(");
        sb.append(this.pointRangeQuery.toString());
        sb.append(")");
        return sb.toString();
    }
}

