/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.DimensionFilterMergerUtils;
import org.opensearch.search.startree.filter.StarTreeFilter;
import org.opensearch.search.startree.filter.provider.DimensionFilterMapper;
import org.opensearch.search.startree.filter.provider.StarTreeFilterProvider;

public class BoolStarTreeFilterProvider
implements StarTreeFilterProvider {
    private static final Set<Class<? extends QueryBuilder>> SUPPORTED_NON_BOOL_QUERIES = Set.of(TermQueryBuilder.class, TermsQueryBuilder.class, RangeQueryBuilder.class);

    @Override
    public StarTreeFilter getFilter(SearchContext context, QueryBuilder rawFilter, CompositeDataCubeFieldType compositeFieldType) throws IOException {
        return this.processBoolQuery((BoolQueryBuilder)rawFilter, context, compositeFieldType);
    }

    private StarTreeFilter processBoolQuery(BoolQueryBuilder boolQuery, SearchContext context, CompositeDataCubeFieldType compositeFieldType) throws IOException {
        if (!boolQuery.hasClauses()) {
            return null;
        }
        if (boolQuery.minimumShouldMatch() != null) {
            return null;
        }
        if (!boolQuery.must().isEmpty() || !boolQuery.filter().isEmpty()) {
            return this.processMustClauses(this.getCombinedMustAndFilterClauses(boolQuery), context, compositeFieldType);
        }
        if (!boolQuery.should().isEmpty()) {
            return this.processShouldClauses(boolQuery.should(), context, compositeFieldType);
        }
        return null;
    }

    private StarTreeFilter processNonBoolSupportedQueries(QueryBuilder query, SearchContext context, CompositeDataCubeFieldType compositeFieldType) throws IOException {
        if (!SUPPORTED_NON_BOOL_QUERIES.contains(query.getClass())) {
            return null;
        }
        StarTreeFilterProvider provider = StarTreeFilterProvider.SingletonFactory.getProvider(query);
        if (provider == null) {
            return null;
        }
        return provider.getFilter(context, query, compositeFieldType);
    }

    private StarTreeFilter processMustClauses(List<QueryBuilder> mustClauses, SearchContext context, CompositeDataCubeFieldType compositeFieldType) throws IOException {
        if (mustClauses.isEmpty()) {
            return null;
        }
        HashMap<String, List<DimensionFilter>> dimensionToFilters = new HashMap<String, List<DimensionFilter>>();
        for (QueryBuilder clause : mustClauses) {
            StarTreeFilter clauseFilter = clause instanceof BoolQueryBuilder ? this.processBoolQuery((BoolQueryBuilder)clause, context, compositeFieldType) : this.processNonBoolSupportedQueries(clause, context, compositeFieldType);
            if (clauseFilter == null) {
                return null;
            }
            for (String dimension : clauseFilter.getDimensions()) {
                List existingFilters = (List)dimensionToFilters.get(dimension);
                List<DimensionFilter> newFilters = clauseFilter.getFiltersForDimension(dimension);
                if (existingFilters == null) {
                    dimensionToFilters.put(dimension, new ArrayList<DimensionFilter>(newFilters));
                    continue;
                }
                DimensionFilterMapper mapper = DimensionFilterMapper.Factory.fromMappedFieldType(context.mapperService().fieldType(dimension));
                if (mapper == null) {
                    return null;
                }
                if (newFilters.size() > 1) {
                    ArrayList<DimensionFilter> intersectedFilters = new ArrayList<DimensionFilter>();
                    for (DimensionFilter shouldFilter : newFilters) {
                        for (DimensionFilter existingFilter : existingFilters) {
                            DimensionFilter intersected = DimensionFilterMergerUtils.intersect(existingFilter, shouldFilter, mapper);
                            if (intersected == null) continue;
                            intersectedFilters.add(intersected);
                        }
                    }
                    if (intersectedFilters.isEmpty()) {
                        return null;
                    }
                    dimensionToFilters.put(dimension, intersectedFilters);
                    continue;
                }
                DimensionFilter mergedFilter = DimensionFilterMergerUtils.intersect((DimensionFilter)existingFilters.getFirst(), newFilters.getFirst(), mapper);
                if (mergedFilter == null) {
                    return null;
                }
                dimensionToFilters.put(dimension, Collections.singletonList(mergedFilter));
            }
        }
        return new StarTreeFilter(dimensionToFilters);
    }

    private StarTreeFilter processShouldClauses(List<QueryBuilder> shouldClauses, SearchContext context, CompositeDataCubeFieldType compositeFieldType) throws IOException {
        if (shouldClauses.isEmpty()) {
            return null;
        }
        String commonDimension = null;
        HashMap<String, List<DimensionFilter>> dimensionToFilters = new HashMap<String, List<DimensionFilter>>();
        for (QueryBuilder clause : shouldClauses) {
            StarTreeFilter clauseFilter = clause instanceof BoolQueryBuilder ? this.processBoolQuery((BoolQueryBuilder)clause, context, compositeFieldType) : this.processNonBoolSupportedQueries(clause, context, compositeFieldType);
            if (clauseFilter == null) {
                return null;
            }
            if (clauseFilter.getDimensions().size() != 1) {
                return null;
            }
            String dimension = clauseFilter.getDimensions().iterator().next();
            if (commonDimension == null) {
                commonDimension = dimension;
            } else if (!commonDimension.equals(dimension)) {
                return null;
            }
            dimensionToFilters.computeIfAbsent(dimension, k -> new ArrayList()).addAll(clauseFilter.getFiltersForDimension(dimension));
        }
        return new StarTreeFilter(dimensionToFilters);
    }

    private List<QueryBuilder> getCombinedMustAndFilterClauses(BoolQueryBuilder boolQuery) {
        ArrayList<QueryBuilder> mustAndFilterClauses = new ArrayList<QueryBuilder>();
        mustAndFilterClauses.addAll(boolQuery.must());
        mustAndFilterClauses.addAll(boolQuery.filter());
        return mustAndFilterClauses;
    }
}

