/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.DimensionDataType;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.provider.DoubleFieldMapperNumeric;
import org.opensearch.search.startree.filter.provider.FloatFieldMapperNumeric;
import org.opensearch.search.startree.filter.provider.HalfFloatFieldMapperNumeric;
import org.opensearch.search.startree.filter.provider.IntegerFieldMapperNumeric;
import org.opensearch.search.startree.filter.provider.KeywordFieldMapper;
import org.opensearch.search.startree.filter.provider.SignedLongFieldMapperNumeric;
import org.opensearch.search.startree.filter.provider.UnsignedLongFieldMapperNumeric;

@ExperimentalApi
public interface DimensionFilterMapper {
    public DimensionFilter getExactMatchFilter(MappedFieldType var1, List<Object> var2);

    public DimensionFilter getRangeMatchFilter(MappedFieldType var1, Object var2, Object var3, boolean var4, boolean var5);

    public Optional<Long> getMatchingOrdinal(String var1, Object var2, StarTreeValues var3, DimensionFilter.MatchType var4);

    public int compareValues(Object var1, Object var2);

    default public boolean isValueInRange(Object value, Object low, Object high, boolean includeLow, boolean includeHigh) {
        int comparison;
        if (low != null && ((comparison = this.compareValues(value, low)) < 0 || comparison == 0 && !includeLow)) {
            return false;
        }
        return high == null || (comparison = this.compareValues(value, high)) <= 0 && (comparison != 0 || includeHigh);
    }

    default public boolean isValidRange(Object low, Object high, boolean includeLow, boolean includeHigh) {
        if (low == null || high == null) {
            return true;
        }
        int comparison = this.compareValues(low, high);
        return comparison < 0 || comparison == 0 && includeLow && includeHigh;
    }

    default public Comparator<Long> comparator() {
        return DimensionDataType.LONG::compare;
    }

    public static class Factory {
        private static final Map<String, DimensionFilterMapper> DIMENSION_FILTER_MAPPINGS = Map.of(NumberFieldMapper.NumberType.BYTE.typeName(), new IntegerFieldMapperNumeric(), NumberFieldMapper.NumberType.SHORT.typeName(), new IntegerFieldMapperNumeric(), NumberFieldMapper.NumberType.INTEGER.typeName(), new IntegerFieldMapperNumeric(), NumberFieldMapper.NumberType.LONG.typeName(), new SignedLongFieldMapperNumeric(), NumberFieldMapper.NumberType.HALF_FLOAT.typeName(), new HalfFloatFieldMapperNumeric(), NumberFieldMapper.NumberType.FLOAT.typeName(), new FloatFieldMapperNumeric(), NumberFieldMapper.NumberType.DOUBLE.typeName(), new DoubleFieldMapperNumeric(), "keyword", new KeywordFieldMapper(), NumberFieldMapper.NumberType.UNSIGNED_LONG.typeName(), new UnsignedLongFieldMapperNumeric());

        public static DimensionFilterMapper fromMappedFieldType(MappedFieldType mappedFieldType) {
            if (mappedFieldType != null) {
                return DIMENSION_FILTER_MAPPINGS.get(mappedFieldType.typeName());
            }
            return null;
        }
    }
}

