/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.join.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.search.MaxScoreCollector;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.index.query.InnerHitBuilder;
import org.opensearch.index.query.InnerHitContextBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.join.mapper.ParentIdFieldMapper;
import org.opensearch.join.mapper.ParentJoinFieldMapper;
import org.opensearch.search.SearchHit;
import org.opensearch.search.fetch.subphase.InnerHitsContext;
import org.opensearch.search.internal.SearchContext;

class ParentChildInnerHitContextBuilder
extends InnerHitContextBuilder {
    private final String typeName;
    private final boolean fetchChildInnerHits;

    ParentChildInnerHitContextBuilder(String typeName, boolean fetchChildInnerHits, QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
        super(query, innerHitBuilder, children);
        this.typeName = typeName;
        this.fetchChildInnerHits = fetchChildInnerHits;
    }

    protected void doBuild(SearchContext context, InnerHitsContext innerHitsContext) throws IOException {
        QueryShardContext queryShardContext = context.getQueryShardContext();
        ParentJoinFieldMapper joinFieldMapper = ParentJoinFieldMapper.getMapper(context.mapperService());
        if (joinFieldMapper != null) {
            String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.typeName;
            JoinFieldInnerHitSubContext joinFieldInnerHits = new JoinFieldInnerHitSubContext(name, context, this.typeName, this.fetchChildInnerHits, joinFieldMapper);
            this.setupInnerHitsContext(queryShardContext, joinFieldInnerHits);
            innerHitsContext.addInnerHitDefinition((InnerHitsContext.InnerHitSubContext)joinFieldInnerHits);
        } else if (!this.innerHitBuilder.isIgnoreUnmapped()) {
            throw new IllegalStateException("no join field has been configured");
        }
    }

    static final class JoinFieldInnerHitSubContext
    extends InnerHitsContext.InnerHitSubContext {
        private final String typeName;
        private final boolean fetchChildInnerHits;
        private final ParentJoinFieldMapper joinFieldMapper;

        JoinFieldInnerHitSubContext(String name, SearchContext context, String typeName, boolean fetchChildInnerHits, ParentJoinFieldMapper joinFieldMapper) {
            super(name, context);
            this.typeName = typeName;
            this.fetchChildInnerHits = fetchChildInnerHits;
            this.joinFieldMapper = joinFieldMapper;
        }

        public TopDocsAndMaxScore topDocs(SearchHit hit) throws IOException {
            TopScoreDocCollector topDocsCollector;
            Query q;
            Weight innerHitQueryWeight = this.getInnerHitQueryWeight();
            String joinName = this.getSortedDocValue(this.joinFieldMapper.name(), this.context, hit.docId());
            if (joinName == null) {
                return new TopDocsAndMaxScore(Lucene.EMPTY_TOP_DOCS, Float.NaN);
            }
            QueryShardContext qsc = this.context.getQueryShardContext();
            ParentIdFieldMapper parentIdFieldMapper = this.joinFieldMapper.getParentIdFieldMapper(this.typeName, !this.fetchChildInnerHits);
            if (parentIdFieldMapper == null) {
                return new TopDocsAndMaxScore(Lucene.EMPTY_TOP_DOCS, Float.NaN);
            }
            if (this.fetchChildInnerHits) {
                Query hitQuery = parentIdFieldMapper.fieldType().termQuery((Object)hit.getId(), qsc);
                q = new BooleanQuery.Builder().add(hitQuery, BooleanClause.Occur.FILTER).add(this.joinFieldMapper.fieldType().termQuery(this.typeName, qsc), BooleanClause.Occur.FILTER).build();
            } else {
                String parentId = this.getSortedDocValue(parentIdFieldMapper.name(), this.context, hit.docId());
                if (parentId == null) {
                    return new TopDocsAndMaxScore(Lucene.EMPTY_TOP_DOCS, Float.NaN);
                }
                q = this.context.mapperService().fieldType("_id").termQuery((Object)parentId, qsc);
            }
            Weight weight = this.context.searcher().createWeight(this.context.searcher().rewrite(q), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            if (this.size() == 0) {
                TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
                for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                    InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)totalHitCountCollector, (LeafReaderContext)ctx);
                }
                return new TopDocsAndMaxScore(new TopDocs(new TotalHits((long)totalHitCountCollector.getTotalHits(), TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN);
            }
            int topN = Math.min(this.from() + this.size(), this.context.searcher().getIndexReader().maxDoc());
            MaxScoreCollector maxScoreCollector = null;
            if (this.sort() != null) {
                topDocsCollector = new TopFieldCollectorManager(this.sort().sort, topN, null, Integer.MAX_VALUE, false).newCollector();
                if (this.trackScores()) {
                    maxScoreCollector = new MaxScoreCollector();
                }
            } else {
                topDocsCollector = new TopScoreDocCollectorManager(topN, null, Integer.MAX_VALUE, false).newCollector();
                maxScoreCollector = new MaxScoreCollector();
            }
            for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, maxScoreCollector}), (LeafReaderContext)ctx);
            }
            TopDocs topDocs = topDocsCollector.topDocs(this.from(), this.size());
            float maxScore = Float.NaN;
            if (maxScoreCollector != null) {
                maxScore = maxScoreCollector.getMaxScore();
            }
            return new TopDocsAndMaxScore(topDocs, maxScore);
        }

        private String getSortedDocValue(String field, SearchContext context, int docId) {
            try {
                List ctxs = context.searcher().getIndexReader().leaves();
                LeafReaderContext ctx = (LeafReaderContext)ctxs.get(ReaderUtil.subIndex((int)docId, (List)ctxs));
                SortedDocValues docValues = ctx.reader().getSortedDocValues(field);
                int segmentDocId = docId - ctx.docBase;
                if (docValues == null || !docValues.advanceExact(segmentDocId)) {
                    return null;
                }
                int ord = docValues.ordValue();
                BytesRef joinName = docValues.lookupOrd(ord);
                return joinName.utf8ToString();
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
            }
        }
    }
}

