/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.search.stats;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.metrics.MeanMetric;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.index.search.stats.SearchStats;
import org.opensearch.index.shard.SearchOperationListener;
import org.opensearch.search.internal.ReaderContext;
import org.opensearch.search.internal.SearchContext;

public final class ShardSearchStats
implements SearchOperationListener {
    private final StatsHolder totalStats = new StatsHolder();
    private final CounterMetric openContexts = new CounterMetric();
    private volatile Map<String, StatsHolder> groupsStats = Collections.emptyMap();

    public SearchStats stats(String ... groups) {
        HashMap<String, SearchStats.Stats> groupsSt;
        SearchStats.Stats total;
        block4: {
            total = this.totalStats.stats();
            groupsSt = null;
            if (CollectionUtils.isEmpty((Object[])groups)) break block4;
            groupsSt = new HashMap<String, SearchStats.Stats>(this.groupsStats.size());
            if (groups.length == 1 && groups[0].equals("_all")) {
                for (Map.Entry<String, StatsHolder> entry : this.groupsStats.entrySet()) {
                    groupsSt.put(entry.getKey(), entry.getValue().stats());
                }
            } else {
                for (Map.Entry<String, StatsHolder> entry : this.groupsStats.entrySet()) {
                    if (!Regex.simpleMatch(groups, entry.getKey())) continue;
                    groupsSt.put(entry.getKey(), entry.getValue().stats());
                }
            }
        }
        return new SearchStats(total, this.openContexts.count(), groupsSt);
    }

    @Override
    public void onPreQueryPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> {
            if (searchContext.hasOnlySuggest()) {
                statsHolder.suggestCurrent.inc();
            } else {
                statsHolder.queryCurrent.inc();
                if (searchContext.shouldUseConcurrentSearch()) {
                    statsHolder.concurrentQueryCurrent.inc();
                }
                if (searchContext.getQueryShardContext().getStarTreeQueryContext() != null) {
                    statsHolder.starTreeCurrent.inc();
                }
            }
        });
    }

    @Override
    public void onFailedQueryPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> {
            if (searchContext.hasOnlySuggest()) {
                statsHolder.suggestCurrent.dec();
                assert (statsHolder.suggestCurrent.count() >= 0L);
            } else {
                statsHolder.queryCurrent.dec();
                assert (statsHolder.queryCurrent.count() >= 0L);
                if (searchContext.shouldUseConcurrentSearch()) {
                    statsHolder.concurrentQueryCurrent.dec();
                    assert (statsHolder.concurrentQueryCurrent.count() >= 0L);
                }
                if (searchContext.getQueryShardContext().getStarTreeQueryContext() != null) {
                    statsHolder.starTreeCurrent.dec();
                    assert (statsHolder.starTreeCurrent.count() >= 0L);
                }
            }
        });
    }

    @Override
    public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
        this.computeStats(searchContext, statsHolder -> {
            if (searchContext.hasOnlySuggest()) {
                statsHolder.suggestMetric.inc(tookInNanos);
                statsHolder.suggestCurrent.dec();
                assert (statsHolder.suggestCurrent.count() >= 0L);
            } else {
                statsHolder.queryMetric.inc(tookInNanos);
                statsHolder.queryCurrent.dec();
                assert (statsHolder.queryCurrent.count() >= 0L);
                if (searchContext.shouldUseConcurrentSearch()) {
                    statsHolder.concurrentQueryMetric.inc(tookInNanos);
                    statsHolder.concurrentQueryCurrent.dec();
                    assert (statsHolder.concurrentQueryCurrent.count() >= 0L);
                    assert (searchContext.searcher().getSlices() != null);
                    statsHolder.queryConcurrencyMetric.inc(searchContext.searcher().getSlices().length);
                }
                if (searchContext.getQueryShardContext().getStarTreeQueryContext() != null) {
                    statsHolder.starTreeQueryMetric.inc(tookInNanos);
                    statsHolder.starTreeCurrent.dec();
                    assert (statsHolder.starTreeCurrent.count() >= 0L);
                }
            }
        });
    }

    @Override
    public void onPreFetchPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> statsHolder.fetchCurrent.inc());
    }

    @Override
    public void onFailedFetchPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> statsHolder.fetchCurrent.dec());
    }

    @Override
    public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
        this.computeStats(searchContext, statsHolder -> {
            statsHolder.fetchMetric.inc(tookInNanos);
            statsHolder.fetchCurrent.dec();
            assert (statsHolder.fetchCurrent.count() >= 0L);
        });
    }

    private void computeStats(SearchContext searchContext, Consumer<StatsHolder> consumer) {
        consumer.accept(this.totalStats);
        if (searchContext.groupStats() != null) {
            for (String group : searchContext.groupStats()) {
                consumer.accept(this.groupStats(group));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatsHolder groupStats(String group) {
        StatsHolder stats = this.groupsStats.get(group);
        if (stats == null) {
            ShardSearchStats shardSearchStats = this;
            synchronized (shardSearchStats) {
                stats = this.groupsStats.get(group);
                if (stats == null) {
                    stats = new StatsHolder();
                    this.groupsStats = MapBuilder.newMapBuilder(this.groupsStats).put((Object)group, (Object)stats).immutableMap();
                }
            }
        }
        return stats;
    }

    @Override
    public void onNewReaderContext(ReaderContext readerContext) {
        this.openContexts.inc();
    }

    @Override
    public void onFreeReaderContext(ReaderContext readerContext) {
        this.openContexts.dec();
    }

    @Override
    public void onNewScrollContext(ReaderContext readerContext) {
        this.totalStats.scrollCurrent.inc();
    }

    @Override
    public void onFreeScrollContext(ReaderContext readerContext) {
        this.totalStats.scrollCurrent.dec();
        assert (this.totalStats.scrollCurrent.count() >= 0L);
        this.totalStats.scrollMetric.inc(TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - readerContext.getStartTimeInNano()));
    }

    @Override
    public void onNewPitContext(ReaderContext readerContext) {
        this.totalStats.pitCurrent.inc();
    }

    @Override
    public void onFreePitContext(ReaderContext readerContext) {
        this.totalStats.pitCurrent.dec();
        assert (this.totalStats.pitCurrent.count() >= 0L);
        this.totalStats.pitMetric.inc(TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - readerContext.getStartTimeInNano()));
    }

    @Override
    public void onSearchIdleReactivation() {
        this.totalStats.searchIdleMetric.inc();
    }

    static final class StatsHolder {
        final MeanMetric queryMetric = new MeanMetric();
        final MeanMetric concurrentQueryMetric = new MeanMetric();
        final CounterMetric queryConcurrencyMetric = new CounterMetric();
        final MeanMetric fetchMetric = new MeanMetric();
        final MeanMetric scrollMetric = new MeanMetric();
        final MeanMetric pitMetric = new MeanMetric();
        final MeanMetric suggestMetric = new MeanMetric();
        final CounterMetric queryCurrent = new CounterMetric();
        final CounterMetric concurrentQueryCurrent = new CounterMetric();
        final CounterMetric fetchCurrent = new CounterMetric();
        final CounterMetric scrollCurrent = new CounterMetric();
        final CounterMetric pitCurrent = new CounterMetric();
        final CounterMetric suggestCurrent = new CounterMetric();
        final CounterMetric searchIdleMetric = new CounterMetric();
        final MeanMetric starTreeQueryMetric = new MeanMetric();
        final CounterMetric starTreeCurrent = new CounterMetric();

        StatsHolder() {
        }

        SearchStats.Stats stats() {
            return new SearchStats.Stats.Builder().queryCount(this.queryMetric.count()).queryTimeInMillis(TimeUnit.NANOSECONDS.toMillis(this.queryMetric.sum())).queryCurrent(this.queryCurrent.count()).concurrentQueryCount(this.concurrentQueryMetric.count()).concurrentQueryTimeInMillis(TimeUnit.NANOSECONDS.toMillis(this.concurrentQueryMetric.sum())).concurrentQueryCurrent(this.concurrentQueryCurrent.count()).queryConcurrency(this.queryConcurrencyMetric.count()).fetchCount(this.fetchMetric.count()).fetchTimeInMillis(TimeUnit.NANOSECONDS.toMillis(this.fetchMetric.sum())).fetchCurrent(this.fetchCurrent.count()).scrollCount(this.scrollMetric.count()).scrollTimeInMillis(TimeUnit.MICROSECONDS.toMillis(this.scrollMetric.sum())).scrollCurrent(this.scrollCurrent.count()).pitCount(this.pitMetric.count()).pitTimeInMillis(TimeUnit.MICROSECONDS.toMillis(this.pitMetric.sum())).pitCurrent(this.pitCurrent.count()).suggestCount(this.suggestMetric.count()).suggestTimeInMillis(TimeUnit.NANOSECONDS.toMillis(this.suggestMetric.sum())).suggestCurrent(this.suggestCurrent.count()).searchIdleReactivateCount(this.searchIdleMetric.count()).starTreeQueryCount(this.starTreeQueryMetric.count()).starTreeQueryTimeInMillis(TimeUnit.NANOSECONDS.toMillis(this.starTreeQueryMetric.sum())).starTreeQueryCurrent(this.starTreeCurrent.count()).build();
        }
    }
}

