/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport.handler;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.transport.handler.ResultIndexingHandler;
import org.opensearch.timeseries.util.ClientUtil;
import org.opensearch.timeseries.util.IndexUtils;
import org.opensearch.timeseries.util.RestHandlerUtils;

public class ResultBulkIndexingHandler<ResultType extends IndexableResult, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>>
extends ResultIndexingHandler<ResultType, IndexType, IndexManagementType> {
    private static final Logger LOG = LogManager.getLogger(ResultBulkIndexingHandler.class);

    public ResultBulkIndexingHandler(Client client, Settings settings, ThreadPool threadPool, String indexName, IndexManagementType timeSeriesIndices, ClientUtil clientUtil, IndexUtils indexUtils, ClusterService clusterService, Setting<TimeValue> backOffDelaySetting, Setting<Integer> maxRetrySetting) {
        super(client, settings, threadPool, indexName, timeSeriesIndices, clientUtil, indexUtils, clusterService, backOffDelaySetting, maxRetrySetting);
    }

    public void bulk(String resultIndexOrAlias, List<ResultType> results, String configId, ActionListener<BulkResponse> listener) {
        if (results == null || results.size() == 0) {
            listener.onResponse(null);
            return;
        }
        try {
            if (resultIndexOrAlias != null) {
                if (!this.timeSeriesIndices.doesIndexExist(resultIndexOrAlias) && !this.timeSeriesIndices.doesAliasExist(resultIndexOrAlias)) {
                    this.timeSeriesIndices.initCustomResultIndexDirectly(resultIndexOrAlias, (ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                        if (response.isAcknowledged()) {
                            this.bulk(resultIndexOrAlias, results, listener);
                        } else {
                            String error = "Creating custom result index with mappings call not acknowledged";
                            LOG.error(error);
                            listener.onFailure((Exception)new TimeSeriesException(error));
                        }
                    }, exception -> {
                        if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                            this.bulk(resultIndexOrAlias, results, listener);
                        } else {
                            listener.onFailure(exception);
                        }
                    }));
                } else {
                    this.timeSeriesIndices.validateResultIndexMapping(resultIndexOrAlias, (ActionListener<Boolean>)ActionListener.wrap(valid -> {
                        if (!valid.booleanValue()) {
                            throw new EndRunException(configId, "wrong index mapping of custom result index", true);
                        }
                        this.bulk(resultIndexOrAlias, results, listener);
                    }, arg_0 -> listener.onFailure(arg_0)));
                }
                return;
            }
            if (!this.timeSeriesIndices.doesDefaultResultIndexExist()) {
                this.timeSeriesIndices.initDefaultResultIndexDirectly((ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                    if (response.isAcknowledged()) {
                        this.bulk(results, listener);
                    } else {
                        String error = "Creating result index with mappings call not acknowledged";
                        LOG.error(error);
                        listener.onFailure((Exception)new TimeSeriesException(error));
                    }
                }, exception -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                        this.bulk(results, listener);
                    } else {
                        listener.onFailure(exception);
                    }
                }));
            } else {
                this.bulk(results, listener);
            }
        }
        catch (TimeSeriesException e) {
            listener.onFailure((Exception)e);
        }
        catch (Exception e) {
            String error = "Failed to bulk index result";
            LOG.error(error, (Throwable)e);
            listener.onFailure((Exception)new TimeSeriesException(configId, error, e));
        }
    }

    private void bulk(List<ResultType> anomalyResults, ActionListener<BulkResponse> listener) {
        this.bulk(this.defaultResultIndexName, anomalyResults, listener);
    }

    private void bulk(String resultIndex, List<ResultType> results, ActionListener<BulkResponse> listener) {
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        results.forEach(analysisResult -> {
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                IndexRequest indexRequest = new IndexRequest(resultIndex).source(analysisResult.toXContent(builder, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE));
                bulkRequestBuilder.add(indexRequest);
            }
            catch (Exception e) {
                String error = "Failed to prepare request to bulk index results";
                LOG.error(error, (Throwable)e);
                throw new TimeSeriesException(error);
            }
        });
        this.client.bulk((BulkRequest)bulkRequestBuilder.request(), ActionListener.wrap(r -> {
            if (r.hasFailures()) {
                String failureMessage = r.buildFailureMessage();
                LOG.warn("Failed to bulk index result " + failureMessage);
                listener.onFailure((Exception)new TimeSeriesException(failureMessage));
            } else {
                listener.onResponse(r);
            }
        }, e -> {
            LOG.error("bulk index result failed", (Throwable)e);
            listener.onFailure(e);
        }));
    }
}

