/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADProfileAction;
import org.opensearch.commons.authuser.User;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.ExecuteResultResponseRecorder;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.model.FeatureData;
import org.opensearch.timeseries.transport.ResultResponse;
import org.opensearch.timeseries.transport.handler.ResultBulkIndexingHandler;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.transport.client.Client;

public class ExecuteADResultResponseRecorder
extends ExecuteResultResponseRecorder<ADIndex, ADIndexManagement, ADTaskCacheManager, ADTaskType, ADTask, ADTaskManager, AnomalyResult, ADProfileAction> {
    private static final Logger log = LogManager.getLogger(ExecuteADResultResponseRecorder.class);

    public ExecuteADResultResponseRecorder(ADIndexManagement indexManagement, ResultBulkIndexingHandler<AnomalyResult, ADIndex, ADIndexManagement> resultHandler, ADTaskManager taskManager, DiscoveryNodeFilterer nodeFilter, ThreadPool threadPool, Client client, NodeStateManager nodeStateManager, ADTaskCacheManager taskCacheManager, int rcfMinSamples) {
        super(indexManagement, resultHandler, taskManager, nodeFilter, threadPool, "ad-threadpool", client, nodeStateManager, taskCacheManager, rcfMinSamples, ADIndex.RESULT, AnalysisType.AD, ADProfileAction.INSTANCE);
    }

    @Override
    protected AnomalyResult createErrorResult(String configId, Instant dataStartTime, Instant dataEndTime, Instant executeEndTime, String errorMessage, User user) {
        return new AnomalyResult(configId, null, new ArrayList<FeatureData>(), dataStartTime, dataEndTime, executeEndTime, Instant.now(), errorMessage, Optional.empty(), user, ((ADIndexManagement)this.indexManagement).getSchemaVersion((ADIndex)this.resultIndex), null);
    }

    @Override
    protected void updateRealtimeTask(ResultResponse<AnomalyResult> response, String configId) {
        if (response.isHC() != null && response.isHC().booleanValue()) {
            if (((ADTaskManager)this.taskManager).skipUpdateRealtimeTask(configId, response.getError())) {
                return;
            }
            this.delayedUpdate(response, configId);
        } else {
            log.debug("Update latest realtime task for single stream detector {}, total updates: {}", (Object)configId, (Object)response.getRcfTotalUpdates());
            this.updateLatestRealtimeTask(configId, null, response.getRcfTotalUpdates(), response.getConfigIntervalInMinutes(), response.getError());
        }
    }
}

