/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.indices;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.transport.client.Client;

public class ADIndexManagement
extends IndexManagement<ADIndex> {
    private static final Logger logger = LogManager.getLogger(ADIndexManagement.class);
    public static final String AD_RESULT_HISTORY_INDEX_PATTERN = "<.opendistro-anomaly-results-history-{now/d}-1>";
    public static final String ALL_AD_RESULTS_INDEX_PATTERN = ".opendistro-anomaly-results*";

    public ADIndexManagement(Client client, ClusterService clusterService, ThreadPool threadPool, Settings settings, DiscoveryNodeFilterer nodeFilter, int maxUpdateRunningTimes, NamedXContentRegistry xContentRegistry) throws IOException {
        super(client, clusterService, threadPool, settings, nodeFilter, maxUpdateRunningTimes, ADIndex.class, (Integer)AnomalyDetectorSettings.AD_MAX_PRIMARY_SHARDS.get(settings), (TimeValue)AnomalyDetectorSettings.AD_RESULT_HISTORY_ROLLOVER_PERIOD.get(settings), (Long)AnomalyDetectorSettings.AD_RESULT_HISTORY_MAX_DOCS_PER_SHARD.get(settings), (TimeValue)AnomalyDetectorSettings.AD_RESULT_HISTORY_RETENTION_PERIOD.get(settings), ADIndex.RESULT.getMapping(), xContentRegistry, AnomalyDetector::parse, "opensearch-ad-plugin-result-");
        this.indexStates = new EnumMap(ADIndex.class);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_RESULT_HISTORY_MAX_DOCS_PER_SHARD, it -> {
            this.historyMaxDocs = it;
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_RESULT_HISTORY_ROLLOVER_PERIOD, it -> {
            this.historyRolloverPeriod = it;
            this.rescheduleRollover();
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_RESULT_HISTORY_RETENTION_PERIOD, it -> {
            this.historyRetentionPeriod = it;
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_MAX_PRIMARY_SHARDS, it -> {
            this.maxPrimaryShards = it;
        });
    }

    public static String getResultMappings() throws IOException {
        return ADIndexManagement.getMappings("mappings/anomaly-results.json");
    }

    public static String getFlattenedResultMappings() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map mapping = (Map)objectMapper.readValue(ADIndexManagement.class.getClassLoader().getResourceAsStream("mappings/anomaly-results.json"), Map.class);
        mapping.put("dynamic", true);
        return objectMapper.writeValueAsString((Object)mapping);
    }

    public static String getStateMappings() throws IOException {
        String detectionStateMappings = ADIndexManagement.getMappings("mappings/anomaly-detection-state.json");
        String detectorIndexMappings = ADIndexManagement.getConfigMappings();
        detectorIndexMappings = detectorIndexMappings.substring(detectorIndexMappings.indexOf("\"properties\""), detectorIndexMappings.lastIndexOf("}"));
        return detectionStateMappings.replace("DETECTOR_INDEX_MAPPING_PLACE_HOLDER", detectorIndexMappings);
    }

    public static String getCheckpointMappings() throws IOException {
        return ADIndexManagement.getMappings("mappings/anomaly-checkpoint.json");
    }

    @Override
    public boolean doesDefaultResultIndexExist() {
        return this.doesAliasExist(".opendistro-anomaly-results");
    }

    @Override
    public boolean doesStateIndexExist() {
        return this.doesIndexExist(".opendistro-anomaly-detection-state");
    }

    @Override
    public boolean doesCheckpointIndexExist() {
        return this.doesIndexExist(".opendistro-anomaly-checkpoints");
    }

    @Override
    public void initDefaultResultIndexDirectly(ActionListener<CreateIndexResponse> actionListener) {
        this.initResultIndexDirectly(AD_RESULT_HISTORY_INDEX_PATTERN, ".opendistro-anomaly-results", true, true, ADIndex.RESULT, actionListener);
    }

    @Override
    public void initStateIndex(ActionListener<CreateIndexResponse> actionListener) {
        try {
            CreateIndexRequest request = new CreateIndexRequest(".opendistro-anomaly-detection-state").mapping(ADIndexManagement.getStateMappings(), XContentType.JSON).settings(this.settings);
            this.adminClient.indices().create(request, this.markMappingUpToDate(ADIndex.STATE, actionListener));
        }
        catch (IOException e) {
            logger.error("Fail to init AD detection state index", (Throwable)e);
            actionListener.onFailure((Exception)e);
        }
    }

    @Override
    public void initCheckpointIndex(ActionListener<CreateIndexResponse> actionListener) {
        String mapping;
        try {
            mapping = ADIndexManagement.getCheckpointMappings();
        }
        catch (IOException e) {
            throw new EndRunException("", "Cannot find checkpoint mapping file", true);
        }
        CreateIndexRequest request = new CreateIndexRequest(".opendistro-anomaly-checkpoints").mapping(mapping, XContentType.JSON);
        this.choosePrimaryShards(request, true);
        this.adminClient.indices().create(request, this.markMappingUpToDate(ADIndex.CHECKPOINT, actionListener));
    }

    @Override
    protected void rolloverAndDeleteHistoryIndex() {
        this.rolloverAndDeleteHistoryIndex(".opendistro-anomaly-results", ALL_AD_RESULTS_INDEX_PATTERN, AD_RESULT_HISTORY_INDEX_PATTERN, ADIndex.RESULT);
    }

    @Override
    public void initConfigIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        super.initConfigIndex(this.markMappingUpToDate(ADIndex.CONFIG, actionListener));
    }

    @Override
    public void initJobIndex(ActionListener<CreateIndexResponse> actionListener) {
        super.initJobIndex(this.markMappingUpToDate(ADIndex.JOB, actionListener));
    }

    @Override
    protected IndexRequest createDummyIndexRequest(String resultIndex) throws IOException {
        AnomalyResult dummyResult = AnomalyResult.getDummyResult();
        return new IndexRequest(resultIndex).id("dummy_ad_result_id").source(dummyResult.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
    }

    @Override
    protected DeleteRequest createDummyDeleteRequest(String resultIndex) throws IOException {
        return new DeleteRequest(resultIndex).id("dummy_ad_result_id");
    }

    @Override
    public void initCustomResultIndexDirectly(String resultIndex, ActionListener<CreateIndexResponse> actionListener) {
        this.initResultIndexDirectly(this.getCustomResultIndexPattern(resultIndex), resultIndex, false, false, ADIndex.RESULT, actionListener);
    }
}

