/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.stats.ForecastStats;
import org.opensearch.forecast.transport.ForecastStatsNodesAction;
import org.opensearch.forecast.transport.StatsForecasterAction;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.SingleBucketAggregation;
import org.opensearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.stats.StatNames;
import org.opensearch.timeseries.transport.BaseStatsTransportAction;
import org.opensearch.timeseries.transport.StatsNodesResponse;
import org.opensearch.timeseries.transport.StatsRequest;
import org.opensearch.timeseries.transport.StatsResponse;
import org.opensearch.timeseries.util.MultiResponsesDelegateActionListener;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class StatsForecasterTransportAction
extends BaseStatsTransportAction {
    public final Logger logger = LogManager.getLogger(StatsForecasterTransportAction.class);
    private final String WITH_CATEGORY_FIELD = "with_category_field";
    private final String WITHOUT_CATEGORY_FIELD = "without_category_field";

    @Inject
    public StatsForecasterTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ForecastStats stats, ClusterService clusterService) {
        super(transportService, actionFilters, client, stats, clusterService, StatsForecasterAction.NAME);
    }

    @Override
    public void getClusterStats(Client client, MultiResponsesDelegateActionListener<StatsResponse> listener, StatsRequest statsRequest) {
        StatsResponse adStatsResponse = new StatsResponse();
        if ((statsRequest.getStatsToBeRetrieved().contains(StatNames.FORECASTER_COUNT.getName()) || statsRequest.getStatsToBeRetrieved().contains(StatNames.SINGLE_STREAM_FORECASTER_COUNT.getName()) || statsRequest.getStatsToBeRetrieved().contains(StatNames.HC_FORECASTER_COUNT.getName())) && this.clusterService.state().getRoutingTable().hasIndex(".opendistro-anomaly-detectors")) {
            ExistsQueryBuilder existsQuery = QueryBuilders.existsQuery((String)"category_field");
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().mustNot((QueryBuilder)existsQuery);
            FilterAggregationBuilder withFieldAgg = AggregationBuilders.filter((String)"with_category_field", (QueryBuilder)existsQuery);
            FilterAggregationBuilder withoutFieldAgg = AggregationBuilders.filter((String)"without_category_field", (QueryBuilder)boolQuery);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            searchSourceBuilder.size(0);
            searchSourceBuilder.aggregation((AggregationBuilder)withFieldAgg);
            searchSourceBuilder.aggregation((AggregationBuilder)withoutFieldAgg);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-anomaly-detectors"});
            searchRequest.source(searchSourceBuilder);
            client.search(searchRequest, ActionListener.wrap(searchResponse -> {
                SingleBucketAggregation withField = (SingleBucketAggregation)searchResponse.getAggregations().get("with_category_field");
                SingleBucketAggregation withoutField = (SingleBucketAggregation)searchResponse.getAggregations().get("without_category_field");
                if (statsRequest.getStatsToBeRetrieved().contains(StatNames.FORECASTER_COUNT.getName())) {
                    this.stats.getStat(StatNames.FORECASTER_COUNT.getName()).setValue(withField.getDocCount() + withoutField.getDocCount());
                }
                if (statsRequest.getStatsToBeRetrieved().contains(StatNames.SINGLE_STREAM_FORECASTER_COUNT.getName())) {
                    this.stats.getStat(StatNames.SINGLE_STREAM_FORECASTER_COUNT.getName()).setValue(withoutField.getDocCount());
                }
                if (statsRequest.getStatsToBeRetrieved().contains(StatNames.HC_FORECASTER_COUNT.getName())) {
                    this.stats.getStat(StatNames.HC_FORECASTER_COUNT.getName()).setValue(withField.getDocCount());
                }
                adStatsResponse.setClusterStats(this.getClusterStatsMap(statsRequest));
                listener.onResponse(adStatsResponse);
            }, e -> listener.onFailure((Exception)e)));
        } else {
            adStatsResponse.setClusterStats(this.getClusterStatsMap(statsRequest));
            listener.onResponse(adStatsResponse);
        }
    }

    @Override
    public void getNodeStats(Client client, MultiResponsesDelegateActionListener<StatsResponse> listener, StatsRequest statsRequest) {
        client.execute((ActionType)ForecastStatsNodesAction.INSTANCE, (ActionRequest)statsRequest, ActionListener.wrap(adStatsResponse -> {
            StatsResponse restStatsResponse = new StatsResponse();
            restStatsResponse.setStatsNodesResponse((StatsNodesResponse)((Object)adStatsResponse));
            listener.onResponse(restStatsResponse);
        }, listener::onFailure));
    }
}

