/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.AbstractProfileRunner;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.function.BiCheckedFunction;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.EntityProfile;
import org.opensearch.timeseries.model.EntityProfileName;
import org.opensearch.timeseries.model.EntityState;
import org.opensearch.timeseries.model.InitProgressProfile;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.transport.EntityProfileRequest;
import org.opensearch.timeseries.transport.EntityProfileResponse;
import org.opensearch.timeseries.util.MultiResponsesDelegateActionListener;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.client.Client;

public class EntityProfileRunner<EntityProfileActionType extends ActionType<EntityProfileResponse>>
extends AbstractProfileRunner {
    private final Logger logger = LogManager.getLogger(EntityProfileRunner.class);
    public static final String NOT_HC_DETECTOR_ERR_MSG = "This is not a high cardinality detector";
    static final String EMPTY_ENTITY_ATTRIBUTES = "Empty entity attributes";
    static final String NO_ENTITY = "Cannot find entity";
    private Client client;
    private SecurityClientUtil clientUtil;
    private NamedXContentRegistry xContentRegistry;
    private BiCheckedFunction<XContentParser, String, ? extends Config, IOException> configParser;
    private int maxCategoryFields;
    private AnalysisType analysisType;
    private EntityProfileActionType entityProfileAction;
    private String resultIndexAlias;
    private String configIdField;

    public EntityProfileRunner(Client client, SecurityClientUtil clientUtil, NamedXContentRegistry xContentRegistry, long requiredSamples, BiCheckedFunction<XContentParser, String, ? extends Config, IOException> configParser, int maxCategoryFields, AnalysisType analysisType, EntityProfileActionType entityProfileAction, String resultIndexAlias, String configIdField) {
        super(requiredSamples);
        this.client = client;
        this.clientUtil = clientUtil;
        this.xContentRegistry = xContentRegistry;
        this.configParser = configParser;
        this.maxCategoryFields = maxCategoryFields;
        this.analysisType = analysisType;
        this.entityProfileAction = entityProfileAction;
        this.resultIndexAlias = resultIndexAlias;
        this.configIdField = configIdField;
    }

    public void profile(String configId, Entity entityValue, Set<EntityProfileName> profilesToCollect, ActionListener<EntityProfile> listener) {
        if (profilesToCollect == null || profilesToCollect.size() == 0) {
            listener.onFailure((Exception)new IllegalArgumentException(CommonMessages.EMPTY_PROFILES_COLLECT));
            return;
        }
        GetRequest getDetectorRequest = new GetRequest(".opendistro-anomaly-detectors", configId);
        this.client.get(getDetectorRequest, ActionListener.wrap(getResponse -> {
            if (getResponse != null && getResponse.isExists()) {
                try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    Config config = this.configParser.apply(parser, configId);
                    List<String> categoryFields = config.getCategoryFields();
                    if (categoryFields == null || categoryFields.size() == 0) {
                        listener.onFailure((Exception)new IllegalArgumentException(NOT_HC_DETECTOR_ERR_MSG));
                    } else if (categoryFields.size() > this.maxCategoryFields) {
                        listener.onFailure((Exception)new IllegalArgumentException(CommonMessages.getTooManyCategoricalFieldErr(this.maxCategoryFields)));
                    } else {
                        this.validateEntity(entityValue, categoryFields, configId, profilesToCollect, config, listener);
                    }
                }
                catch (Exception t) {
                    listener.onFailure(t);
                }
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + configId, RestStatus.NOT_FOUND, new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void validateEntity(Entity entity, List<String> categoryFields, String detectorId, Set<EntityProfileName> profilesToCollect, Config config, ActionListener<EntityProfile> listener) {
        Map<String, String> attributes = entity.getAttributes();
        if (attributes == null) {
            listener.onFailure((Exception)new IllegalArgumentException(EMPTY_ENTITY_ATTRIBUTES));
            return;
        }
        if (attributes.size() != categoryFields.size()) {
            listener.onFailure((Exception)new IllegalArgumentException(NO_ENTITY));
            return;
        }
        for (String string : categoryFields) {
            if (attributes.containsKey(string)) continue;
            listener.onFailure((Exception)new IllegalArgumentException("Cannot find " + string));
            return;
        }
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().filter(config.getFilterQuery());
        for (TermQueryBuilder term : entity.getTermQueryForCustomerIndex()) {
            internalFilterQuery.filter((QueryBuilder)term);
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery).size(1);
        SearchRequest searchRequest = new SearchRequest(config.getIndices().toArray(new String[0]), searchSourceBuilder).preference(Preference.LOCAL.toString());
        ActionListener searchResponseListener = ActionListener.wrap(searchResponse -> {
            try {
                if (searchResponse.getHits().getHits().length == 0) {
                    listener.onFailure((Exception)new IllegalArgumentException(NO_ENTITY));
                    return;
                }
                this.prepareEntityProfile(listener, detectorId, entity, profilesToCollect, config, (String)categoryFields.get(0));
            }
            catch (Exception e) {
                listener.onFailure((Exception)new IllegalArgumentException(NO_ENTITY));
                return;
            }
        }, e -> listener.onFailure((Exception)new IllegalArgumentException(NO_ENTITY)));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), config.getId(), this.client, this.analysisType, searchResponseListener);
    }

    private void prepareEntityProfile(ActionListener<EntityProfile> listener, String detectorId, Entity entityValue, Set<EntityProfileName> profilesToCollect, Config config, String categoryField) {
        EntityProfileRequest request = new EntityProfileRequest(detectorId, entityValue, profilesToCollect);
        this.client.execute(this.entityProfileAction, (ActionRequest)request, ActionListener.wrap(r -> this.getJob(detectorId, entityValue, profilesToCollect, config, (EntityProfileResponse)((Object)r), listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void getJob(String detectorId, Entity entityValue, Set<EntityProfileName> profilesToCollect, Config config, EntityProfileResponse entityProfileResponse, ActionListener<EntityProfile> listener) {
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detector-jobs", detectorId);
        this.client.get(getRequest, ActionListener.wrap(getResponse -> {
            if (getResponse != null && getResponse.isExists()) {
                try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    Job job = Job.parse(parser);
                    int totalResponsesToWait = 0;
                    if (profilesToCollect.contains(EntityProfileName.INIT_PROGRESS) || profilesToCollect.contains(EntityProfileName.STATE)) {
                        ++totalResponsesToWait;
                    }
                    if (profilesToCollect.contains(EntityProfileName.ENTITY_INFO)) {
                        ++totalResponsesToWait;
                    }
                    if (profilesToCollect.contains(EntityProfileName.MODELS)) {
                        ++totalResponsesToWait;
                    }
                    MultiResponsesDelegateActionListener<EntityProfile> delegateListener = new MultiResponsesDelegateActionListener<EntityProfile>(listener, totalResponsesToWait, CommonMessages.FAIL_FETCH_ERR_MSG + String.valueOf(entityValue) + " of detector " + detectorId, false);
                    if (profilesToCollect.contains(EntityProfileName.MODELS)) {
                        EntityProfile.Builder builder = new EntityProfile.Builder();
                        if (!job.isEnabled()) {
                            delegateListener.onResponse(builder.build());
                        } else {
                            delegateListener.onResponse(builder.modelProfile(entityProfileResponse.getModelProfile()).build());
                        }
                    }
                    if (profilesToCollect.contains(EntityProfileName.INIT_PROGRESS) || profilesToCollect.contains(EntityProfileName.STATE)) {
                        this.profileStateRelated(entityProfileResponse.getTotalUpdates(), detectorId, entityValue, profilesToCollect, config, job, delegateListener);
                    }
                    if (profilesToCollect.contains(EntityProfileName.ENTITY_INFO)) {
                        long enabledTimeMs = job.getEnabledTime().toEpochMilli();
                        SearchRequest lastSampleTimeRequest = this.createLastSampleTimeRequest(detectorId, enabledTimeMs, entityValue, config.getCustomResultIndexPattern());
                        EntityProfile.Builder builder = new EntityProfile.Builder();
                        Optional<Boolean> isActiveOp = entityProfileResponse.isActive();
                        if (isActiveOp.isPresent()) {
                            builder.isActive(isActiveOp.get());
                        }
                        builder.lastActiveTimestampMs(entityProfileResponse.getLastActiveMs());
                        this.client.search(lastSampleTimeRequest, ActionListener.wrap(searchResponse -> {
                            Optional<Long> latestSampleTimeMs = ParseUtils.getLatestDataTime(searchResponse);
                            if (latestSampleTimeMs.isPresent()) {
                                builder.lastSampleTimestampMs(latestSampleTimeMs.get());
                            }
                            delegateListener.onResponse(builder.build());
                        }, exception -> {
                            if (exception instanceof IndexNotFoundException) {
                                this.logger.info("Result index hasn't been created", (Object)exception.getMessage());
                            } else {
                                this.logger.warn("fail to get last sample time", (Throwable)exception);
                            }
                            delegateListener.onResponse(builder.build());
                        }));
                    }
                }
                catch (Exception e) {
                    this.logger.error(CommonMessages.FAIL_TO_GET_PROFILE_MSG, (Throwable)e);
                    listener.onFailure(e);
                }
            } else {
                this.sendUnknownState(profilesToCollect, entityValue, true, listener);
            }
        }, exception -> {
            if (exception instanceof IndexNotFoundException) {
                this.logger.info(exception.getMessage());
                this.sendUnknownState(profilesToCollect, entityValue, true, listener);
            } else {
                this.logger.error(CommonMessages.FAIL_TO_GET_PROFILE_MSG + detectorId, (Throwable)exception);
                listener.onFailure(exception);
            }
        }));
    }

    private void profileStateRelated(long totalUpdates, String detectorId, Entity entityValue, Set<EntityProfileName> profilesToCollect, Config config, Job job, MultiResponsesDelegateActionListener<EntityProfile> delegateListener) {
        if (totalUpdates == 0L) {
            this.sendUnknownState(profilesToCollect, entityValue, false, delegateListener);
        } else if (!job.isEnabled()) {
            this.sendUnknownState(profilesToCollect, entityValue, false, delegateListener);
        } else if (totalUpdates >= this.requiredSamples) {
            this.sendRunningState(profilesToCollect, entityValue, delegateListener);
        } else {
            this.sendInitState(profilesToCollect, entityValue, config, totalUpdates, delegateListener);
        }
    }

    private void sendUnknownState(Set<EntityProfileName> profilesToCollect, Entity entityValue, boolean immediate, ActionListener<EntityProfile> delegateListener) {
        EntityProfile.Builder builder = new EntityProfile.Builder();
        if (profilesToCollect.contains(EntityProfileName.STATE)) {
            builder.state(EntityState.UNKNOWN);
        }
        if (immediate) {
            delegateListener.onResponse((Object)builder.build());
        } else {
            delegateListener.onResponse((Object)builder.build());
        }
    }

    private void sendRunningState(Set<EntityProfileName> profilesToCollect, Entity entityValue, MultiResponsesDelegateActionListener<EntityProfile> delegateListener) {
        EntityProfile.Builder builder = new EntityProfile.Builder();
        if (profilesToCollect.contains(EntityProfileName.STATE)) {
            builder.state(EntityState.RUNNING);
        }
        if (profilesToCollect.contains(EntityProfileName.INIT_PROGRESS)) {
            InitProgressProfile initProgress = new InitProgressProfile("100%", 0L, 0);
            builder.initProgress(initProgress);
        }
        delegateListener.onResponse(builder.build());
    }

    private void sendInitState(Set<EntityProfileName> profilesToCollect, Entity entityValue, Config config, long updates, MultiResponsesDelegateActionListener<EntityProfile> delegateListener) {
        EntityProfile.Builder builder = new EntityProfile.Builder();
        if (profilesToCollect.contains(EntityProfileName.STATE)) {
            builder.state(EntityState.INIT);
        }
        if (profilesToCollect.contains(EntityProfileName.INIT_PROGRESS)) {
            long intervalMins = ((IntervalTimeConfiguration)config.getInterval()).toDuration().toMinutes();
            InitProgressProfile initProgress = this.computeInitProgressProfile(updates, intervalMins);
            builder.initProgress(initProgress);
        }
        delegateListener.onResponse(builder.build());
    }

    private SearchRequest createLastSampleTimeRequest(String configId, long enabledTime, Entity entity, String resultIndex) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        for (NestedQueryBuilder nestedNameQueryBuilder : entity.getTermQueryForResultIndex()) {
            boolQueryBuilder.filter((QueryBuilder)nestedNameQueryBuilder);
        }
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)this.configIdField, (String)configId));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"execution_end_time").gte((Object)enabledTime));
        SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).aggregation((AggregationBuilder)AggregationBuilders.max((String)"max_timefield").field("execution_end_time")).trackTotalHits(false).size(0);
        SearchRequest request = new SearchRequest(new String[]{this.resultIndexAlias});
        request.source(source);
        if (resultIndex != null) {
            request.indices(new String[]{resultIndex});
        }
        return request;
    }
}

