/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import com.google.common.base.Throwables;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.InjectSecurity;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.ExecuteResultResponseRecorder;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.InternalFailure;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.model.TaskState;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.rest.handler.IndexJobActionHandler;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.transport.JobResponse;
import org.opensearch.timeseries.transport.ProfileResponse;
import org.opensearch.timeseries.transport.ResultRequest;
import org.opensearch.timeseries.transport.ResultResponse;
import org.opensearch.timeseries.util.SecurityUtil;
import org.opensearch.transport.client.Client;

public abstract class JobProcessor<IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>, IndexableResultType extends IndexableResult, ProfileActionType extends ActionType<ProfileResponse>, ExecuteResultResponseRecorderType extends ExecuteResultResponseRecorder<IndexType, IndexManagementType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType, IndexableResultType, ProfileActionType>, IndexJobActionHandlerType extends IndexJobActionHandler<IndexType, IndexManagementType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType, IndexableResultType, ProfileActionType, ExecuteResultResponseRecorderType>> {
    private static final Logger log = LogManager.getLogger(JobProcessor.class);
    private Settings settings;
    private int maxRetryForEndRunException;
    private Client client;
    private ThreadPool threadPool;
    private ConcurrentHashMap<String, Integer> endRunExceptionCount = new ConcurrentHashMap();
    protected IndexManagementType indexManagement;
    private TaskManagerType taskManager;
    private NodeStateManager nodeStateManager;
    private ExecuteResultResponseRecorderType recorder;
    private AnalysisType analysisType;
    private String threadPoolName;
    private ActionType<? extends ResultResponse<IndexableResultType>> resultAction;
    private IndexJobActionHandlerType indexJobActionHandler;

    protected JobProcessor(AnalysisType analysisType, String threadPoolName, ActionType<? extends ResultResponse<IndexableResultType>> resultAction) {
        this.analysisType = analysisType;
        this.threadPoolName = threadPoolName;
        this.resultAction = resultAction;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    protected void registerSettings(Settings settings, Setting<Integer> maxRetryForEndRunExceptionSetting) {
        this.settings = settings;
        this.maxRetryForEndRunException = (Integer)maxRetryForEndRunExceptionSetting.get(settings);
    }

    public void setTaskManager(TaskManagerType adTaskManager) {
        this.taskManager = adTaskManager;
    }

    public void setIndexManagement(IndexManagementType anomalyDetectionIndices) {
        this.indexManagement = anomalyDetectionIndices;
    }

    public void setNodeStateManager(NodeStateManager nodeStateManager) {
        this.nodeStateManager = nodeStateManager;
    }

    public void setExecuteResultResponseRecorder(ExecuteResultResponseRecorderType recorder) {
        this.recorder = recorder;
    }

    public void setIndexJobActionHandler(IndexJobActionHandlerType indexJobActionHandler) {
        this.indexJobActionHandler = indexJobActionHandler;
    }

    public void process(Job jobParameter, JobExecutionContext context) {
        String configId = jobParameter.getName();
        log.info("Start to run {} job {}", (Object)this.analysisType, (Object)configId);
        ((TaskManager)this.taskManager).refreshRealtimeJobRunTime(configId);
        Instant executionEndTime = Instant.now();
        IntervalSchedule schedule = (IntervalSchedule)jobParameter.getSchedule();
        Instant executionStartTime = executionEndTime.minus(schedule.getInterval(), schedule.getUnit());
        LockService lockService = context.getLockService();
        Runnable runnable = () -> {
            try {
                this.nodeStateManager.getConfig(configId, this.analysisType, (ActionListener<Optional<? extends Config>>)ActionListener.wrap(configOptional -> {
                    if (!configOptional.isPresent()) {
                        log.error((Message)new ParameterizedMessage("fail to get config [{}]", (Object)configId));
                        return;
                    }
                    Config config = (Config)configOptional.get();
                    if (jobParameter.getLockDurationSeconds() != null) {
                        lockService.acquireLock((ScheduledJobParameter)jobParameter, context, ActionListener.wrap(lock -> this.runJob(jobParameter, lockService, (LockModel)lock, executionStartTime, executionEndTime, this.recorder, config), exception -> {
                            this.indexResultException(jobParameter, lockService, null, executionStartTime, executionEndTime, (Exception)exception, false, this.recorder, config);
                            throw new IllegalStateException("Failed to acquire lock for job: " + configId);
                        }));
                    } else {
                        log.warn("Can't get lock for job: " + configId);
                    }
                }, e -> log.error((Message)new ParameterizedMessage("fail to get config [{}]", (Object)configId), (Throwable)e)));
            }
            catch (Exception e2) {
                log.error("Can't start job: " + configId, (Throwable)e2);
                throw e2;
            }
        };
        ExecutorService executor = this.threadPool.executor(this.threadPoolName);
        executor.submit(runnable);
    }

    public void runJob(Job jobParameter, LockService lockService, LockModel lock, Instant executionStartTime, Instant executionEndTime, ExecuteResultResponseRecorderType recorder, Config config) {
        String configId = jobParameter.getName();
        if (lock == null) {
            this.indexResultException(jobParameter, lockService, lock, executionStartTime, executionEndTime, "Can't run job due to null lock", false, recorder, config);
            return;
        }
        ((IndexManagement)this.indexManagement).update();
        User userInfo = SecurityUtil.getUserFromJob(jobParameter, this.settings);
        String user = userInfo.getName();
        List roles = userInfo.getRoles();
        this.validateResultIndexAndRunJob(jobParameter, lockService, lock, executionStartTime, executionEndTime, configId, user, roles, recorder, config);
    }

    protected abstract void validateResultIndexAndRunJob(Job var1, LockService var2, LockModel var3, Instant var4, Instant var5, String var6, String var7, List<String> var8, ExecuteResultResponseRecorderType var9, Config var10);

    protected void runJob(Job jobParameter, LockService lockService, LockModel lock, Instant executionStartTime, Instant executionEndTime, String configId, String user, List<String> roles, ExecuteResultResponseRecorderType recorder, Config detector) {
        try (InjectSecurity injectSecurity = new InjectSecurity(configId, this.settings, this.client.threadPool().getThreadContext());){
            injectSecurity.inject(user, roles);
            ResultRequest request = this.createResultRequest(configId, executionStartTime.toEpochMilli(), executionEndTime.toEpochMilli());
            this.client.execute(this.resultAction, (ActionRequest)request, ActionListener.wrap(response -> this.indexResult(jobParameter, lockService, lock, executionStartTime, executionEndTime, (ResultResponse<IndexableResultType>)((Object)response), recorder, detector), exception -> this.handleException(jobParameter, lockService, lock, executionStartTime, executionEndTime, (Exception)exception, recorder, detector)));
        }
        catch (Exception e) {
            this.indexResultException(jobParameter, lockService, lock, executionStartTime, executionEndTime, e, true, recorder, detector);
            log.error("Failed to execute AD job " + configId, (Throwable)e);
        }
    }

    public void handleException(Job jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, Exception exception, ExecuteResultResponseRecorderType recorder, Config config) {
        String configId = jobParameter.getName();
        if (exception instanceof EndRunException) {
            log.error("EndRunException happened when executing result action for " + configId, (Throwable)exception);
            if (((EndRunException)exception).isEndNow()) {
                log.info("JobRunner will stop job due to EndRunException for {}", (Object)configId);
                this.stopJobForEndRunException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, (EndRunException)exception, recorder, config);
            } else {
                this.endRunExceptionCount.compute(configId, (k, v) -> {
                    if (v == null) {
                        return 1;
                    }
                    return v + 1;
                });
                log.info("EndRunException happened for {}", (Object)configId);
                if (this.endRunExceptionCount.get(configId) > this.maxRetryForEndRunException) {
                    log.info("JobRunner will stop job due to EndRunException retry exceeds upper limit {} for {}", (Object)this.maxRetryForEndRunException, (Object)configId);
                    this.stopJobForEndRunException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, (EndRunException)exception, recorder, config);
                    return;
                }
                this.indexResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, exception.getMessage(), true, recorder, config);
            }
        } else {
            this.endRunExceptionCount.remove(configId);
            if (exception instanceof InternalFailure) {
                log.error("InternalFailure happened when executing result action for " + configId, (Throwable)exception);
            } else {
                log.error("Failed to execute result action for " + configId, (Throwable)exception);
            }
            this.indexResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, exception, true, recorder, config);
        }
    }

    private void stopJobForEndRunException(Job jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, EndRunException exception, ExecuteResultResponseRecorderType recorder, Config config) {
        String configId = jobParameter.getName();
        this.endRunExceptionCount.remove(configId);
        String errorPrefix = exception.isEndNow() ? "Stopped analysis: " : "Stopped analysis as job failed consecutively for more than " + this.maxRetryForEndRunException + " times: ";
        String error = errorPrefix + exception.getMessage();
        ExecutorFunction runAfer = () -> this.indexResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, error, true, TaskState.STOPPED.name(), recorder, config);
        ActionListener stopListener = ActionListener.wrap(jobResponse -> {
            log.info((Message)new ParameterizedMessage("Job {} was disabled by JobRunner", (Object)configId));
            runAfer.execute();
        }, exp -> {
            log.error((Message)new ParameterizedMessage("JobRunner failed to update job {} to disabled.", (Object)configId), (Throwable)exp);
            runAfer.execute();
        });
        ((IndexJobActionHandler)this.indexJobActionHandler).stopJob(configId, null, (ActionListener<JobResponse>)stopListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexResult(Job jobParameter, LockService lockService, LockModel lock, Instant executionStartTime, Instant executionEndTime, ResultResponse<IndexableResultType> response, ExecuteResultResponseRecorderType recorder, Config detector) {
        String detectorId = jobParameter.getName();
        this.endRunExceptionCount.remove(detectorId);
        try {
            ((ExecuteResultResponseRecorder)recorder).indexResult(executionStartTime, executionEndTime, response, detector);
        }
        catch (EndRunException e) {
            this.handleException(jobParameter, lockService, lock, executionStartTime, executionEndTime, e, recorder, detector);
        }
        catch (Exception e) {
            log.error("Failed to index anomaly result for " + detectorId, (Throwable)e);
        }
        finally {
            this.releaseLock(jobParameter, lockService, lock);
        }
    }

    private void indexResultException(Job jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, Exception exception, boolean releaseLock, ExecuteResultResponseRecorderType recorder, Config detector) {
        try {
            String errorMessage = exception instanceof TimeSeriesException ? exception.getMessage() : Throwables.getStackTraceAsString((Throwable)exception);
            this.indexResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, errorMessage, releaseLock, recorder, detector);
        }
        catch (Exception e) {
            log.error("Failed to index result for " + jobParameter.getName(), (Throwable)e);
        }
    }

    private void indexResultException(Job jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, String errorMessage, boolean releaseLock, ExecuteResultResponseRecorderType recorder, Config detector) {
        this.indexResultException(jobParameter, lockService, lock, detectionStartTime, executionStartTime, errorMessage, releaseLock, null, recorder, detector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexResultException(Job jobParameter, LockService lockService, LockModel lock, Instant detectionStartTime, Instant executionStartTime, String errorMessage, boolean releaseLock, String taskState, ExecuteResultResponseRecorderType recorder, Config detector) {
        try {
            ((ExecuteResultResponseRecorder)recorder).indexResultException(detectionStartTime, executionStartTime, errorMessage, taskState, detector);
        }
        finally {
            if (releaseLock) {
                this.releaseLock(jobParameter, lockService, lock);
            }
        }
    }

    private void releaseLock(Job jobParameter, LockService lockService, LockModel lock) {
        lockService.release(lock, ActionListener.wrap(released -> log.info("Released lock for {} job {}", (Object)this.analysisType, (Object)jobParameter.getName()), exception -> log.error((Message)new ParameterizedMessage("Failed to release lock for [{}] job [{}]", (Object)this.analysisType, (Object)jobParameter.getName()), (Throwable)exception)));
    }

    public Integer getEndRunExceptionCount(String configId) {
        return this.endRunExceptionCount.getOrDefault(configId, 0);
    }

    protected abstract ResultRequest createResultRequest(String var1, long var2, long var4);
}

