/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.CleanState;
import org.opensearch.timeseries.ExceptionRecorder;
import org.opensearch.timeseries.MaintenanceState;
import org.opensearch.timeseries.NodeState;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.function.BiCheckedFunction;
import org.opensearch.timeseries.ml.SingleStreamModelIdMapper;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.transport.BackPressureRouting;
import org.opensearch.timeseries.util.ClientUtil;
import org.opensearch.timeseries.util.ExceptionUtil;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.client.Client;

public class NodeStateManager
implements MaintenanceState,
CleanState,
ExceptionRecorder {
    private static final Logger LOG = LogManager.getLogger(NodeStateManager.class);
    public static final String NO_ERROR = "no_error";
    protected ConcurrentHashMap<String, NodeState> states = new ConcurrentHashMap();
    protected Client client;
    protected NamedXContentRegistry xContentRegistry;
    protected ClientUtil clientUtil;
    protected final Clock clock;
    protected final Duration stateTtl;
    private Map<String, Map<String, BackPressureRouting>> backpressureMuter;
    private int maxRetryForUnresponsiveNode;
    private TimeValue mutePeriod;

    public NodeStateManager(Client client, NamedXContentRegistry xContentRegistry, Settings settings, ClientUtil clientUtil, Clock clock, Duration stateTtl, ClusterService clusterService, Setting<Integer> maxRetryForUnresponsiveNodeSetting, Setting<TimeValue> backoffMinutesSetting) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clientUtil = clientUtil;
        this.clock = clock;
        this.stateTtl = stateTtl;
        this.backpressureMuter = new ConcurrentHashMap<String, Map<String, BackPressureRouting>>();
        this.maxRetryForUnresponsiveNode = (Integer)maxRetryForUnresponsiveNodeSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(maxRetryForUnresponsiveNodeSetting, it -> {
            this.maxRetryForUnresponsiveNode = it;
            for (Map<String, BackPressureRouting> entry : this.backpressureMuter.values()) {
                entry.values().forEach(v -> v.setMaxRetryForUnresponsiveNode((int)it));
            }
        });
        this.mutePeriod = (TimeValue)backoffMinutesSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(backoffMinutesSetting, it -> {
            this.mutePeriod = it;
            for (Map<String, BackPressureRouting> entry : this.backpressureMuter.values()) {
                entry.values().forEach(v -> v.setMutePeriod((TimeValue)it));
            }
        });
    }

    @Override
    public void maintenance() {
        this.maintenance(this.states, this.stateTtl);
    }

    @Override
    public void clear(String configId) {
        Map<String, BackPressureRouting> routingMap = this.backpressureMuter.get(configId);
        if (routingMap != null) {
            routingMap.clear();
            this.backpressureMuter.remove(configId);
        }
        this.states.remove(configId);
    }

    public boolean isMuted(String nodeId, String configId) {
        Map<String, BackPressureRouting> routingMap = this.backpressureMuter.get(configId);
        if (routingMap == null || routingMap.isEmpty()) {
            return false;
        }
        BackPressureRouting routing = routingMap.get(nodeId);
        return routing != null && routing.isMuted();
    }

    public void addPressure(String nodeId, String configId) {
        Map routingMap = this.backpressureMuter.computeIfAbsent(configId, k -> new HashMap());
        routingMap.computeIfAbsent(nodeId, k -> new BackPressureRouting((String)k, this.clock, this.maxRetryForUnresponsiveNode, this.mutePeriod)).addPressure();
    }

    public void resetBackpressureCounter(String nodeId, String configId) {
        Map<String, BackPressureRouting> routingMap = this.backpressureMuter.get(configId);
        if (routingMap == null || routingMap.isEmpty()) {
            this.backpressureMuter.remove(configId);
            return;
        }
        routingMap.remove(nodeId);
    }

    public <T> void getConfig(String configId, AnalysisType analysisType, Consumer<Optional<? extends Config>> function, ActionListener<T> listener) {
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detectors", configId);
        this.client.get(getRequest, ActionListener.wrap(response -> {
            if (!response.isExists()) {
                function.accept(Optional.empty());
                return;
            }
            try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                Config config = null;
                if (analysisType.isAD()) {
                    config = AnomalyDetector.parse(parser, response.getId(), response.getVersion());
                } else if (analysisType.isForecast()) {
                    config = Forecaster.parse(parser, response.getId(), response.getVersion());
                } else {
                    throw new UnsupportedOperationException("This method is not supported");
                }
                function.accept(Optional.of(config));
            }
            catch (Exception e) {
                String message = "Failed to parse config " + configId;
                LOG.error(message, (Throwable)e);
                listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }, exception -> {
            LOG.error("Failed to get config " + configId, (Throwable)exception);
            listener.onFailure(exception);
        }));
    }

    public void getConfig(String configID, AnalysisType context, ActionListener<Optional<? extends Config>> listener) {
        NodeState state = this.states.get(configID);
        if (state != null && state.getConfigDef() != null) {
            listener.onResponse(Optional.of(state.getConfigDef()));
        } else {
            GetRequest request = new GetRequest(".opendistro-anomaly-detectors", configID);
            BiCheckedFunction<XContentParser, String, Config, IOException> configParser = context.isAD() ? AnomalyDetector::parse : Forecaster::parse;
            this.clientUtil.asyncRequest(request, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1), this.onGetConfigResponse(configID, configParser, listener));
        }
    }

    private ActionListener<GetResponse> onGetConfigResponse(String configID, BiCheckedFunction<XContentParser, String, ? extends Config, IOException> configParser, ActionListener<Optional<? extends Config>> listener) {
        return ActionListener.wrap(response -> {
            if (response == null || !response.isExists()) {
                listener.onResponse(Optional.empty());
                return;
            }
            String xc = response.getSourceAsString();
            LOG.debug("Fetched config: {}", (Object)xc);
            try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, xc);){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                Config config = (Config)configParser.apply(parser, response.getId());
                if (config.getEnabledFeatureIds().isEmpty()) {
                    listener.onFailure((Exception)new EndRunException(configID, "Having trouble querying data because all of your features have been disabled.", true).countedInStats(false));
                    return;
                }
                NodeState state = this.states.computeIfAbsent(configID, configId -> new NodeState((String)configId, this.clock));
                state.setConfigDef(config);
                listener.onResponse(Optional.of(config));
            }
            catch (Exception t) {
                LOG.error("Fail to parse config {}", (Object)configID);
                LOG.error("Stack trace:", (Throwable)t);
                listener.onResponse(Optional.empty());
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    @Override
    public Optional<Exception> fetchExceptionAndClear(String configID) {
        NodeState state = this.states.get(configID);
        if (state == null) {
            return Optional.empty();
        }
        Optional<Exception> exception = state.getException();
        exception.ifPresent(e -> state.setException(null));
        return exception;
    }

    @Override
    public void setException(String configId, Exception e) {
        Exception higherPriorityException;
        if (e == null || Strings.isEmpty((CharSequence)configId)) {
            return;
        }
        NodeState state = this.states.computeIfAbsent(configId, d -> new NodeState(configId, this.clock));
        Optional<Exception> exception = state.getException();
        if (exception.isPresent() && (higherPriorityException = ExceptionUtil.selectHigherPriorityException(e, exception.get())) != e) {
            return;
        }
        state.setException(e);
    }

    public void getDetectorCheckpoint(String adID, ActionListener<Boolean> listener) {
        NodeState state = this.states.get(adID);
        if (state != null && state.doesCheckpointExists()) {
            listener.onResponse((Object)Boolean.TRUE);
            return;
        }
        GetRequest request = new GetRequest(".opendistro-anomaly-checkpoints", SingleStreamModelIdMapper.getRcfModelId(adID, 0));
        this.clientUtil.asyncRequest(request, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1), this.onGetCheckpointResponse(adID, listener));
    }

    private ActionListener<GetResponse> onGetCheckpointResponse(String adID, ActionListener<Boolean> listener) {
        return ActionListener.wrap(response -> {
            if (response == null || !response.isExists()) {
                listener.onResponse((Object)Boolean.FALSE);
            } else {
                NodeState state = this.states.computeIfAbsent(adID, id -> new NodeState((String)id, this.clock));
                state.setCheckpointExists(true);
                listener.onResponse((Object)Boolean.TRUE);
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public boolean isColdStartRunning(String adID) {
        NodeState state = this.states.get(adID);
        if (state != null) {
            return state.isColdStartRunning();
        }
        return false;
    }

    public Releasable markColdStartRunning(String adID) {
        NodeState state = this.states.computeIfAbsent(adID, id -> new NodeState((String)id, this.clock));
        state.setColdStartRunning(true);
        return () -> {
            NodeState nodeState = this.states.get(adID);
            if (nodeState != null) {
                nodeState.setColdStartRunning(false);
            }
        };
    }

    public void getJob(String configID, ActionListener<Optional<Job>> listener) {
        NodeState state = this.states.get(configID);
        if (state != null && state.getJob() != null) {
            listener.onResponse(Optional.of(state.getJob()));
        } else {
            GetRequest request = new GetRequest(".opendistro-anomaly-detector-jobs", configID);
            this.clientUtil.asyncRequest(request, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1), this.onGetJobResponse(configID, listener));
        }
    }

    private ActionListener<GetResponse> onGetJobResponse(String configID, ActionListener<Optional<Job>> listener) {
        return ActionListener.wrap(response -> {
            if (response == null || !response.isExists()) {
                listener.onResponse(Optional.empty());
                return;
            }
            String xc = response.getSourceAsString();
            LOG.debug("Fetched config: {}", (Object)xc);
            try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                Job job = Job.parse(parser);
                NodeState state = this.states.computeIfAbsent(configID, id -> new NodeState((String)id, this.clock));
                state.setJob(job);
                listener.onResponse(Optional.of(job));
            }
            catch (Exception t) {
                LOG.error((Message)new ParameterizedMessage("Fail to parse job {}", (Object)configID), (Throwable)t);
                listener.onResponse(Optional.empty());
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }
}

