/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.cluster;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.ad.transport.CronAction;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.action.ActionListener;
import org.opensearch.timeseries.transport.CronRequest;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.transport.client.Client;

public class HourlyCron
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(HourlyCron.class);
    public static final String SUCCEEDS_LOG_MSG = "Hourly maintenance succeeds";
    public static final String NODE_EXCEPTION_LOG_MSG = "Hourly maintenance of node has exception";
    public static final String EXCEPTION_LOG_MSG = "Hourly maintenance has exception.";
    private DiscoveryNodeFilterer nodeFilter;
    private Client client;

    public HourlyCron(Client client, DiscoveryNodeFilterer nodeFilter) {
        this.nodeFilter = nodeFilter;
        this.client = client;
    }

    @Override
    public void run() {
        DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
        CronRequest modelDeleteRequest = new CronRequest(dataNodes);
        this.client.execute((ActionType)CronAction.INSTANCE, (ActionRequest)modelDeleteRequest, ActionListener.wrap(response -> {
            if (response.hasFailures()) {
                for (FailedNodeException failedNodeException : response.failures()) {
                    LOG.warn(NODE_EXCEPTION_LOG_MSG, (Throwable)failedNodeException);
                }
            } else {
                LOG.info(SUCCEEDS_LOG_MSG);
            }
        }, exception -> LOG.error(EXCEPTION_LOG_MSG, (Throwable)exception)));
    }
}

