/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.EntityProfileRunner;
import org.opensearch.timeseries.Name;
import org.opensearch.timeseries.ProfileRunner;
import org.opensearch.timeseries.TaskProfile;
import org.opensearch.timeseries.TaskProfileRunner;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.ConfigProfile;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.EntityProfile;
import org.opensearch.timeseries.model.EntityProfileName;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.model.ProfileName;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.transport.EntityProfileResponse;
import org.opensearch.timeseries.transport.GetConfigRequest;
import org.opensearch.timeseries.transport.ProfileResponse;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public abstract class BaseGetConfigTransportAction<GetConfigResponseType extends ActionResponse, TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>, ConfigType extends Config, EntityProfileActionType extends ActionType<EntityProfileResponse>, EntityProfileRunnerType extends EntityProfileRunner<EntityProfileActionType>, TaskProfileType extends TaskProfile<TaskClass>, ConfigProfileType extends ConfigProfile<TaskClass, TaskProfileType>, ProfileActionType extends ActionType<ProfileResponse>, TaskProfileRunnerType extends TaskProfileRunner<TaskClass, TaskProfileType>, ProfileRunnerType extends ProfileRunner<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType, TaskProfileType, TaskManagerType, ConfigProfileType, ProfileActionType, TaskProfileRunnerType>>
extends HandledTransportAction<ActionRequest, GetConfigResponseType> {
    private static final Logger LOG = LogManager.getLogger(BaseGetConfigTransportAction.class);
    protected final ClusterService clusterService;
    protected final Client client;
    protected final SecurityClientUtil clientUtil;
    protected final Set<String> allProfileTypeStrs;
    protected final Set<ProfileName> allProfileTypes;
    protected final Set<ProfileName> defaultDetectorProfileTypes;
    protected final Set<String> allEntityProfileTypeStrs;
    protected final Set<EntityProfileName> allEntityProfileTypes;
    protected final Set<EntityProfileName> defaultEntityProfileTypes;
    protected final NamedXContentRegistry xContentRegistry;
    protected final DiscoveryNodeFilterer nodeFilter;
    protected final TransportService transportService;
    protected volatile Boolean filterByEnabled;
    protected final TaskManagerType taskManager;
    private final Class<ConfigType> configTypeClass;
    private final String configParseFieldName;
    private final List<TaskTypeEnum> allTaskTypes;
    private final String singleStreamRealTimeTaskName;
    private final String hcRealTImeTaskName;
    private final String singleStreamHistoricalTaskname;
    private final String hcHistoricalTaskName;
    private final TaskProfileRunnerType taskProfileRunner;

    public BaseGetConfigTransportAction(TransportService transportService, DiscoveryNodeFilterer nodeFilter, ActionFilters actionFilters, ClusterService clusterService, Client client, SecurityClientUtil clientUtil, Settings settings, NamedXContentRegistry xContentRegistry, TaskManagerType forecastTaskManager, String getConfigAction, Class<ConfigType> configTypeClass, String configParseFieldName, List<TaskTypeEnum> allTaskTypes, String hcRealTImeTaskName, String singleStreamRealTimeTaskName, String hcHistoricalTaskName, String singleStreamHistoricalTaskname, Setting<Boolean> filterByBackendRoleEnableSetting, TaskProfileRunnerType taskProfileRunner) {
        super(getConfigAction, transportService, actionFilters, GetConfigRequest::new);
        this.clusterService = clusterService;
        this.client = client;
        this.clientUtil = clientUtil;
        List<ProfileName> allProfiles = Arrays.asList(ProfileName.values());
        this.allProfileTypes = EnumSet.copyOf(allProfiles);
        this.allProfileTypeStrs = Name.getListStrs(allProfiles);
        List<ProfileName> defaultProfiles = Arrays.asList(ProfileName.ERROR, ProfileName.STATE);
        this.defaultDetectorProfileTypes = new HashSet<ProfileName>(defaultProfiles);
        List<EntityProfileName> allEntityProfiles = Arrays.asList(EntityProfileName.values());
        this.allEntityProfileTypes = EnumSet.copyOf(allEntityProfiles);
        this.allEntityProfileTypeStrs = Name.getListStrs(allEntityProfiles);
        List<EntityProfileName> defaultEntityProfiles = Arrays.asList(EntityProfileName.STATE);
        this.defaultEntityProfileTypes = new HashSet<EntityProfileName>(defaultEntityProfiles);
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.filterByEnabled = (Boolean)filterByBackendRoleEnableSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(filterByBackendRoleEnableSetting, it -> {
            this.filterByEnabled = it;
        });
        this.transportService = transportService;
        this.taskManager = forecastTaskManager;
        this.configTypeClass = configTypeClass;
        this.configParseFieldName = configParseFieldName;
        this.allTaskTypes = allTaskTypes;
        this.hcRealTImeTaskName = hcRealTImeTaskName;
        this.singleStreamRealTimeTaskName = singleStreamRealTimeTaskName;
        this.hcHistoricalTaskName = hcHistoricalTaskName;
        this.singleStreamHistoricalTaskname = singleStreamHistoricalTaskname;
        this.taskProfileRunner = taskProfileRunner;
    }

    public void doExecute(Task task, ActionRequest request, ActionListener<GetConfigResponseType> actionListener) {
        GetConfigRequest getConfigRequest = GetConfigRequest.fromActionRequest(request);
        String configID = getConfigRequest.getConfigID();
        User user = ParseUtils.getUserContext(this.client);
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, "Fail to get config");
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.resolveUserAndExecute(user, configID, this.filterByEnabled, listener, config -> this.getExecute(getConfigRequest, listener), this.client, this.clusterService, this.xContentRegistry, this.configTypeClass);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }

    public void getConfigAndJob(String configID, boolean returnJob, boolean returnTask, Optional<TaskClass> realtimeConfigTask, Optional<TaskClass> historicalConfigTask, ActionListener<GetConfigResponseType> listener) {
        MultiGetRequest.Item configItem = new MultiGetRequest.Item(".opendistro-anomaly-detectors", configID);
        MultiGetRequest multiGetRequest = new MultiGetRequest().add(configItem);
        if (returnJob) {
            MultiGetRequest.Item adJobItem = new MultiGetRequest.Item(".opendistro-anomaly-detector-jobs", configID);
            multiGetRequest.add(adJobItem);
        }
        this.client.multiGet(multiGetRequest, this.onMultiGetResponse(listener, returnJob, returnTask, realtimeConfigTask, historicalConfigTask, configID));
    }

    public void getExecute(GetConfigRequest request, ActionListener<GetConfigResponseType> listener) {
        String configID = request.getConfigID();
        String typesStr = request.getTypeStr();
        String rawPath = request.getRawPath();
        Entity entity = request.getEntity();
        boolean all = request.isAll();
        boolean returnJob = request.isReturnJob();
        boolean returnTask = request.isReturnTask();
        try {
            if (!Strings.isEmpty((CharSequence)typesStr) || rawPath.endsWith("_profile") || rawPath.endsWith("_profile/")) {
                this.getExecuteProfile(request, entity, typesStr, all, configID, listener);
            } else if (returnTask) {
                ((TaskManager)this.taskManager).getAndExecuteOnLatestTasks(configID, null, null, this.allTaskTypes, taskList -> {
                    Optional<Object> realtimeTask = Optional.empty();
                    Optional<Object> historicalTask = Optional.empty();
                    if (taskList != null && taskList.size() > 0) {
                        HashMap<String, TimeSeriesTask> tasks = new HashMap<String, TimeSeriesTask>();
                        ArrayList<TimeSeriesTask> duplicateTasks = new ArrayList<TimeSeriesTask>();
                        for (TimeSeriesTask task : taskList) {
                            if (tasks.containsKey(task.getTaskType())) {
                                LOG.info("Found duplicate latest task of config {}, task id: {}, task type: {}", (Object)configID, (Object)task.getTaskType(), (Object)task.getTaskId());
                                duplicateTasks.add(task);
                                continue;
                            }
                            tasks.put(task.getTaskType(), task);
                        }
                        if (duplicateTasks.size() > 0) {
                            ((TaskManager)this.taskManager).resetLatestFlagAsFalse(duplicateTasks);
                        }
                        if (tasks.containsKey(this.hcRealTImeTaskName)) {
                            realtimeTask = Optional.ofNullable((TimeSeriesTask)tasks.get(this.hcRealTImeTaskName));
                        } else if (tasks.containsKey(this.singleStreamRealTimeTaskName)) {
                            realtimeTask = Optional.ofNullable((TimeSeriesTask)tasks.get(this.singleStreamRealTimeTaskName));
                        }
                        historicalTask = tasks.containsKey(this.hcHistoricalTaskName) ? Optional.ofNullable((TimeSeriesTask)tasks.get(this.hcHistoricalTaskName)) : (tasks.containsKey(this.singleStreamHistoricalTaskname) ? Optional.ofNullable((TimeSeriesTask)tasks.get(this.singleStreamHistoricalTaskname)) : this.fillInHistoricalTaskforBwc(tasks));
                    }
                    this.getConfigAndJob(configID, returnJob, returnTask, realtimeTask, historicalTask, listener);
                }, this.transportService, true, 2, listener);
            } else {
                this.getConfigAndJob(configID, returnJob, returnTask, Optional.empty(), Optional.empty(), listener);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }

    private ActionListener<MultiGetResponse> onMultiGetResponse(final ActionListener<GetConfigResponseType> listener, final boolean returnJob, final boolean returnTask, final Optional<TaskClass> realtimeTask, final Optional<TaskClass> historicalTask, final String configId) {
        return new ActionListener<MultiGetResponse>(){

            public void onResponse(MultiGetResponse multiGetResponse) {
                MultiGetItemResponse[] responses = multiGetResponse.getResponses();
                Config config = null;
                Job job = null;
                String id = null;
                long version = 0L;
                long seqNo = 0L;
                long primaryTerm = 0L;
                for (MultiGetItemResponse response : responses) {
                    XContentParser parser;
                    if (".opendistro-anomaly-detectors".equals(response.getIndex())) {
                        if (response.getResponse() == null || !response.getResponse().isExists()) {
                            listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + configId, RestStatus.NOT_FOUND, new Object[0]));
                            return;
                        }
                        id = response.getId();
                        version = response.getResponse().getVersion();
                        primaryTerm = response.getResponse().getPrimaryTerm();
                        seqNo = response.getResponse().getSeqNo();
                        if (response.getResponse().isSourceEmpty()) continue;
                        try {
                            parser = RestHandlerUtils.createXContentParserFromRegistry(BaseGetConfigTransportAction.this.xContentRegistry, response.getResponse().getSourceAsBytesRef());
                            try {
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                config = (Config)parser.namedObject(BaseGetConfigTransportAction.this.configTypeClass, BaseGetConfigTransportAction.this.configParseFieldName, null);
                                continue;
                            }
                            finally {
                                if (parser != null) {
                                    parser.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            String message = "Failed to parse config " + configId;
                            listener.onFailure((Exception)BaseGetConfigTransportAction.this.buildInternalServerErrorResponse(e, message));
                            return;
                        }
                    }
                    if (!".opendistro-anomaly-detector-jobs".equals(response.getIndex()) || response.getResponse() == null || !response.getResponse().isExists() || response.getResponse().isSourceEmpty()) continue;
                    try {
                        parser = RestHandlerUtils.createXContentParserFromRegistry(BaseGetConfigTransportAction.this.xContentRegistry, response.getResponse().getSourceAsBytesRef());
                        try {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                            job = Job.parse(parser);
                        }
                        finally {
                            if (parser != null) {
                                parser.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        String message = "Failed to parse job " + configId;
                        listener.onFailure((Exception)BaseGetConfigTransportAction.this.buildInternalServerErrorResponse(e, message));
                        return;
                    }
                }
                listener.onResponse(BaseGetConfigTransportAction.this.createResponse(version, id, primaryTerm, seqNo, config, job, returnJob, realtimeTask, historicalTask, returnTask, RestStatus.OK, null, null, false));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }

    protected Optional<TaskClass> fillInHistoricalTaskforBwc(Map<String, TaskClass> tasks) {
        return Optional.empty();
    }

    protected void getExecuteProfile(GetConfigRequest request, Entity entity, String typesStr, boolean all, String configId, ActionListener<GetConfigResponseType> listener) {
        if (entity != null) {
            Set<EntityProfileName> entityProfilesToCollect = this.getEntityProfilesToCollect(typesStr, all);
            EntityProfileRunnerType profileRunner = this.createEntityProfileRunner(this.client, this.clientUtil, this.xContentRegistry, 32L);
            ((EntityProfileRunner)profileRunner).profile(configId, entity, entityProfilesToCollect, (ActionListener<EntityProfile>)ActionListener.wrap(profile -> listener.onResponse(this.createResponse(0L, null, 0L, 0L, null, null, false, Optional.empty(), Optional.empty(), false, null, null, (EntityProfile)profile, true)), e -> listener.onFailure(e)));
        } else {
            Set<ProfileName> profilesToCollect = this.getProfilesToCollect(typesStr, all);
            ProfileRunnerType profileRunner = this.createProfileRunner(this.client, this.clientUtil, this.xContentRegistry, this.nodeFilter, 32L, this.transportService, this.taskManager, this.taskProfileRunner);
            ((ProfileRunner)profileRunner).profile(configId, this.getProfileActionListener(listener), profilesToCollect);
        }
    }

    protected abstract GetConfigResponseType createResponse(long var1, String var3, long var4, long var6, ConfigType var8, Job var9, boolean var10, Optional<TaskClass> var11, Optional<TaskClass> var12, boolean var13, RestStatus var14, ConfigProfileType var15, EntityProfile var16, boolean var17);

    protected OpenSearchStatusException buildInternalServerErrorResponse(Exception e, String errorMsg) {
        LOG.error(errorMsg, (Throwable)e);
        return new OpenSearchStatusException(errorMsg, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }

    protected Set<EntityProfileName> getEntityProfilesToCollect(String typesStr, boolean all) {
        if (all) {
            return this.allEntityProfileTypes;
        }
        if (Strings.isEmpty((CharSequence)typesStr)) {
            return this.defaultEntityProfileTypes;
        }
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(typesStr.split(",")));
        return EntityProfileName.getNames((Collection<String>)Sets.intersection(this.allEntityProfileTypeStrs, typesInRequest));
    }

    protected Set<ProfileName> getProfilesToCollect(String typesStr, boolean all) {
        if (all) {
            return this.allProfileTypes;
        }
        if (Strings.isEmpty((CharSequence)typesStr)) {
            return this.defaultDetectorProfileTypes;
        }
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(typesStr.split(",")));
        return ProfileName.getNames((Collection<String>)Sets.intersection(this.allProfileTypeStrs, typesInRequest));
    }

    protected ActionListener<ConfigProfileType> getProfileActionListener(final ActionListener<GetConfigResponseType> listener) {
        return ActionListener.wrap((CheckedConsumer)new CheckedConsumer<ConfigProfileType, Exception>(){

            public void accept(ConfigProfileType profile) throws Exception {
                listener.onResponse(BaseGetConfigTransportAction.this.createResponse(0L, null, 0L, 0L, null, null, false, Optional.empty(), Optional.empty(), false, null, profile, null, true));
            }
        }, exception -> listener.onFailure(exception));
    }

    protected abstract EntityProfileRunnerType createEntityProfileRunner(Client var1, SecurityClientUtil var2, NamedXContentRegistry var3, long var4);

    protected abstract ProfileRunnerType createProfileRunner(Client var1, SecurityClientUtil var2, NamedXContentRegistry var3, DiscoveryNodeFilterer var4, long var5, TransportService var7, TaskManagerType var8, TaskProfileRunnerType var9);
}

