/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { OuiColorPicker, OuiCompressedColorPicker } from './color_picker';
export { OuiColorPickerSwatch } from './color_picker_swatch';
export { OuiHue } from './hue';
export { OuiSaturation } from './saturation';
export { OuiColorStops } from './color_stops'; // TODO: Exporting `OuiColorStopsProps` from `'./color_stops'`
// results in a duplicate d.ts entry that causes build warnings
// and potential downstream TS project failures.

export {} from './color_stops/color_stops';
export { OuiColorPalettePicker } from './color_palette_picker';
export { OuiColorPaletteDisplay } from './color_palette_display';
/* OUI -> EUI Aliases: Build-Time */

export { EuiColorPicker, EuiCompressedColorPicker } from '../../eui_components/color_picker/color_picker';
/* OUI -> EUI Aliases: Build-Time */

export { EuiColorPickerSwatch } from '../../eui_components/color_picker/color_picker_swatch';
/* OUI -> EUI Aliases: Build-Time */

export { EuiHue } from '../../eui_components/color_picker/hue';
/* OUI -> EUI Aliases: Build-Time */

export { EuiSaturation } from '../../eui_components/color_picker/saturation';
/* OUI -> EUI Aliases: Build-Time */

export { EuiColorStops } from '../../eui_components/color_picker/color_stops';
/* OUI -> EUI Aliases: Build-Time */

export {} from '../../eui_components/color_picker/color_stops/color_stops';
/* OUI -> EUI Aliases: Build-Time */

export { EuiColorPalettePicker } from '../../eui_components/color_picker/color_palette_picker';
/* OUI -> EUI Aliases: Build-Time */

export { EuiColorPaletteDisplay } from '../../eui_components/color_picker/color_palette_display';