"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionOpenSearchDashboardsPlugin = void 0;
var _constants = require("../utils/constants");
var _operators = require("rxjs/operators");
var _router = _interopRequireDefault(require("./router"));
var _adPlugin = _interopRequireDefault(require("./cluster/ad/adPlugin"));
var _alertingPlugin = _interopRequireDefault(require("./cluster/ad/alertingPlugin"));
var _ad = _interopRequireWildcard(require("./routes/ad"));
var _alerting = _interopRequireWildcard(require("./routes/alerting"));
var _opensearch = _interopRequireWildcard(require("./routes/opensearch"));
var _sampleData = _interopRequireWildcard(require("./routes/sampleData"));
var _constants2 = require("./utils/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                          * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                          * compatible open source license.
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                          * GitHub history for details.
                                                                                                                                                                                                                                                                                                                          */
class AnomalyDetectionOpenSearchDashboardsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core, {
    dataSource
  }) {
    // Get any custom/overridden headers
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const {
      customHeaders,
      ...rest
    } = globalConfig.opensearch;

    // Create OpenSearch client w/ relevant plugins and headers
    const client = core.opensearch.legacy.createClient('anomaly_detection', {
      plugins: [_adPlugin.default, _alertingPlugin.default],
      customHeaders: {
        ...customHeaders,
        ..._constants2.DEFAULT_HEADERS
      },
      ...rest
    });
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_adPlugin.default);
      dataSource.registerCustomApiSchema(_alertingPlugin.default);
    }

    // Create router
    const apiRouter = (0, _router.default)(core.http.createRouter(), _constants.BASE_NODE_API_PATH);

    // Create services & register with OpenSearch client
    const adService = new _ad.default(client, dataSourceEnabled);
    const alertingService = new _alerting.default(client, dataSourceEnabled);
    const opensearchService = new _opensearch.default(client, dataSourceEnabled);
    const sampleDataService = new _sampleData.default(client, dataSourceEnabled);

    // Register server routes with the service
    (0, _ad.registerADRoutes)(apiRouter, adService);
    (0, _alerting.registerAlertingRoutes)(apiRouter, alertingService);
    (0, _opensearch.registerOpenSearchRoutes)(apiRouter, opensearchService);
    (0, _sampleData.registerSampleDataRoutes)(apiRouter, sampleDataService);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.AnomalyDetectionOpenSearchDashboardsPlugin = AnomalyDetectionOpenSearchDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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