"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getDataStreams = getDataStreams;
exports.getIndexToDataStreamMapping = getIndexToDataStreamMapping;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class DataStreamService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getDataStreams", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const [dataStreams, apiAccessible, errMsg] = await getDataStreams(callWithRequest, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              dataStreams: dataStreams,
              totalDataStreams: dataStreams.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - DataStreamService - getDataStreams:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = DataStreamService;
async function getDataStreams(callWithRequest, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const dataStreamsResponse = await callWithRequest("transport.request", {
    path: `/_data_stream/${searchPattern}`,
    method: "GET"
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        data_streams: []
      };
    }
    throw e;
  });
  return [dataStreamsResponse["data_streams"], accessible, errMsg];
}
async function getIndexToDataStreamMapping(callWithRequest) {
  const [dataStreams] = await getDataStreams(callWithRequest);
  const mapping = {};
  dataStreams.forEach(dataStream => {
    dataStream.indices.forEach(index => {
      mapping[index.index_name] = dataStream.name;
    });
  });
  return mapping;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uc3RhbnRzIiwicmVxdWlyZSIsIl9NRFNFbmFibGVkQ2xpZW50U2VydmljZSIsIl9kZWZpbmVQcm9wZXJ0eSIsIm9iaiIsImtleSIsInZhbHVlIiwiX3RvUHJvcGVydHlLZXkiLCJPYmplY3QiLCJkZWZpbmVQcm9wZXJ0eSIsImVudW1lcmFibGUiLCJjb25maWd1cmFibGUiLCJ3cml0YWJsZSIsImFyZyIsIl90b1ByaW1pdGl2ZSIsIlN0cmluZyIsImlucHV0IiwiaGludCIsInByaW0iLCJTeW1ib2wiLCJ0b1ByaW1pdGl2ZSIsInVuZGVmaW5lZCIsInJlcyIsImNhbGwiLCJUeXBlRXJyb3IiLCJOdW1iZXIiLCJEYXRhU3RyZWFtU2VydmljZSIsIk1EU0VuYWJsZWRDbGllbnRTZXJ2aWNlIiwiY29uc3RydWN0b3IiLCJhcmdzIiwiY29udGV4dCIsInJlcXVlc3QiLCJyZXNwb25zZSIsInNlYXJjaCIsInF1ZXJ5IiwiY2FsbFdpdGhSZXF1ZXN0IiwiZ2V0Q2xpZW50QmFzZWRPbkRhdGFTb3VyY2UiLCJkYXRhU3RyZWFtcyIsImFwaUFjY2Vzc2libGUiLCJlcnJNc2ciLCJnZXREYXRhU3RyZWFtcyIsImN1c3RvbSIsInN0YXR1c0NvZGUiLCJib2R5Iiwib2siLCJlcnJvciIsInRvdGFsRGF0YVN0cmVhbXMiLCJsZW5ndGgiLCJlcnIiLCJjb25zb2xlIiwibWVzc2FnZSIsImV4cG9ydHMiLCJkZWZhdWx0Iiwic2VhcmNoUGF0dGVybiIsImFjY2Vzc2libGUiLCJkYXRhU3RyZWFtc1Jlc3BvbnNlIiwicGF0aCIsIm1ldGhvZCIsImNhdGNoIiwiZSIsInN0YXJ0c1dpdGgiLCJTRUNVUklUWV9FWENFUFRJT05fUFJFRklYIiwiZGF0YV9zdHJlYW1zIiwiZ2V0SW5kZXhUb0RhdGFTdHJlYW1NYXBwaW5nIiwibWFwcGluZyIsImZvckVhY2giLCJkYXRhU3RyZWFtIiwiaW5kaWNlcyIsImluZGV4IiwiaW5kZXhfbmFtZSIsIm5hbWUiXSwic291cmNlcyI6WyJEYXRhU3RyZWFtU2VydmljZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7XG4gIElMZWdhY3lTY29wZWRDbHVzdGVyQ2xpZW50LFxuICBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZSxcbiAgT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeSxcbiAgUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxufSBmcm9tIFwib3BlbnNlYXJjaC1kYXNoYm9hcmRzL3NlcnZlclwiO1xuaW1wb3J0IHsgU2VydmVyUmVzcG9uc2UgfSBmcm9tIFwiLi4vbW9kZWxzL3R5cGVzXCI7XG5pbXBvcnQgeyBEYXRhU3RyZWFtLCBHZXREYXRhU3RyZWFtc1Jlc3BvbnNlLCBJbmRleFRvRGF0YVN0cmVhbSB9IGZyb20gXCIuLi9tb2RlbHMvaW50ZXJmYWNlc1wiO1xuaW1wb3J0IHsgU0VDVVJJVFlfRVhDRVBUSU9OX1BSRUZJWCB9IGZyb20gXCIuLi91dGlscy9jb25zdGFudHNcIjtcbmltcG9ydCB7IERhdGFTb3VyY2VDbGllbnQsIE1EU0VuYWJsZWRDbGllbnRTZXJ2aWNlIH0gZnJvbSBcIi4vTURTRW5hYmxlZENsaWVudFNlcnZpY2VcIjtcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgRGF0YVN0cmVhbVNlcnZpY2UgZXh0ZW5kcyBNRFNFbmFibGVkQ2xpZW50U2VydmljZSB7XG4gIGdldERhdGFTdHJlYW1zID0gYXN5bmMgKFxuICAgIGNvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXG4gICAgcmVzcG9uc2U6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5XG4gICk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8U2VydmVyUmVzcG9uc2U8R2V0RGF0YVN0cmVhbXNSZXNwb25zZT4+PiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHsgc2VhcmNoIH0gPSByZXF1ZXN0LnF1ZXJ5IGFzIHtcbiAgICAgICAgc2VhcmNoPzogc3RyaW5nO1xuICAgICAgfTtcblxuICAgICAgY29uc3QgY2FsbFdpdGhSZXF1ZXN0ID0gdGhpcy5nZXRDbGllbnRCYXNlZE9uRGF0YVNvdXJjZShjb250ZXh0LCByZXF1ZXN0KTtcbiAgICAgIGNvbnN0IFtkYXRhU3RyZWFtcywgYXBpQWNjZXNzaWJsZSwgZXJyTXNnXSA9IGF3YWl0IGdldERhdGFTdHJlYW1zKGNhbGxXaXRoUmVxdWVzdCwgc2VhcmNoKTtcblxuICAgICAgaWYgKCFhcGlBY2Nlc3NpYmxlKVxuICAgICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgICAgYm9keToge1xuICAgICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgICAgZXJyb3I6IGVyck1zZyxcbiAgICAgICAgICB9LFxuICAgICAgICB9KTtcblxuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3BvbnNlOiB7XG4gICAgICAgICAgICBkYXRhU3RyZWFtczogZGF0YVN0cmVhbXMsXG4gICAgICAgICAgICB0b3RhbERhdGFTdHJlYW1zOiBkYXRhU3RyZWFtcy5sZW5ndGgsXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgY29uc29sZS5lcnJvcihcIkluZGV4IE1hbmFnZW1lbnQgLSBEYXRhU3RyZWFtU2VydmljZSAtIGdldERhdGFTdHJlYW1zOlwiLCBlcnIpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICBlcnJvcjogZXJyLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG59XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBnZXREYXRhU3RyZWFtcyhjYWxsV2l0aFJlcXVlc3Q6IGFueSwgc2VhcmNoPzogc3RyaW5nKTogUHJvbWlzZTxbRGF0YVN0cmVhbVtdLCBib29sZWFuLCBzdHJpbmddPiB7XG4gIGNvbnN0IHNlYXJjaFBhdHRlcm4gPSBzZWFyY2ggPyBgKiR7c2VhcmNofSpgIDogXCIqXCI7XG5cbiAgbGV0IGFjY2Vzc2libGUgPSB0cnVlO1xuICBsZXQgZXJyTXNnID0gXCJcIjtcbiAgY29uc3QgZGF0YVN0cmVhbXNSZXNwb25zZSA9IGF3YWl0IGNhbGxXaXRoUmVxdWVzdChcInRyYW5zcG9ydC5yZXF1ZXN0XCIsIHtcbiAgICBwYXRoOiBgL19kYXRhX3N0cmVhbS8ke3NlYXJjaFBhdHRlcm59YCxcbiAgICBtZXRob2Q6IFwiR0VUXCIsXG4gIH0pLmNhdGNoKChlKSA9PiB7XG4gICAgaWYgKGUuc3RhdHVzQ29kZSA9PT0gNDAzICYmIGUubWVzc2FnZS5zdGFydHNXaXRoKFNFQ1VSSVRZX0VYQ0VQVElPTl9QUkVGSVgpKSB7XG4gICAgICBhY2Nlc3NpYmxlID0gZmFsc2U7XG4gICAgICBlcnJNc2cgPSBlLm1lc3NhZ2U7XG4gICAgICByZXR1cm4geyBkYXRhX3N0cmVhbXM6IFtdIH07XG4gICAgfVxuICAgIHRocm93IGU7XG4gIH0pO1xuXG4gIHJldHVybiBbZGF0YVN0cmVhbXNSZXNwb25zZVtcImRhdGFfc3RyZWFtc1wiXSwgYWNjZXNzaWJsZSwgZXJyTXNnXTtcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGdldEluZGV4VG9EYXRhU3RyZWFtTWFwcGluZyhjYWxsV2l0aFJlcXVlc3Q6IERhdGFTb3VyY2VDbGllbnQpOiBQcm9taXNlPEluZGV4VG9EYXRhU3RyZWFtPiB7XG4gIGNvbnN0IFtkYXRhU3RyZWFtc10gPSBhd2FpdCBnZXREYXRhU3RyZWFtcyhjYWxsV2l0aFJlcXVlc3QpO1xuXG4gIGNvbnN0IG1hcHBpbmc6IHsgW2luZGV4TmFtZTogc3RyaW5nXTogc3RyaW5nIH0gPSB7fTtcbiAgZGF0YVN0cmVhbXMuZm9yRWFjaCgoZGF0YVN0cmVhbSkgPT4ge1xuICAgIGRhdGFTdHJlYW0uaW5kaWNlcy5mb3JFYWNoKChpbmRleCkgPT4ge1xuICAgICAgbWFwcGluZ1tpbmRleC5pbmRleF9uYW1lXSA9IGRhdGFTdHJlYW0ubmFtZTtcbiAgICB9KTtcbiAgfSk7XG5cbiAgcmV0dXJuIG1hcHBpbmc7XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBY0EsSUFBQUEsVUFBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsd0JBQUEsR0FBQUQsT0FBQTtBQUFzRixTQUFBRSxnQkFBQUMsR0FBQSxFQUFBQyxHQUFBLEVBQUFDLEtBQUEsSUFBQUQsR0FBQSxHQUFBRSxjQUFBLENBQUFGLEdBQUEsT0FBQUEsR0FBQSxJQUFBRCxHQUFBLElBQUFJLE1BQUEsQ0FBQUMsY0FBQSxDQUFBTCxHQUFBLEVBQUFDLEdBQUEsSUFBQUMsS0FBQSxFQUFBQSxLQUFBLEVBQUFJLFVBQUEsUUFBQUMsWUFBQSxRQUFBQyxRQUFBLG9CQUFBUixHQUFBLENBQUFDLEdBQUEsSUFBQUMsS0FBQSxXQUFBRixHQUFBO0FBQUEsU0FBQUcsZUFBQU0sR0FBQSxRQUFBUixHQUFBLEdBQUFTLFlBQUEsQ0FBQUQsR0FBQSwyQkFBQVIsR0FBQSxnQkFBQUEsR0FBQSxHQUFBVSxNQUFBLENBQUFWLEdBQUE7QUFBQSxTQUFBUyxhQUFBRSxLQUFBLEVBQUFDLElBQUEsZUFBQUQsS0FBQSxpQkFBQUEsS0FBQSxrQkFBQUEsS0FBQSxNQUFBRSxJQUFBLEdBQUFGLEtBQUEsQ0FBQUcsTUFBQSxDQUFBQyxXQUFBLE9BQUFGLElBQUEsS0FBQUcsU0FBQSxRQUFBQyxHQUFBLEdBQUFKLElBQUEsQ0FBQUssSUFBQSxDQUFBUCxLQUFBLEVBQUFDLElBQUEsMkJBQUFLLEdBQUEsc0JBQUFBLEdBQUEsWUFBQUUsU0FBQSw0REFBQVAsSUFBQSxnQkFBQUYsTUFBQSxHQUFBVSxNQUFBLEVBQUFULEtBQUEsS0FmdEY7QUFDQTtBQUNBO0FBQ0E7QUFjZSxNQUFNVSxpQkFBaUIsU0FBU0MsZ0RBQXVCLENBQUM7RUFBQUMsWUFBQSxHQUFBQyxJQUFBO0lBQUEsU0FBQUEsSUFBQTtJQUFBMUIsZUFBQSx5QkFDcEQsT0FDZjJCLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDc0M7TUFDbkYsSUFBSTtRQUNGLE1BQU07VUFBRUM7UUFBTyxDQUFDLEdBQUdGLE9BQU8sQ0FBQ0csS0FFMUI7UUFFRCxNQUFNQyxlQUFlLEdBQUcsSUFBSSxDQUFDQywwQkFBMEIsQ0FBQ04sT0FBTyxFQUFFQyxPQUFPLENBQUM7UUFDekUsTUFBTSxDQUFDTSxXQUFXLEVBQUVDLGFBQWEsRUFBRUMsTUFBTSxDQUFDLEdBQUcsTUFBTUMsY0FBYyxDQUFDTCxlQUFlLEVBQUVGLE1BQU0sQ0FBQztRQUUxRixJQUFJLENBQUNLLGFBQWEsRUFDaEIsT0FBT04sUUFBUSxDQUFDUyxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZDLElBQUksRUFBRTtZQUNKQyxFQUFFLEVBQUUsS0FBSztZQUNUQyxLQUFLLEVBQUVOO1VBQ1Q7UUFDRixDQUFDLENBQUM7UUFFSixPQUFPUCxRQUFRLENBQUNTLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZkMsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxJQUFJO1lBQ1JaLFFBQVEsRUFBRTtjQUNSSyxXQUFXLEVBQUVBLFdBQVc7Y0FDeEJTLGdCQUFnQixFQUFFVCxXQUFXLENBQUNVO1lBQ2hDO1VBQ0Y7UUFDRixDQUFDLENBQUM7TUFDSixDQUFDLENBQUMsT0FBT0MsR0FBRyxFQUFFO1FBQ1pDLE9BQU8sQ0FBQ0osS0FBSyxDQUFDLHdEQUF3RCxFQUFFRyxHQUFHLENBQUM7UUFDNUUsT0FBT2hCLFFBQVEsQ0FBQ1MsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmQyxJQUFJLEVBQUU7WUFDSkMsRUFBRSxFQUFFLEtBQUs7WUFDVEMsS0FBSyxFQUFFRyxHQUFHLENBQUNFO1VBQ2I7UUFDRixDQUFDLENBQUM7TUFDSjtJQUNGLENBQUM7RUFBQTtBQUNIO0FBQUNDLE9BQUEsQ0FBQUMsT0FBQSxHQUFBMUIsaUJBQUE7QUFFTSxlQUFlYyxjQUFjQSxDQUFDTCxlQUFvQixFQUFFRixNQUFlLEVBQTRDO0VBQ3BILE1BQU1vQixhQUFhLEdBQUdwQixNQUFNLEdBQUksSUFBR0EsTUFBTyxHQUFFLEdBQUcsR0FBRztFQUVsRCxJQUFJcUIsVUFBVSxHQUFHLElBQUk7RUFDckIsSUFBSWYsTUFBTSxHQUFHLEVBQUU7RUFDZixNQUFNZ0IsbUJBQW1CLEdBQUcsTUFBTXBCLGVBQWUsQ0FBQyxtQkFBbUIsRUFBRTtJQUNyRXFCLElBQUksRUFBRyxpQkFBZ0JILGFBQWMsRUFBQztJQUN0Q0ksTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDLENBQUNDLEtBQUssQ0FBRUMsQ0FBQyxJQUFLO0lBQ2QsSUFBSUEsQ0FBQyxDQUFDakIsVUFBVSxLQUFLLEdBQUcsSUFBSWlCLENBQUMsQ0FBQ1QsT0FBTyxDQUFDVSxVQUFVLENBQUNDLG9DQUF5QixDQUFDLEVBQUU7TUFDM0VQLFVBQVUsR0FBRyxLQUFLO01BQ2xCZixNQUFNLEdBQUdvQixDQUFDLENBQUNULE9BQU87TUFDbEIsT0FBTztRQUFFWSxZQUFZLEVBQUU7TUFBRyxDQUFDO0lBQzdCO0lBQ0EsTUFBTUgsQ0FBQztFQUNULENBQUMsQ0FBQztFQUVGLE9BQU8sQ0FBQ0osbUJBQW1CLENBQUMsY0FBYyxDQUFDLEVBQUVELFVBQVUsRUFBRWYsTUFBTSxDQUFDO0FBQ2xFO0FBRU8sZUFBZXdCLDJCQUEyQkEsQ0FBQzVCLGVBQWlDLEVBQThCO0VBQy9HLE1BQU0sQ0FBQ0UsV0FBVyxDQUFDLEdBQUcsTUFBTUcsY0FBYyxDQUFDTCxlQUFlLENBQUM7RUFFM0QsTUFBTTZCLE9BQXdDLEdBQUcsQ0FBQyxDQUFDO0VBQ25EM0IsV0FBVyxDQUFDNEIsT0FBTyxDQUFFQyxVQUFVLElBQUs7SUFDbENBLFVBQVUsQ0FBQ0MsT0FBTyxDQUFDRixPQUFPLENBQUVHLEtBQUssSUFBSztNQUNwQ0osT0FBTyxDQUFDSSxLQUFLLENBQUNDLFVBQVUsQ0FBQyxHQUFHSCxVQUFVLENBQUNJLElBQUk7SUFDN0MsQ0FBQyxDQUFDO0VBQ0osQ0FBQyxDQUFDO0VBRUYsT0FBT04sT0FBTztBQUNoQiJ9