"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class SnapshotManagementService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getAllSnapshotsWithPolicy", async (context, request, response) => {
      try {
        var _getRepositoryRes$pay;
        // if no repository input, we need to first get back all repositories
        const getRepositoryRes = await this.catRepositories(context, request, response);
        let repositories;
        if ((_getRepositoryRes$pay = getRepositoryRes.payload) !== null && _getRepositoryRes$pay !== void 0 && _getRepositoryRes$pay.ok) {
          var _getRepositoryRes$pay2;
          repositories = (_getRepositoryRes$pay2 = getRepositoryRes.payload) === null || _getRepositoryRes$pay2 === void 0 ? void 0 : _getRepositoryRes$pay2.response.map(repo => repo.id);
        } else {
          var _getRepositoryRes$pay3;
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: (_getRepositoryRes$pay3 = getRepositoryRes.payload) === null || _getRepositoryRes$pay3 === void 0 ? void 0 : _getRepositoryRes$pay3.error
            }
          });
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        let snapshots = [];
        for (let i = 0; i < repositories.length; i++) {
          const res = await callWithRequest("snapshot.get", {
            repository: repositories[i],
            snapshot: "_all",
            ignore_unavailable: true
          });
          const snapshotWithPolicy = res.snapshots.map(s => {
            var _s$metadata;
            return {
              id: s.snapshot,
              status: s.state,
              start_epoch: s.start_time_in_millis,
              end_epoch: s.end_time_in_millis,
              duration: s.duration_in_millis,
              indices: s.indices.length,
              successful_shards: s.shards.successful,
              failed_shards: s.shards.failed,
              total_shards: s.shards.total,
              repository: repositories[i],
              policy: (_s$metadata = s.metadata) === null || _s$metadata === void 0 ? void 0 : _s$metadata.sm_policy
            };
          });
          snapshots = [...snapshots, ...snapshotWithPolicy];
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              snapshots: snapshots,
              totalSnapshots: snapshots.length
            }
          }
        });
      } catch (err) {
        // If getting a non-existing snapshot, need to handle the missing snapshot exception, and return empty
        return this.errorResponse(response, err, "getAllSnapshotsWithPolicy");
      }
    });
    _defineProperty(this, "getSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.get", {
          repository: repository,
          snapshot: `${id}`,
          ignore_unavailable: true
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res.snapshots[0]
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getSnapshot");
      }
    });
    _defineProperty(this, "deleteSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.delete", {
          repository: repository,
          snapshot: `${id}`
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deleteSnapshot");
      }
    });
    _defineProperty(this, "createSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const params = {
          repository: repository,
          snapshot: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.create", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createSnapshot");
      }
    });
    _defineProperty(this, "restoreSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const params = {
          repository: repository,
          snapshot: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.restore", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "restoreSnapshot");
      }
    });
    _defineProperty(this, "createPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const rawRes = await callWithRequest("ism.createSMPolicy", params);
        const res = {
          seqNo: rawRes._seq_no,
          primaryTerm: rawRes._primary_term,
          id: rawRes._id,
          policy: rawRes.sm_policy
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createPolicy");
      }
    });
    _defineProperty(this, "updatePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        const params = {
          policyId: id,
          ifSeqNo: seqNo,
          ifPrimaryTerm: primaryTerm,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const rawRes = await callWithRequest("ism.updateSMPolicy", params);
        const res = {
          seqNo: rawRes._seq_no,
          primaryTerm: rawRes._primary_term,
          id: rawRes._id,
          policy: rawRes.sm_policy
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "updatePolicy");
      }
    });
    _defineProperty(this, "getPolicies", async (context, request, response) => {
      try {
        const {
          from,
          size,
          sortField,
          sortOrder,
          queryString
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        let params = {
          from,
          size,
          sortField: `sm_policy.${sortField}`,
          sortOrder,
          queryString: queryString.trim() ? `${queryString.trim()}` : "*"
        };
        const res = await callWithRequest("ism.getSMPolicies", params);
        const policies = res.policies.map(p => ({
          seqNo: p._seq_no,
          primaryTerm: p._primary_term,
          id: p._id,
          policy: p.sm_policy
        }));
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              policies,
              totalPolicies: res.total_policies
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.reason === "Snapshot management config index not found") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                policies: [],
                totalPolicies: 0
              }
            }
          });
        }
        return this.errorResponse(response, err, "getPolicies");
      }
    });
    _defineProperty(this, "getPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getSMPolicy", params);
        const metadata = await callWithRequest("ism.explainSnapshotPolicy", params);
        const documentPolicy = {
          id: id,
          seqNo: getResponse._seq_no,
          primaryTerm: getResponse._primary_term,
          policy: getResponse.sm_policy,
          metadata: metadata.policies[0]
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: documentPolicy
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.reason === "Snapshot management config index not found") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: null
            }
          });
        }
        return this.errorResponse(response, err, "getPolicy");
      }
    });
    _defineProperty(this, "deletePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deletePolicyResponse = await callWithRequest("ism.deleteSMPolicy", params);
        if (deletePolicyResponse.result !== "deleted") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: deletePolicyResponse.result
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: true
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deletePolicy");
      }
    });
    _defineProperty(this, "startPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("ism.startSnapshotPolicy", params);
        if (resp.acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to start snapshot policy."
            }
          });
        }
      } catch (err) {
        return this.errorResponse(response, err, "startPolicy");
      }
    });
    _defineProperty(this, "stopPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("ism.stopSnapshotPolicy", params);
        if (resp.acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to stop snapshot policy."
            }
          });
        }
      } catch (err) {
        return this.errorResponse(response, err, "stopPolicy");
      }
    });
    _defineProperty(this, "catRepositories", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.repositories", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catRepositories");
      }
    });
    _defineProperty(this, "getIndexRecovery", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("indices.recovery", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getIndexRecovery");
      }
    });
    _defineProperty(this, "catSnapshotIndices", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.indices", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catSnapshotIndices");
      }
    });
    _defineProperty(this, "catRepositoriesWithSnapshotCount", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.repositories", {
          format: "json"
        });
        for (let i = 0; i < res.length; i++) {
          let catSnapshotResponse = await this._safecatSnapshotForRepo(callWithRequest, res[i].id);
          res[i].snapshotCount = catSnapshotResponse === null || catSnapshotResponse === void 0 ? void 0 : catSnapshotResponse.length;
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catRepositoriesWithSnapshotCount");
      }
    });
    _defineProperty(this, "deleteRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.deleteRepository", {
          repository: id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deleteRepository");
      }
    });
    _defineProperty(this, "getRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.getRepository", {
          repository: id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getRepository");
      }
    });
    _defineProperty(this, "createRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          repository: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.createRepository", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createRepository");
      }
    });
    _defineProperty(this, "errorResponse", (response, error, methodName) => {
      console.error(`Index Management - SnapshotManagementService - ${methodName}:`, error);
      return response.custom({
        statusCode: 200,
        // error?.statusCode || 500,
        body: {
          ok: false,
          error: this.parseEsErrorResponse(error)
        }
      });
    });
    _defineProperty(this, "parseEsErrorResponse", error => {
      if (error.response) {
        try {
          const esErrorResponse = JSON.parse(error.response);
          return esErrorResponse.reason || error.response;
        } catch (parsingError) {
          return error.response;
        }
      }
      return error.message;
    });
  }
  async _safecatSnapshotForRepo(callWithRequest, repositoryName) {
    try {
      const catSnapshotRes = await callWithRequest("cat.snapshots", {
        format: "json",
        repository: repositoryName,
        ignore_unavailable: true
      });
      return catSnapshotRes;
    } catch (err) {
      console.error(`Index Management - SnapshotManagementService - _safeCatSnapshot:`, err);
      return undefined;
    }
  }
}
exports.default = SnapshotManagementService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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