"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class TransformService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getTransforms", async (context, request, response) => {
      try {
        const {
          from,
          size,
          search,
          sortDirection,
          sortField
        } = request.query;
        const transformSortMap = {
          _id: "transform.transform_id.keyword",
          "transform.source_index": "transform.source_index.keyword",
          "transform.target_index": "transform.target_index.keyword",
          "transform.transform.enabled": "transform.enabled"
        };
        const params = {
          from: parseInt(from, 10),
          size: parseInt(size, 10),
          search,
          sortField: transformSortMap[sortField] || transformSortMap._id,
          sortDirection
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getTransformsResponse = await callWithRequest("ism.getTransforms", params);
        const totalTransforms = getTransformsResponse.total_transforms;
        const transforms = getTransformsResponse.transforms.map(transform => ({
          _seqNo: transform._seqNo,
          _primaryTerm: transform._primaryTerm,
          _id: transform._id,
          transform: transform.transform,
          metadata: null
        }));
        if (totalTransforms) {
          const ids = transforms.map(transform => transform._id).join(",");
          const callWithRequest = this.getClientBasedOnDataSource(context, request);
          const explainResponse = await callWithRequest("ism.explainTransform", {
            transformId: ids
          });
          if (!explainResponse.error) {
            transforms.map(transform => {
              transform.metadata = explainResponse[transform._id];
            });
            return response.custom({
              statusCode: 200,
              body: {
                ok: true,
                response: {
                  transforms: transforms,
                  totalTransforms: totalTransforms,
                  metadata: explainResponse
                }
              }
            });
          } else {
            return response.custom({
              statusCode: 200,
              body: {
                ok: false,
                error: explainResponse ? explainResponse.error : "An error occurred when calling getExplain API."
              }
            });
          }
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              transforms: transforms,
              totalTransforms: totalTransforms,
              metadata: {}
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.type === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                transforms: [],
                totalTransforms: 0,
                metadata: null
              }
            }
          });
        }
        console.error("Index Management - TransformService - getTransforms", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: "Error in getTransforms" + err.message
          }
        });
      }
    });
    _defineProperty(this, "getTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          transformId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getTransform", params);
        const metadata = await callWithRequest("ism.explainTransform", params);
        const transform = _lodash.default.get(getResponse, "transform", null);
        const seqNo = _lodash.default.get(getResponse, "_seq_no", null);
        const primaryTerm = _lodash.default.get(getResponse, "_primary_term", null);
        if (transform) {
          if (metadata) {
            return response.custom({
              statusCode: 200,
              body: {
                ok: true,
                response: {
                  _id: id,
                  _seqNo: seqNo,
                  _primaryTerm: primaryTerm,
                  transform: transform,
                  metadata: metadata
                }
              }
            });
          } else {
            return response.custom({
              statusCode: 200,
              body: {
                ok: false,
                error: "Failed to load metadata for transform"
              }
            });
          }
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to load transform"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - TransformService - getTransform:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "startTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          transformId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const startResponse = await callWithRequest("ism.startTransform", params);
        const acknowledged = _lodash.default.get(startResponse, "acknowledged");
        if (acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to start transform"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - TransformService - startTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "stopTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          transformId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const stopResponse = await callWithRequest("ism.stopTransform", params);
        const acknowledged = _lodash.default.get(stopResponse, "acknowledged");
        if (acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to stop transform"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - TransformService - stopTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "deleteTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          transformId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deleteResponse = await callWithRequest("ism.deleteTransform", params);
        if (!deleteResponse.errors) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to delete transform"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - TransformService - deleteTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "putTransform", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        let method = "ism.putTransform";
        let params = {
          transformId: id,
          if_seq_no: seqNo,
          if_primary_term: primaryTerm,
          body: JSON.stringify(request.body)
        };
        if (seqNo === undefined || primaryTerm === undefined) {
          method = "ism.putTransform";
          params = {
            transformId: id,
            body: JSON.stringify(request.body)
          };
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const putTransformResponse = await callWithRequest(method, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: putTransformResponse
          }
        });
      } catch (err) {
        console.error("Index Management - TransformService - putTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "searchSampleData", async (context, request, response) => {
      try {
        const {
          from,
          size
        } = request.query;
        const {
          index
        } = request.params;
        let params = {
          index: index,
          from: from,
          size: size,
          body: request.body ? JSON.stringify({
            query: request.body
          }) : {}
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const searchResponse = await callWithRequest("search", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              total: searchResponse.hits.total,
              data: searchResponse.hits.hits
            }
          }
        });
      } catch (err) {
        var _err$body;
        if (err.statusCode === 404 && ((_err$body = err.body) === null || _err$body === void 0 || (_err$body = _err$body.error) === null || _err$body === void 0 ? void 0 : _err$body.type) === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                total: 0,
                data: []
              }
            }
          });
        }
        console.error("Index Management - TransformService - searchSampleData", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "previewTransform", async (context, request, response) => {
      try {
        let params = {
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const previewResponse = await callWithRequest("ism.previewTransform", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: previewResponse
          }
        });
      } catch (err) {
        console.error("Index Management - TransformService - previewTransform", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = TransformService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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