"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLQueryParser = void 0;
var _ppl_syntax_parser = require("../antlr/ppl_syntax_parser");
var _stats_ast_builder = require("../ast/builder/stats_ast_builder");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class PPLQueryParser {
  constructor() {
    _defineProperty(this, "parser", null);
    _defineProperty(this, "visitor", null);
    _defineProperty(this, "rawQuery", '');
  }
  parse(pplQuery) {
    this.rawQuery = pplQuery;
    this.parser = new _ppl_syntax_parser.PPLSyntaxParser().parse(this.rawQuery);
    return this;
  }
  getStats() {
    this.visitor = new _stats_ast_builder.StatsAstBuilder();
    let inter = null;
    try {
      inter = this.visitor.visitRoot(this.parser.root()).getTokens();
    } catch (e) {
      console.error(e);
    }
    return inter;
  }
}
exports.PPLQueryParser = PPLQueryParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfcHBsX3N5bnRheF9wYXJzZXIiLCJyZXF1aXJlIiwiX3N0YXRzX2FzdF9idWlsZGVyIiwiX2RlZmluZVByb3BlcnR5IiwiZSIsInIiLCJ0IiwiX3RvUHJvcGVydHlLZXkiLCJPYmplY3QiLCJkZWZpbmVQcm9wZXJ0eSIsInZhbHVlIiwiZW51bWVyYWJsZSIsImNvbmZpZ3VyYWJsZSIsIndyaXRhYmxlIiwiaSIsIl90b1ByaW1pdGl2ZSIsIlN5bWJvbCIsInRvUHJpbWl0aXZlIiwiY2FsbCIsIlR5cGVFcnJvciIsIlN0cmluZyIsIk51bWJlciIsIlBQTFF1ZXJ5UGFyc2VyIiwiY29uc3RydWN0b3IiLCJwYXJzZSIsInBwbFF1ZXJ5IiwicmF3UXVlcnkiLCJwYXJzZXIiLCJQUExTeW50YXhQYXJzZXIiLCJnZXRTdGF0cyIsInZpc2l0b3IiLCJTdGF0c0FzdEJ1aWxkZXIiLCJpbnRlciIsInZpc2l0Um9vdCIsInJvb3QiLCJnZXRUb2tlbnMiLCJjb25zb2xlIiwiZXJyb3IiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsicHBsX3F1ZXJ5X3BhcnNlci50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IFBQTFN5bnRheFBhcnNlciB9IGZyb20gJy4uL2FudGxyL3BwbF9zeW50YXhfcGFyc2VyJztcbmltcG9ydCB7IE9wZW5TZWFyY2hQUExQYXJzZXIgfSBmcm9tICcuLi9hbnRsci9vdXRwdXQvT3BlblNlYXJjaFBQTFBhcnNlcic7XG5pbXBvcnQgeyBTdGF0c0FzdEJ1aWxkZXIgfSBmcm9tICcuLi9hc3QvYnVpbGRlci9zdGF0c19hc3RfYnVpbGRlcic7XG5cbmV4cG9ydCBjbGFzcyBQUExRdWVyeVBhcnNlciB7XG4gIHBhcnNlcjogT3BlblNlYXJjaFBQTFBhcnNlciB8IG51bGwgPSBudWxsO1xuICB2aXNpdG9yOiBhbnkgPSBudWxsO1xuICByYXdRdWVyeTogc3RyaW5nID0gJyc7XG5cbiAgcGFyc2UocHBsUXVlcnk6IHN0cmluZykge1xuICAgIHRoaXMucmF3UXVlcnkgPSBwcGxRdWVyeTtcbiAgICB0aGlzLnBhcnNlciA9IG5ldyBQUExTeW50YXhQYXJzZXIoKS5wYXJzZSh0aGlzLnJhd1F1ZXJ5KTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIGdldFN0YXRzKCkge1xuICAgIHRoaXMudmlzaXRvciA9IG5ldyBTdGF0c0FzdEJ1aWxkZXIoKTtcbiAgICBsZXQgaW50ZXIgPSBudWxsO1xuICAgIHRyeSB7XG4gICAgICBpbnRlciA9IHRoaXMudmlzaXRvci52aXNpdFJvb3QodGhpcy5wYXJzZXIhLnJvb3QoKSkuZ2V0VG9rZW5zKCk7XG4gICAgfSBjYXRjaCAoZSkge1xuICAgICAgY29uc29sZS5lcnJvcihlKTtcbiAgICB9XG4gICAgcmV0dXJuIGludGVyO1xuICB9XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLGtCQUFBLEdBQUFDLE9BQUE7QUFFQSxJQUFBQyxrQkFBQSxHQUFBRCxPQUFBO0FBQW1FLFNBQUFFLGdCQUFBQyxDQUFBLEVBQUFDLENBQUEsRUFBQUMsQ0FBQSxZQUFBRCxDQUFBLEdBQUFFLGNBQUEsQ0FBQUYsQ0FBQSxNQUFBRCxDQUFBLEdBQUFJLE1BQUEsQ0FBQUMsY0FBQSxDQUFBTCxDQUFBLEVBQUFDLENBQUEsSUFBQUssS0FBQSxFQUFBSixDQUFBLEVBQUFLLFVBQUEsTUFBQUMsWUFBQSxNQUFBQyxRQUFBLFVBQUFULENBQUEsQ0FBQUMsQ0FBQSxJQUFBQyxDQUFBLEVBQUFGLENBQUE7QUFBQSxTQUFBRyxlQUFBRCxDQUFBLFFBQUFRLENBQUEsR0FBQUMsWUFBQSxDQUFBVCxDQUFBLHVDQUFBUSxDQUFBLEdBQUFBLENBQUEsR0FBQUEsQ0FBQTtBQUFBLFNBQUFDLGFBQUFULENBQUEsRUFBQUQsQ0FBQSwyQkFBQUMsQ0FBQSxLQUFBQSxDQUFBLFNBQUFBLENBQUEsTUFBQUYsQ0FBQSxHQUFBRSxDQUFBLENBQUFVLE1BQUEsQ0FBQUMsV0FBQSxrQkFBQWIsQ0FBQSxRQUFBVSxDQUFBLEdBQUFWLENBQUEsQ0FBQWMsSUFBQSxDQUFBWixDQUFBLEVBQUFELENBQUEsdUNBQUFTLENBQUEsU0FBQUEsQ0FBQSxZQUFBSyxTQUFBLHlFQUFBZCxDQUFBLEdBQUFlLE1BQUEsR0FBQUMsTUFBQSxFQUFBZixDQUFBLEtBUG5FO0FBQ0E7QUFDQTtBQUNBO0FBTU8sTUFBTWdCLGNBQWMsQ0FBQztFQUFBQyxZQUFBO0lBQUFwQixlQUFBLGlCQUNXLElBQUk7SUFBQUEsZUFBQSxrQkFDMUIsSUFBSTtJQUFBQSxlQUFBLG1CQUNBLEVBQUU7RUFBQTtFQUVyQnFCLEtBQUtBLENBQUNDLFFBQWdCLEVBQUU7SUFDdEIsSUFBSSxDQUFDQyxRQUFRLEdBQUdELFFBQVE7SUFDeEIsSUFBSSxDQUFDRSxNQUFNLEdBQUcsSUFBSUMsa0NBQWUsQ0FBQyxDQUFDLENBQUNKLEtBQUssQ0FBQyxJQUFJLENBQUNFLFFBQVEsQ0FBQztJQUN4RCxPQUFPLElBQUk7RUFDYjtFQUVBRyxRQUFRQSxDQUFBLEVBQUc7SUFDVCxJQUFJLENBQUNDLE9BQU8sR0FBRyxJQUFJQyxrQ0FBZSxDQUFDLENBQUM7SUFDcEMsSUFBSUMsS0FBSyxHQUFHLElBQUk7SUFDaEIsSUFBSTtNQUNGQSxLQUFLLEdBQUcsSUFBSSxDQUFDRixPQUFPLENBQUNHLFNBQVMsQ0FBQyxJQUFJLENBQUNOLE1BQU0sQ0FBRU8sSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDQyxTQUFTLENBQUMsQ0FBQztJQUNqRSxDQUFDLENBQUMsT0FBTy9CLENBQUMsRUFBRTtNQUNWZ0MsT0FBTyxDQUFDQyxLQUFLLENBQUNqQyxDQUFDLENBQUM7SUFDbEI7SUFDQSxPQUFPNEIsS0FBSztFQUNkO0FBQ0Y7QUFBQ00sT0FBQSxDQUFBaEIsY0FBQSxHQUFBQSxjQUFBIn0=