"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSampleNotes = addSampleNotes;
exports.cloneNotebook = cloneNotebook;
exports.createNotebook = createNotebook;
exports.fetchNotebooks = fetchNotebooks;
exports.renameNotebook = renameNotebook;
var _observability_saved_object_attributes = require("../../../common/types/observability_saved_object_attributes");
var _sample_notebooks = require("../../../server/common/helpers/notebooks/sample_notebooks");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function fetchNotebooks(savedObjectNotebooks) {
  const notebooks = [];
  savedObjectNotebooks.map(savedObject => {
    if (savedObject.type === 'observability-notebook' && savedObject.attributes.savedNotebook) {
      notebooks.push({
        dateCreated: savedObject.attributes.savedNotebook.dateCreated,
        dateModified: savedObject.attributes.savedNotebook.dateModified,
        path: savedObject.attributes.savedNotebook.name,
        id: savedObject.id
      });
    }
  });
  return notebooks;
}
function createNotebook(notebookName) {
  const noteObject = {
    dateCreated: new Date().toISOString(),
    name: notebookName.name,
    dateModified: new Date().toISOString(),
    backend: '.kibana_1.0',
    paragraphs: [],
    path: notebookName.name
  };
  return {
    savedNotebook: noteObject
  };
}
function cloneNotebook(fetchedNotebook, name) {
  const noteObject = {
    dateCreated: new Date().toISOString(),
    name,
    dateModified: new Date().toISOString(),
    backend: 'kibana_1.0',
    paragraphs: fetchedNotebook.paragraphs,
    path: name
  };
  return {
    savedNotebook: noteObject
  };
}
function renameNotebook(noteBookObj) {
  const noteObject = {
    name: noteBookObj.name,
    dateModified: new Date().toISOString(),
    path: noteBookObj.name
  };
  return {
    savedNotebook: noteObject
  };
}
async function addSampleNotes(opensearchNotebooksClient, visIds) {
  const notebooks = (0, _sample_notebooks.getSampleNotebooks)(visIds);
  const sampleNotebooks = [];
  try {
    for (const item of notebooks) {
      const createdNotebooks = await opensearchNotebooksClient.create(_observability_saved_object_attributes.NOTEBOOK_SAVED_OBJECT, item);
      sampleNotebooks.push({
        dateCreated: createdNotebooks.attributes.savedNotebook.dateCreated,
        dateModified: createdNotebooks.attributes.savedNotebook.dateModified,
        name: createdNotebooks.attributes.savedNotebook.name,
        id: createdNotebooks.id,
        path: createdNotebooks.attributes.savedNotebook.name
      });
    }
    return {
      status: 'OK',
      message: '',
      body: sampleNotebooks
    };
  } catch (error) {
    console.log('error', error);
    throw new Error('Update Sample Notebook error' + error);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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