"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class TranslateService {
  constructor(_client, dataSourceEnabled, logger) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "translateSQL", async (context, request) => {
      try {
        const queryRequest = {
          query: request.body.query
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        let client = this.client;
        let queryResponse;
        const {
          dataSourceMDSId
        } = request.query;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI('sql.translateSQL', params);
        } else {
          queryResponse = await client.asScoped(request).callAsCurrentUser('sql.translateSQL', params);
        }
        const ret = {
          data: {
            ok: true,
            resp: queryResponse
          }
        };
        return ret;
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message
          }
        };
      }
    });
    _defineProperty(this, "translatePPL", async (context, request) => {
      try {
        const queryRequest = {
          query: request.body.query
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        let queryResponse;
        let client = this.client;
        const {
          dataSourceMDSId
        } = request.query;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI('sql.translatePPL', params);
        } else {
          queryResponse = await client.asScoped(request).callAsCurrentUser('sql.translatePPL', params);
        }
        return {
          data: {
            ok: true,
            resp: queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message
          }
        };
      }
    });
    this.client = _client;
    this.dataSourceEnabled = dataSourceEnabled;
  }
}
exports.default = TranslateService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJUcmFuc2xhdGVTZXJ2aWNlIiwiY29uc3RydWN0b3IiLCJjbGllbnQiLCJkYXRhU291cmNlRW5hYmxlZCIsImxvZ2dlciIsIl9kZWZpbmVQcm9wZXJ0eSIsImNvbnRleHQiLCJyZXF1ZXN0IiwicXVlcnlSZXF1ZXN0IiwicXVlcnkiLCJib2R5IiwicGFyYW1zIiwiSlNPTiIsInN0cmluZ2lmeSIsInF1ZXJ5UmVzcG9uc2UiLCJkYXRhU291cmNlTURTSWQiLCJkYXRhU291cmNlIiwib3BlbnNlYXJjaCIsImxlZ2FjeSIsImdldENsaWVudCIsImNhbGxBUEkiLCJhc1Njb3BlZCIsImNhbGxBc0N1cnJlbnRVc2VyIiwicmV0IiwiZGF0YSIsIm9rIiwicmVzcCIsImVyciIsImNvbnNvbGUiLCJsb2ciLCJtZXNzYWdlIiwiZXhwb3J0cyIsImRlZmF1bHQiLCJtb2R1bGUiXSwic291cmNlcyI6WyJUcmFuc2xhdGVTZXJ2aWNlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cbmltcG9ydCB7IExvZ2dlciB9IGZyb20gXCIuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXJcIjtcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgVHJhbnNsYXRlU2VydmljZSB7XG4gIHByaXZhdGUgY2xpZW50OiBhbnk7XG4gIHByaXZhdGUgZGF0YVNvdXJjZUVuYWJsZWQ6IGJvb2xlYW47XG5cbiAgY29uc3RydWN0b3IoY2xpZW50OiBhbnksIGRhdGFTb3VyY2VFbmFibGVkOiBib29sZWFuLCBsb2dnZXI6IExvZ2dlcikge1xuICAgIHRoaXMuY2xpZW50ID0gY2xpZW50O1xuICAgIHRoaXMuZGF0YVNvdXJjZUVuYWJsZWQgPSBkYXRhU291cmNlRW5hYmxlZDtcbiAgfVxuXG4gIHRyYW5zbGF0ZVNRTCA9IGFzeW5jIChjb250ZXh0OiBhbnksIHJlcXVlc3Q6IGFueSkgPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCBxdWVyeVJlcXVlc3QgPSB7XG4gICAgICAgIHF1ZXJ5OiByZXF1ZXN0LmJvZHkucXVlcnksXG4gICAgICB9O1xuXG4gICAgICBjb25zdCBwYXJhbXMgPSB7XG4gICAgICAgIGJvZHk6IEpTT04uc3RyaW5naWZ5KHF1ZXJ5UmVxdWVzdCksXG4gICAgICB9O1xuICAgICAgbGV0IGNsaWVudCA9IHRoaXMuY2xpZW50O1xuICAgICAgbGV0IHF1ZXJ5UmVzcG9uc2U7XG4gICAgICBjb25zdCB7ZGF0YVNvdXJjZU1EU0lkfSA9IHJlcXVlc3QucXVlcnk7XG4gICAgICBpZiAodGhpcy5kYXRhU291cmNlRW5hYmxlZCAmJiBkYXRhU291cmNlTURTSWQpIHtcbiAgICAgICAgY2xpZW50ID0gY29udGV4dC5kYXRhU291cmNlLm9wZW5zZWFyY2gubGVnYWN5LmdldENsaWVudChkYXRhU291cmNlTURTSWQpO1xuICAgICAgICBxdWVyeVJlc3BvbnNlID0gYXdhaXQgY2xpZW50LmNhbGxBUEkoJ3NxbC50cmFuc2xhdGVTUUwnLCBwYXJhbXMpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcXVlcnlSZXNwb25zZSA9IGF3YWl0IGNsaWVudFxuICAgICAgICAgIC5hc1Njb3BlZChyZXF1ZXN0KVxuICAgICAgICAgIC5jYWxsQXNDdXJyZW50VXNlcignc3FsLnRyYW5zbGF0ZVNRTCcsIHBhcmFtcyk7XG4gICAgICB9XG5cbiAgICAgIGNvbnN0IHJldCA9IHtcbiAgICAgICAgZGF0YToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3A6IHF1ZXJ5UmVzcG9uc2UsXG4gICAgICAgIH0sXG4gICAgICB9O1xuICAgICAgcmV0dXJuIHJldDtcbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgIGNvbnNvbGUubG9nKGVycik7XG4gICAgICByZXR1cm4ge1xuICAgICAgICBkYXRhOiB7XG4gICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgIHJlc3A6IGVyci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfTtcbiAgICB9XG4gIH07XG5cbiAgdHJhbnNsYXRlUFBMID0gYXN5bmMgKGNvbnRleHQ6IGFueSwgcmVxdWVzdDogYW55KSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHF1ZXJ5UmVxdWVzdCA9IHtcbiAgICAgICAgcXVlcnk6IHJlcXVlc3QuYm9keS5xdWVyeSxcbiAgICAgIH07XG5cbiAgICAgIGNvbnN0IHBhcmFtcyA9IHtcbiAgICAgICAgYm9keTogSlNPTi5zdHJpbmdpZnkocXVlcnlSZXF1ZXN0KSxcbiAgICAgIH07XG5cbiAgICAgIGxldCBxdWVyeVJlc3BvbnNlO1xuICAgICAgbGV0IGNsaWVudCA9IHRoaXMuY2xpZW50O1xuICAgICAgY29uc3Qge2RhdGFTb3VyY2VNRFNJZH0gPSByZXF1ZXN0LnF1ZXJ5O1xuICAgICAgaWYgKHRoaXMuZGF0YVNvdXJjZUVuYWJsZWQgJiYgZGF0YVNvdXJjZU1EU0lkKSB7XG4gICAgICAgIGNsaWVudCA9IGNvbnRleHQuZGF0YVNvdXJjZS5vcGVuc2VhcmNoLmxlZ2FjeS5nZXRDbGllbnQoZGF0YVNvdXJjZU1EU0lkKTtcbiAgICAgICAgcXVlcnlSZXNwb25zZSA9IGF3YWl0IGNsaWVudFxuICAgICAgICAuY2FsbEFQSSgnc3FsLnRyYW5zbGF0ZVBQTCcsIHBhcmFtcyk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBxdWVyeVJlc3BvbnNlID0gYXdhaXQgY2xpZW50XG4gICAgICAgICAgLmFzU2NvcGVkKHJlcXVlc3QpXG4gICAgICAgICAgLmNhbGxBc0N1cnJlbnRVc2VyKCdzcWwudHJhbnNsYXRlUFBMJywgcGFyYW1zKTtcbiAgICAgIH1cbiAgICAgIHJldHVybiB7XG4gICAgICAgIGRhdGE6IHtcbiAgICAgICAgICBvazogdHJ1ZSxcbiAgICAgICAgICByZXNwOiBxdWVyeVJlc3BvbnNlLFxuICAgICAgICB9LFxuICAgICAgfTtcbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgIGNvbnNvbGUubG9nKGVycik7XG4gICAgICByZXR1cm4ge1xuICAgICAgICBkYXRhOiB7XG4gICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgIHJlc3A6IGVyci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfTtcbiAgICB9XG4gIH07XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQUdlLE1BQU1BLGdCQUFnQixDQUFDO0VBSXBDQyxXQUFXQSxDQUFDQyxPQUFXLEVBQUVDLGlCQUEwQixFQUFFQyxNQUFjLEVBQUU7SUFBQUMsZUFBQTtJQUFBQSxlQUFBO0lBQUFBLGVBQUEsdUJBS3RELE9BQU9DLE9BQVksRUFBRUMsT0FBWSxLQUFLO01BQ25ELElBQUk7UUFDRixNQUFNQyxZQUFZLEdBQUc7VUFDbkJDLEtBQUssRUFBRUYsT0FBTyxDQUFDRyxJQUFJLENBQUNEO1FBQ3RCLENBQUM7UUFFRCxNQUFNRSxNQUFNLEdBQUc7VUFDYkQsSUFBSSxFQUFFRSxJQUFJLENBQUNDLFNBQVMsQ0FBQ0wsWUFBWTtRQUNuQyxDQUFDO1FBQ0QsSUFBSU4sTUFBTSxHQUFHLElBQUksQ0FBQ0EsTUFBTTtRQUN4QixJQUFJWSxhQUFhO1FBQ2pCLE1BQU07VUFBQ0M7UUFBZSxDQUFDLEdBQUdSLE9BQU8sQ0FBQ0UsS0FBSztRQUN2QyxJQUFJLElBQUksQ0FBQ04saUJBQWlCLElBQUlZLGVBQWUsRUFBRTtVQUM3Q2IsTUFBTSxHQUFHSSxPQUFPLENBQUNVLFVBQVUsQ0FBQ0MsVUFBVSxDQUFDQyxNQUFNLENBQUNDLFNBQVMsQ0FBQ0osZUFBZSxDQUFDO1VBQ3hFRCxhQUFhLEdBQUcsTUFBTVosTUFBTSxDQUFDa0IsT0FBTyxDQUFDLGtCQUFrQixFQUFFVCxNQUFNLENBQUM7UUFDbEUsQ0FBQyxNQUFNO1VBQ0xHLGFBQWEsR0FBRyxNQUFNWixNQUFNLENBQ3pCbUIsUUFBUSxDQUFDZCxPQUFPLENBQUMsQ0FDakJlLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFWCxNQUFNLENBQUM7UUFDbEQ7UUFFQSxNQUFNWSxHQUFHLEdBQUc7VUFDVkMsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxJQUFJO1lBQ1JDLElBQUksRUFBRVo7VUFDUjtRQUNGLENBQUM7UUFDRCxPQUFPUyxHQUFHO01BQ1osQ0FBQyxDQUFDLE9BQU9JLEdBQUcsRUFBRTtRQUNaQyxPQUFPLENBQUNDLEdBQUcsQ0FBQ0YsR0FBRyxDQUFDO1FBQ2hCLE9BQU87VUFDTEgsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxLQUFLO1lBQ1RDLElBQUksRUFBRUMsR0FBRyxDQUFDRztVQUNaO1FBQ0YsQ0FBQztNQUNIO0lBQ0YsQ0FBQztJQUFBekIsZUFBQSx1QkFFYyxPQUFPQyxPQUFZLEVBQUVDLE9BQVksS0FBSztNQUNuRCxJQUFJO1FBQ0YsTUFBTUMsWUFBWSxHQUFHO1VBQ25CQyxLQUFLLEVBQUVGLE9BQU8sQ0FBQ0csSUFBSSxDQUFDRDtRQUN0QixDQUFDO1FBRUQsTUFBTUUsTUFBTSxHQUFHO1VBQ2JELElBQUksRUFBRUUsSUFBSSxDQUFDQyxTQUFTLENBQUNMLFlBQVk7UUFDbkMsQ0FBQztRQUVELElBQUlNLGFBQWE7UUFDakIsSUFBSVosTUFBTSxHQUFHLElBQUksQ0FBQ0EsTUFBTTtRQUN4QixNQUFNO1VBQUNhO1FBQWUsQ0FBQyxHQUFHUixPQUFPLENBQUNFLEtBQUs7UUFDdkMsSUFBSSxJQUFJLENBQUNOLGlCQUFpQixJQUFJWSxlQUFlLEVBQUU7VUFDN0NiLE1BQU0sR0FBR0ksT0FBTyxDQUFDVSxVQUFVLENBQUNDLFVBQVUsQ0FBQ0MsTUFBTSxDQUFDQyxTQUFTLENBQUNKLGVBQWUsQ0FBQztVQUN4RUQsYUFBYSxHQUFHLE1BQU1aLE1BQU0sQ0FDM0JrQixPQUFPLENBQUMsa0JBQWtCLEVBQUVULE1BQU0sQ0FBQztRQUN0QyxDQUFDLE1BQU07VUFDTEcsYUFBYSxHQUFHLE1BQU1aLE1BQU0sQ0FDekJtQixRQUFRLENBQUNkLE9BQU8sQ0FBQyxDQUNqQmUsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUVYLE1BQU0sQ0FBQztRQUNsRDtRQUNBLE9BQU87VUFDTGEsSUFBSSxFQUFFO1lBQ0pDLEVBQUUsRUFBRSxJQUFJO1lBQ1JDLElBQUksRUFBRVo7VUFDUjtRQUNGLENBQUM7TUFDSCxDQUFDLENBQUMsT0FBT2EsR0FBRyxFQUFFO1FBQ1pDLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDRixHQUFHLENBQUM7UUFDaEIsT0FBTztVQUNMSCxJQUFJLEVBQUU7WUFDSkMsRUFBRSxFQUFFLEtBQUs7WUFDVEMsSUFBSSxFQUFFQyxHQUFHLENBQUNHO1VBQ1o7UUFDRixDQUFDO01BQ0g7SUFDRixDQUFDO0lBaEZDLElBQUksQ0FBQzVCLE1BQU0sR0FBR0EsT0FBTTtJQUNwQixJQUFJLENBQUNDLGlCQUFpQixHQUFHQSxpQkFBaUI7RUFDNUM7QUErRUY7QUFBQzRCLE9BQUEsQ0FBQUMsT0FBQSxHQUFBaEMsZ0JBQUE7QUFBQWlDLE1BQUEsQ0FBQUYsT0FBQSxHQUFBQSxPQUFBLENBQUFDLE9BQUEifQ==