"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("core-js/modules/es.regexp.flags.js");
require("core-js/modules/es.typed-array.set.js");
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class QueryService {
  constructor(_client, dataSourceEnabled, logger) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "describeQueryPostInternal", async (request, format, responseFormat, body, context) => {
      try {
        const params = {
          body: JSON.stringify(body)
        };
        let client = this.client;
        let queryResponse;
        const {
          dataSourceMDSId
        } = request.query;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, params);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryPostInternal');
        this.logger.info(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body,
            statusCode: err.statusCode || 400
          }
        };
      }
    });
    _defineProperty(this, "describeQueryJobIdInternal", async (request, format, jobId, responseFormat, context, dataSourceMDSId) => {
      try {
        let client = this.client;
        let queryResponse;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, {
            jobId: jobId
          });
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, {
            jobId: jobId
          });
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info(err);
        this.logger.info(request.query);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body,
            statusCode: err.statusCode || 400
          }
        };
      }
    });
    _defineProperty(this, "describeQueryGetInternalSync", async (request, format, responseFormat, context) => {
      try {
        let client = this.client;
        let queryResponse;
        const dataSourceMDSId = request.params.dataSourceMDSId;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryGetInternalSync');
        this.logger.info(err);
        this.logger.info(request.query);
        console.log(err, request.query);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body,
            statusCode: err.statusCode || 400
          }
        };
      }
    });
    _defineProperty(this, "describeSQLQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlQuery', 'json', request.body, context);
    });
    _defineProperty(this, "describePPLQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplQuery', 'json', request.body, context);
    });
    _defineProperty(this, "describeSQLCsv", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlCsv', null, request.body, context);
    });
    _defineProperty(this, "describePPLCsv", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplCsv', null, request.body, context);
    });
    _defineProperty(this, "describeSQLJson", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlJson', 'json', request.body, context);
    });
    _defineProperty(this, "describePPLJson", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplJson', 'json', request.body, context);
    });
    _defineProperty(this, "describeSQLText", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlText', null, request.body, context);
    });
    _defineProperty(this, "describePPLText", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplText', null, request.body, context);
    });
    _defineProperty(this, "describeSQLAsyncQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sparkSqlQuery', null, request.body, context);
    });
    _defineProperty(this, "describeSQLAsyncGetQuery", async (context, request, jobId, dataSourceMDSId) => {
      return this.describeQueryJobIdInternal(request, 'sql.sparkSqlGetQuery', jobId, null, context, dataSourceMDSId);
    });
    _defineProperty(this, "describeSyncQueryDataSources", async (context, request) => {
      return this.describeQueryGetInternalSync(request, 'sql.datasourcesGetQuery', null, context);
    });
    _defineProperty(this, "describeAsyncDeleteQuery", async (context, request, jobId, dataSourceMDSId) => {
      return this.describeQueryJobIdInternal(request, 'sql.asyncDeleteQuery', jobId, null, context, dataSourceMDSId);
    });
    this.client = _client;
    this.dataSourceEnabled = dataSourceEnabled;
    this.logger = logger;
  }
}
exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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