"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySavedObjectsClientWrapper = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _common = require("../../common");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
class SecuritySavedObjectsClientWrapper {
  constructor() {
    _defineProperty(this, "httpStart", void 0);
    _defineProperty(this, "config", void 0);
    _defineProperty(this, "wrapperFactory", wrapperOptions => {
      var _state$authInfo;
      const state = this.httpStart.auth.get(wrapperOptions.request).state || {};
      const selectedTenant = state.selectedTenant;
      const username = (_state$authInfo = state.authInfo) === null || _state$authInfo === void 0 ? void 0 : _state$authInfo.user_name;
      const isGlobalEnabled = this.config.multitenancy.tenants.enable_global;
      const isPrivateEnabled = this.config.multitenancy.tenants.enable_private;
      let namespaceValue = selectedTenant;
      const createWithNamespace = async (type, attributes, options) => {
        namespaceValue = this.getNamespaceValue(selectedTenant, isPrivateEnabled, username);
        _lodash.default.assign(options, {
          namespace: [namespaceValue]
        });
        return await wrapperOptions.client.create(type, attributes, options);
      };
      const bulkGetWithNamespace = async (objects = [], options = {}) => {
        namespaceValue = this.getNamespaceValue(selectedTenant, isPrivateEnabled, username);
        _lodash.default.assign(options, {
          namespace: [namespaceValue]
        });
        return await wrapperOptions.client.bulkGet(objects, options);
      };
      const findWithNamespace = async options => {
        var _state$authInfo2;
        const tenants = (_state$authInfo2 = state.authInfo) === null || _state$authInfo2 === void 0 ? void 0 : _state$authInfo2.tenants;
        const availableTenantNames = Object.keys(tenants);
        availableTenantNames.push(_common.DEFAULT_TENANT); // The value of namespace is "default" if saved objects are created when opensearch_security.multitenancy.enable_aggregation_view is set to false. So adding it to find.
        if (isGlobalEnabled) {
          availableTenantNames.push(_common.GLOBAL_TENANT_SYMBOL);
        }
        if (isPrivateEnabled) {
          availableTenantNames.push(_common.PRIVATE_TENANT_SYMBOL + username);
        }
        if (availableTenantNames.includes(_common.globalTenantName)) {
          let index = availableTenantNames.indexOf(_common.globalTenantName);
          if (index > -1) {
            availableTenantNames.splice(index, 1);
          }
          index = availableTenantNames.indexOf(username);
          if (index > -1) {
            availableTenantNames.splice(index, 1);
          }
        }
        if ((0, _common.isPrivateTenant)(selectedTenant)) {
          namespaceValue = selectedTenant + username;
        }
        if (!!options.namespaces) {
          const namespacesToInclude = Array.isArray(options.namespaces) ? options.namespaces : [options.namespaces];
          const typeToNamespacesMap = {};
          const searchTypes = Array.isArray(options.type) ? options.type : [options.type];
          searchTypes.forEach(t => {
            typeToNamespacesMap[t] = namespacesToInclude;
          });
          if (searchTypes.includes('config')) {
            if (namespacesToInclude.includes(namespaceValue)) {
              typeToNamespacesMap.config = [namespaceValue];
            } else {
              delete typeToNamespacesMap.config;
            }
          }
          options.typeToNamespacesMap = new Map(Object.entries(typeToNamespacesMap));
          options.type = '';
          options.namespaces = [];
        } else {
          options.namespaces = [namespaceValue];
        }
        return await wrapperOptions.client.find(options);
      };
      const getWithNamespace = async (type, id, options = {}) => {
        namespaceValue = this.getNamespaceValue(selectedTenant, isPrivateEnabled, username);
        _lodash.default.assign(options, {
          namespace: [namespaceValue]
        });
        return await wrapperOptions.client.get(type, id, options);
      };
      const updateWithNamespace = async (type, id, attributes, options = {}) => {
        namespaceValue = this.getNamespaceValue(selectedTenant, isPrivateEnabled, username);
        _lodash.default.assign(options, {
          namespace: [namespaceValue]
        });
        return await wrapperOptions.client.update(type, id, attributes, options);
      };
      const bulkCreateWithNamespace = async (objects, options) => {
        namespaceValue = this.getNamespaceValue(selectedTenant, isPrivateEnabled, username);
        _lodash.default.assign(options, {
          namespace: [namespaceValue]
        });
        return await wrapperOptions.client.bulkCreate(objects, options);
      };
      const bulkUpdateWithNamespace = async (objects, options) => {
        namespaceValue = this.getNamespaceValue(selectedTenant, isPrivateEnabled, username);
        _lodash.default.assign(options, {
          namespace: [namespaceValue]
        });
        return await wrapperOptions.client.bulkUpdate(objects, options);
      };
      const deleteWithNamespace = async (type, id, options = {}) => {
        namespaceValue = this.getNamespaceValue(selectedTenant, isPrivateEnabled, username);
        _lodash.default.assign(options, {
          namespace: [namespaceValue]
        });
        return await wrapperOptions.client.delete(type, id, options);
      };
      const checkConflictsWithNamespace = async (objects = [], options = {}) => {
        namespaceValue = this.getNamespaceValue(selectedTenant, isPrivateEnabled, username);
        _lodash.default.assign(options, {
          namespace: [namespaceValue]
        });
        return await wrapperOptions.client.checkConflicts(objects, options);
      };
      return {
        ...wrapperOptions.client,
        get: getWithNamespace,
        update: updateWithNamespace,
        bulkCreate: bulkCreateWithNamespace,
        bulkGet: bulkGetWithNamespace,
        bulkUpdate: bulkUpdateWithNamespace,
        create: createWithNamespace,
        delete: deleteWithNamespace,
        errors: wrapperOptions.client.errors,
        checkConflicts: checkConflictsWithNamespace,
        addToNamespaces: wrapperOptions.client.addToNamespaces,
        find: findWithNamespace,
        deleteFromNamespaces: wrapperOptions.client.deleteFromNamespaces
      };
    });
  }
  isAPrivateTenant(selectedTenant, isPrivateEnabled) {
    return selectedTenant !== undefined && isPrivateEnabled && (0, _common.isPrivateTenant)(selectedTenant);
  }
  getNamespaceValue(selectedTenant, isPrivateEnabled, username) {
    let namespaceValue = selectedTenant;
    if (this.isAPrivateTenant(selectedTenant, isPrivateEnabled)) {
      namespaceValue = selectedTenant + username;
    }
    return namespaceValue;
  }
}
exports.SecuritySavedObjectsClientWrapper = SecuritySavedObjectsClientWrapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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