/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesSuccessItem;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesSuccessSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFastLaunchImagesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeFastLaunchImagesResponse> {
    private static final SdkField<List<DescribeFastLaunchImagesSuccessItem>> FAST_LAUNCH_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FastLaunchImages").getter(DescribeFastLaunchImagesResponse.getter(DescribeFastLaunchImagesResponse::fastLaunchImages)).setter(DescribeFastLaunchImagesResponse.setter(Builder::fastLaunchImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastLaunchImageSet").unmarshallLocationName("fastLaunchImageSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeFastLaunchImagesSuccessItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFastLaunchImagesResponse.getter(DescribeFastLaunchImagesResponse::nextToken)).setter(DescribeFastLaunchImagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAST_LAUNCH_IMAGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFastLaunchImagesResponse.memberNameToFieldInitializer();
    private final List<DescribeFastLaunchImagesSuccessItem> fastLaunchImages;
    private final String nextToken;

    private DescribeFastLaunchImagesResponse(BuilderImpl builder) {
        super(builder);
        this.fastLaunchImages = builder.fastLaunchImages;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFastLaunchImages() {
        return this.fastLaunchImages != null && !(this.fastLaunchImages instanceof SdkAutoConstructList);
    }

    public final List<DescribeFastLaunchImagesSuccessItem> fastLaunchImages() {
        return this.fastLaunchImages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFastLaunchImages() ? this.fastLaunchImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFastLaunchImagesResponse)) {
            return false;
        }
        DescribeFastLaunchImagesResponse other = (DescribeFastLaunchImagesResponse)((Object)obj);
        return this.hasFastLaunchImages() == other.hasFastLaunchImages() && Objects.equals(this.fastLaunchImages(), other.fastLaunchImages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFastLaunchImagesResponse").add("FastLaunchImages", this.hasFastLaunchImages() ? this.fastLaunchImages() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FastLaunchImages": {
                return Optional.ofNullable(clazz.cast(this.fastLaunchImages()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FastLaunchImageSet", FAST_LAUNCH_IMAGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFastLaunchImagesResponse, T> g) {
        return obj -> g.apply((DescribeFastLaunchImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<DescribeFastLaunchImagesSuccessItem> fastLaunchImages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFastLaunchImagesResponse model) {
            super(model);
            this.fastLaunchImages(model.fastLaunchImages);
            this.nextToken(model.nextToken);
        }

        public final List<DescribeFastLaunchImagesSuccessItem.Builder> getFastLaunchImages() {
            List<DescribeFastLaunchImagesSuccessItem.Builder> result = DescribeFastLaunchImagesSuccessSetCopier.copyToBuilder(this.fastLaunchImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFastLaunchImages(Collection<DescribeFastLaunchImagesSuccessItem.BuilderImpl> fastLaunchImages) {
            this.fastLaunchImages = DescribeFastLaunchImagesSuccessSetCopier.copyFromBuilder(fastLaunchImages);
        }

        @Override
        public final Builder fastLaunchImages(Collection<DescribeFastLaunchImagesSuccessItem> fastLaunchImages) {
            this.fastLaunchImages = DescribeFastLaunchImagesSuccessSetCopier.copy(fastLaunchImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastLaunchImages(DescribeFastLaunchImagesSuccessItem ... fastLaunchImages) {
            this.fastLaunchImages(Arrays.asList(fastLaunchImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastLaunchImages(Consumer<DescribeFastLaunchImagesSuccessItem.Builder> ... fastLaunchImages) {
            this.fastLaunchImages(Stream.of(fastLaunchImages).map(c -> (DescribeFastLaunchImagesSuccessItem)((DescribeFastLaunchImagesSuccessItem.Builder)DescribeFastLaunchImagesSuccessItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFastLaunchImagesResponse build() {
            return new DescribeFastLaunchImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFastLaunchImagesResponse> {
        public Builder fastLaunchImages(Collection<DescribeFastLaunchImagesSuccessItem> var1);

        public Builder fastLaunchImages(DescribeFastLaunchImagesSuccessItem ... var1);

        public Builder fastLaunchImages(Consumer<DescribeFastLaunchImagesSuccessItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

