/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkInterfaceType {
    INTERFACE("interface"),
    NAT_GATEWAY("natGateway"),
    EFA("efa"),
    EFA_ONLY("efa-only"),
    TRUNK("trunk"),
    LOAD_BALANCER("load_balancer"),
    NETWORK_LOAD_BALANCER("network_load_balancer"),
    VPC_ENDPOINT("vpc_endpoint"),
    BRANCH("branch"),
    TRANSIT_GATEWAY("transit_gateway"),
    LAMBDA("lambda"),
    QUICKSIGHT("quicksight"),
    GLOBAL_ACCELERATOR_MANAGED("global_accelerator_managed"),
    API_GATEWAY_MANAGED("api_gateway_managed"),
    GATEWAY_LOAD_BALANCER("gateway_load_balancer"),
    GATEWAY_LOAD_BALANCER_ENDPOINT("gateway_load_balancer_endpoint"),
    IOT_RULES_MANAGED("iot_rules_managed"),
    AWS_CODESTAR_CONNECTIONS_MANAGED("aws_codestar_connections_managed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkInterfaceType> VALUE_MAP;
    private final String value;

    private NetworkInterfaceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkInterfaceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkInterfaceType> knownValues() {
        EnumSet<NetworkInterfaceType> knownValues = EnumSet.allOf(NetworkInterfaceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkInterfaceType.class, NetworkInterfaceType::toString);
    }
}

