/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.spi.indexstatemanagement;

import java.time.Instant;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.indexmanagement.spi.indexstatemanagement.metrics.ActionMetrics;
import org.opensearch.indexmanagement.spi.indexstatemanagement.metrics.IndexManagementActionsMetrics;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u0000H\u00a6@\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0014J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014H&J\b\u0010 \u001a\u00020\u0005H&J&\u0010!\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0014J\u0016\u0010$\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\bR\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "", "name", "", "isSafeToDisableOn", "", "(Ljava/lang/String;Z)V", "<set-?>", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "context", "getContext", "()Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "()Z", "getName", "()Ljava/lang/String;", "emitTelemetry", "", "indexManagementActionMetrics", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/metrics/IndexManagementActionsMetrics;", "updatedStepMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "logger", "Lorg/apache/logging/log4j/Logger;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStartingStepMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepMetaData;", "metadata", "getStepStartTime", "Ljava/time/Instant;", "getUpdatedManagedIndexMetadata", "currentMetadata", "isIdempotent", "postExecute", "step", "startingManagedIndexMetaData", "preExecute", "StepStatus", "opensearch-index-management-spi"})
public abstract class Step {
    @NotNull
    private final String name;
    private final boolean isSafeToDisableOn;
    @Nullable
    private StepContext context;

    public Step(@NotNull String name, boolean isSafeToDisableOn) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.isSafeToDisableOn = isSafeToDisableOn;
    }

    public /* synthetic */ Step(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isSafeToDisableOn() {
        return this.isSafeToDisableOn;
    }

    @Nullable
    public final StepContext getContext() {
        return this.context;
    }

    @NotNull
    public final Step preExecute(@NotNull Logger logger, @NotNull StepContext context) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        logger.info("Executing " + this.name + " for " + context.getMetadata().getIndex());
        this.context = context;
        return this;
    }

    @Nullable
    public abstract Object execute(@NotNull Continuation<? super Step> var1);

    @NotNull
    public final Step postExecute(@NotNull Logger logger, @NotNull IndexManagementActionsMetrics indexManagementActionMetrics, @NotNull Step step, @NotNull ManagedIndexMetaData startingManagedIndexMetaData) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)indexManagementActionMetrics, (String)"indexManagementActionMetrics");
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)startingManagedIndexMetaData, (String)"startingManagedIndexMetaData");
        Object object = this.context;
        logger.info("Finished executing " + this.name + " for " + (object != null && (object = ((StepContext)object).getMetadata()) != null ? ((ManagedIndexMetaData)object).getIndex() : null));
        ManagedIndexMetaData updatedStepMetaData = step.getUpdatedManagedIndexMetadata(startingManagedIndexMetaData);
        this.emitTelemetry(indexManagementActionMetrics, updatedStepMetaData, logger);
        this.context = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void emitTelemetry(IndexManagementActionsMetrics indexManagementActionMetrics, ManagedIndexMetaData updatedStepMetaData, Logger logger) {
        Object object;
        String string;
        Object object2 = this.context;
        String string2 = object2 != null && (object2 = ((StepContext)object2).getMetadata()) != null && (object2 = ((ManagedIndexMetaData)object2).getActionMetaData()) != null ? ((ActionMetaData)object2).getName() : (string = null);
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -123308572: {
                    if (!string.equals("force_merge")) break;
                    n = 1;
                    break;
                }
                case -1912450848: {
                    if (!string.equals("allocation")) break;
                    n = 2;
                    break;
                }
                case -1238168080: {
                    if (!string.equals("move_shard")) break;
                    n = 3;
                    break;
                }
                case -903068151: {
                    if (!string.equals("shrink")) break;
                    n = 4;
                    break;
                }
                case 175386904: {
                    if (!string.equals("set_read_only")) break;
                    n = 5;
                    break;
                }
                case -1335458389: {
                    if (!string.equals("delete")) break;
                    n = 6;
                    break;
                }
                case -1724158635: {
                    if (!string.equals("transition")) break;
                    n = 7;
                    break;
                }
                case 595233003: {
                    if (!string.equals("notification")) break;
                    n = 8;
                    break;
                }
                case 564075208: {
                    if (!string.equals("replica_count")) break;
                    n = 9;
                    break;
                }
                case -259311919: {
                    if (!string.equals("rollover")) break;
                    n = 10;
                    break;
                }
                case 295643909: {
                    if (!string.equals("alias_action")) break;
                    n = 11;
                    break;
                }
                case 94756344: {
                    if (!string.equals("close")) break;
                    n = 12;
                    break;
                }
                case -783257618: {
                    if (!string.equals("set_index_priority")) break;
                    n = 13;
                    break;
                }
                case 3417674: {
                    if (!string.equals("open")) break;
                    n = 14;
                    break;
                }
                case 284874180: {
                    if (!string.equals("snapshot")) break;
                    n = 15;
                    break;
                }
            }
            switch (n) {
                case 10: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("rollover");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 1: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("force_merge");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 6: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("delete");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 9: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("replica_count");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 7: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("transition");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 8: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("notification");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 12: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("close");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 13: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("set_index_priority");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 14: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("open");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 3: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("move_shard");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 5: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("set_read_only");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 4: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("shrink");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 15: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("snapshot");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 11: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("alias_action");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
                case 2: {
                    ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics("allocation");
                    if (actionMetrics == null) return;
                    StepContext stepContext = this.context;
                    Intrinsics.checkNotNull((Object)stepContext);
                    actionMetrics.emitMetrics(stepContext, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
                    return;
                }
            }
        }
        logger.info("Action Metrics is not supported for this action [%s]", (object = this.context) != null && (object = ((StepContext)object).getMetadata()) != null && (object = ((ManagedIndexMetaData)object).getActionMetaData()) != null ? ((ActionMetaData)object).getName() : null);
    }

    @NotNull
    public abstract ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData var1);

    public abstract boolean isIdempotent();

    @NotNull
    public final Instant getStepStartTime(@NotNull ManagedIndexMetaData metadata) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        if (metadata.getStepMetaData() == null) {
            Instant instant2 = Instant.now();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
        } else if (!Intrinsics.areEqual((Object)metadata.getStepMetaData().getName(), (Object)this.name)) {
            Instant instant3 = Instant.now();
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"now(...)");
        } else if (metadata.getStepMetaData().getStepStatus() == StepStatus.COMPLETED) {
            Instant instant4 = Instant.now();
            instant = instant4;
            Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"now(...)");
        } else {
            Instant instant5 = Instant.ofEpochMilli(metadata.getStepMetaData().getStartTime());
            instant = instant5;
            Intrinsics.checkNotNullExpressionValue((Object)instant5, (String)"ofEpochMilli(...)");
        }
        return instant;
    }

    @NotNull
    public final StepMetaData getStartingStepMetaData(@NotNull ManagedIndexMetaData metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        return new StepMetaData(this.name, this.getStepStartTime(metadata).toEpochMilli(), StepStatus.STARTING);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "", "Lorg/opensearch/core/common/io/stream/Writeable;", "status", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getStatus", "()Ljava/lang/String;", "toString", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "STARTING", "CONDITION_NOT_MET", "FAILED", "COMPLETED", "TIMED_OUT", "Companion", "opensearch-index-management-spi"})
    public static final class StepStatus
    extends Enum<StepStatus>
    implements Writeable {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String status;
        public static final /* enum */ StepStatus STARTING;
        public static final /* enum */ StepStatus CONDITION_NOT_MET;
        public static final /* enum */ StepStatus FAILED;
        public static final /* enum */ StepStatus COMPLETED;
        public static final /* enum */ StepStatus TIMED_OUT;
        private static final /* synthetic */ StepStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private StepStatus(String status) {
            this.status = status;
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        @NotNull
        public String toString() {
            return this.status;
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.status);
        }

        public static StepStatus[] values() {
            return (StepStatus[])$VALUES.clone();
        }

        public static StepStatus valueOf(String value) {
            return Enum.valueOf(StepStatus.class, value);
        }

        @NotNull
        public static EnumEntries<StepStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            STARTING = new StepStatus("starting");
            CONDITION_NOT_MET = new StepStatus("condition_not_met");
            FAILED = new StepStatus("failed");
            COMPLETED = new StepStatus("completed");
            TIMED_OUT = new StepStatus("timed_out");
            $VALUES = stepStatusArray = new StepStatus[]{StepStatus.STARTING, StepStatus.CONDITION_NOT_MET, StepStatus.FAILED, StepStatus.COMPLETED, StepStatus.TIMED_OUT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus$Companion;", "", "()V", "read", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "streamInput", "Lorg/opensearch/core/common/io/stream/StreamInput;", "opensearch-index-management-spi"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StepStatus read(@NotNull StreamInput streamInput) {
                Intrinsics.checkNotNullParameter((Object)streamInput, (String)"streamInput");
                String string = streamInput.readString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                String string2 = string;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string3 = string2.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                return StepStatus.valueOf(string3);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

