/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.start;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.start.StartRollupRequest;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0014J\u001e\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0002J&\u0010)\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0002J&\u0010*\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010+\u001a\u00020,2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/start/TransportStartRollupAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/rollup/action/start/StartRollupRequest;", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "getRollupMetadata", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "updateRollupJob", "updateRollupMetadata", "metadata", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "opensearch-index-management"})
public final class TransportStartRollupAction
extends HandledTransportAction<StartRollupRequest, AcknowledgedResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportStartRollupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/rollup/start", transportService, actionFilters, StartRollupRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportStartRollupAction._init_$lambda$0(this, arg_0));
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull StartRollupRequest request, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        GetRequest getReq = new GetRequest(".opendistro-ism-config", request.getId());
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"getThreadContext(...)");
        User user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            this.client.get(getReq, (ActionListener)new ActionListener<GetResponse>(actionListener, this, user, request){
                final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
                final /* synthetic */ TransportStartRollupAction this$0;
                final /* synthetic */ User $user;
                final /* synthetic */ StartRollupRequest $request;
                {
                    this.$actionListener = $actionListener;
                    this.this$0 = $receiver;
                    this.$user = $user;
                    this.$request = $request;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        this.$actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    Rollup rollup2 = null;
                    try {
                        rollup2 = RollupUtilsKt.parseRollup(response2, this.this$0.getXContentRegistry());
                    }
                    catch (IllegalArgumentException e) {
                        this.$actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    User user = rollup2.getUser();
                    Boolean bl = TransportStartRollupAction.access$getFilterByEnabled$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"access$getFilterByEnabled$p(...)");
                    if (!SecurityUtils.Companion.userHasPermissionForResource(this.$user, user, bl, "rollup", rollup2.getId(), this.$actionListener)) {
                        return;
                    }
                    if (rollup2.getEnabled()) {
                        TransportStartRollupAction.access$getLog$p(this.this$0).debug("Rollup job is already enabled, checking if metadata needs to be updated");
                        if (rollup2.getMetadataID() == null) {
                            this.$actionListener.onResponse((Object)new AcknowledgedResponse(true));
                        } else {
                            TransportStartRollupAction.access$getRollupMetadata(this.this$0, rollup2, this.$actionListener);
                        }
                        return;
                    }
                    TransportStartRollupAction.access$updateRollupJob(this.this$0, rollup2, this.$request, this.$actionListener);
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    this.$actionListener.onFailure((Exception)throwable);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void updateRollupJob(Rollup rollup2, StartRollupRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        long now = Instant.now().toEpochMilli();
        UpdateRequest updateReq = new UpdateRequest(".opendistro-ism-config", request.getId());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"enabled", (Object)true), TuplesKt.to((Object)"enabled_time", (Object)now), TuplesKt.to((Object)"last_updated_time", (Object)now)};
        updateReq.doc(MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollup", (Object)MapsKt.mapOf((Pair[])pairArray))));
        this.client.update(updateReq, (ActionListener)new ActionListener<UpdateResponse>(rollup2, this, actionListener){
            final /* synthetic */ Rollup $rollup;
            final /* synthetic */ TransportStartRollupAction this$0;
            final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
            {
                this.$rollup = $rollup;
                this.this$0 = $receiver;
                this.$actionListener = $actionListener;
            }

            public void onResponse(@NotNull UpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (response2.getResult() == DocWriteResponse.Result.UPDATED) {
                    if (this.$rollup.getMetadataID() != null) {
                        TransportStartRollupAction.access$getRollupMetadata(this.this$0, this.$rollup, this.$actionListener);
                    } else {
                        this.$actionListener.onResponse((Object)new AcknowledgedResponse(true));
                    }
                } else {
                    this.$actionListener.onResponse((Object)new AcknowledgedResponse(false));
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                this.$actionListener.onFailure((Exception)throwable);
            }
        });
    }

    private final void getRollupMetadata(Rollup rollup2, ActionListener<AcknowledgedResponse> actionListener) {
        GetRequest req = new GetRequest(".opendistro-ism-config", rollup2.getMetadataID()).routing(rollup2.getId());
        this.client.get(req, (ActionListener)new ActionListener<GetResponse>(actionListener, this, rollup2){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
            final /* synthetic */ TransportStartRollupAction this$0;
            final /* synthetic */ Rollup $rollup;
            {
                this.$actionListener = $actionListener;
                this.this$0 = $receiver;
                this.$rollup = $rollup;
            }

            public void onResponse(@NotNull GetResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isExists() || response2.isSourceEmpty()) {
                    this.$actionListener.onResponse((Object)new AcknowledgedResponse(true));
                } else {
                    RollupMetadata metadata2;
                    BytesReference bytesReference = response2.getSourceAsBytesRef();
                    if (bytesReference != null) {
                        BytesReference it = bytesReference;
                        boolean bl = false;
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)it, (MediaType)((MediaType)XContentType.JSON));
                        Intrinsics.checkNotNull((Object)xcp);
                        String string = response2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        v2 = (RollupMetadata)OpenSearchExtensionsKt.parseWithType(xcp, string, response2.getSeqNo(), response2.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, RollupMetadata>((Object)RollupMetadata.Companion){

                            @NotNull
                            public final RollupMetadata invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                return ((RollupMetadata.Companion)this.receiver).parse(p0, p1, p2, p3);
                            }
                        });
                    } else {
                        v2 = metadata2 = null;
                    }
                    if (metadata2 == null) {
                        this.$actionListener.onResponse((Object)new AcknowledgedResponse(true));
                    } else {
                        TransportStartRollupAction.access$updateRollupMetadata(this.this$0, this.$rollup, metadata2, this.$actionListener);
                    }
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                this.$actionListener.onFailure((Exception)throwable);
            }
        });
    }

    private final void updateRollupMetadata(Rollup rollup2, RollupMetadata metadata2, ActionListener<AcknowledgedResponse> actionListener) {
        RollupMetadata.Status status;
        long now = Instant.now().toEpochMilli();
        switch (WhenMappings.$EnumSwitchMapping$0[metadata2.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                status = RollupMetadata.Status.STARTED;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
                return;
            }
            case 6: {
                status = RollupMetadata.Status.RETRY;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        RollupMetadata.Status updatedStatus = status;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"status", (Object)updatedStatus.getType()), TuplesKt.to((Object)"failure_reason", null), TuplesKt.to((Object)"last_updated_time", (Object)now)};
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", rollup2.getMetadataID()).doc(MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollup_metadata", (Object)MapsKt.mapOf((Pair[])pairArray)))).routing(rollup2.getId());
        this.client.update(updateRequest, (ActionListener)new ActionListener<UpdateResponse>(actionListener){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
            {
                this.$actionListener = $actionListener;
            }

            public void onResponse(@NotNull UpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$actionListener.onResponse((Object)new AcknowledgedResponse(response2.getResult() == DocWriteResponse.Result.UPDATED));
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                this.$actionListener.onFailure((Exception)throwable);
            }
        });
    }

    private static final void _init_$lambda$0(TransportStartRollupAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    public static final /* synthetic */ void access$getRollupMetadata(TransportStartRollupAction $this, Rollup rollup2, ActionListener actionListener) {
        $this.getRollupMetadata(rollup2, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    public static final /* synthetic */ void access$updateRollupMetadata(TransportStartRollupAction $this, Rollup rollup2, RollupMetadata metadata2, ActionListener actionListener) {
        $this.updateRollupMetadata(rollup2, metadata2, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    public static final /* synthetic */ Boolean access$getFilterByEnabled$p(TransportStartRollupAction $this) {
        return $this.filterByEnabled;
    }

    public static final /* synthetic */ Logger access$getLog$p(TransportStartRollupAction $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$updateRollupJob(TransportStartRollupAction $this, Rollup rollup2, StartRollupRequest request, ActionListener actionListener) {
        $this.updateRollupJob(rollup2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RollupMetadata.Status.values().length];
            try {
                nArray[RollupMetadata.Status.FINISHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.STOPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.STARTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.INIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.RETRY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.FAILED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

