/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.DisMaxQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.common.model.dimension.Histogram;
import org.opensearch.indexmanagement.common.model.dimension.Terms;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupFieldMapping;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.rollup.model.RollupMetrics;
import org.opensearch.indexmanagement.rollup.model.metric.Average;
import org.opensearch.indexmanagement.rollup.model.metric.Max;
import org.opensearch.indexmanagement.rollup.model.metric.Metric;
import org.opensearch.indexmanagement.rollup.model.metric.Min;
import org.opensearch.indexmanagement.rollup.model.metric.Sum;
import org.opensearch.indexmanagement.rollup.model.metric.ValueCount;
import org.opensearch.indexmanagement.rollup.query.QueryStringQueryUtil;
import org.opensearch.indexmanagement.rollup.settings.LegacyOpenDistroRollupSettings;
import org.opensearch.indexmanagement.rollup.settings.RollupSettings;
import org.opensearch.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ScriptedMetricAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FieldAndFormat;
import org.opensearch.search.rescore.RescorerBuilder;
import org.opensearch.search.sort.SortBuilder;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a6\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\t0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\b\b\u0002\u0010\u0014\u001a\u00020\u0001\u001a\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001d\u0010\u001a\u001a\u00020\u0001\"\u0006\b\u0000\u0010\u001b\u0018\u0001*\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0001H\u0086\b\u001a \u0010\u001c\u001a\u00020\u001d*\u00020\t2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0012\u001a\n\u0010 \u001a\u00020!*\u00020\t\u001a \u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u001f0#*\u00020\t2\u0006\u0010$\u001a\u00020%\u001a\u0012\u0010&\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010'*\u00020(\u001a\u0012\u0010)\u001a\u00020**\u00020\t2\u0006\u0010+\u001a\u00020,\u001a\n\u0010-\u001a\u00020\u0004*\u00020\t\u001a\u0010\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0010*\u00020\t\u001a\u0012\u00100\u001a\u000201*\u00020\t2\u0006\u00102\u001a\u000201\u001a0\u00103\u001a\u00020\u000f*\u00020\t2\u0006\u00104\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00122\b\b\u0002\u00105\u001a\u00020\u0001\u001a4\u00106\u001a\u000207*\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u00105\u001a\u00020\u0001\u001a.\u00106\u001a\u000207*\u0002072\u0006\u00109\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u00105\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"DATE_FIELD_EPOCH_MILLIS_FORMAT", "", "DATE_FIELD_STRICT_DATE_OPTIONAL_TIME_FORMAT", "isRollupIndex", "", "index", "clusterState", "Lorg/opensearch/cluster/ClusterState;", "parseRollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "response", "Lorg/opensearch/action/get/GetResponse;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "buildRollupQuery", "Lorg/opensearch/index/query/QueryBuilder;", "", "fieldNameMappingTypeMap", "", "oldQuery", "targetIndexName", "findMatchingDimension", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "field", "type", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension$Type;", "findMatchingMetricField", "T", "getCompositeAggregationBuilder", "Lorg/opensearch/search/aggregations/bucket/composite/CompositeAggregationBuilder;", "afterKey", "", "getDateHistogram", "Lorg/opensearch/indexmanagement/common/model/dimension/DateHistogram;", "getInitialDocValues", "", "docCount", "", "getRollupJobs", "", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "getRollupSearchRequest", "Lorg/opensearch/action/search/SearchRequest;", "metadata", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "isTargetIndexAlias", "populateFieldMappings", "Lorg/opensearch/indexmanagement/rollup/model/RollupFieldMapping;", "rewriteAggregationBuilder", "Lorg/opensearch/search/aggregations/AggregationBuilder;", "aggregationBuilder", "rewriteQueryBuilder", "queryBuilder", "concreteIndexName", "rewriteSearchSourceBuilder", "Lorg/opensearch/search/builder/SearchSourceBuilder;", "jobs", "job", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupUtils.kt\norg/opensearch/indexmanagement/rollup/util/RollupUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,470:1\n148#1,10:486\n148#1,10:496\n148#1,10:506\n148#1,10:516\n148#1,10:526\n148#1,10:536\n1855#2,2:471\n1855#2:474\n1360#2:475\n1446#2,5:476\n1855#2,2:481\n1856#2:483\n1855#2,2:484\n1855#2,2:546\n1855#2,2:548\n1855#2,2:550\n1855#2,2:552\n1855#2,2:554\n1549#2:556\n1620#2,3:557\n1855#2,2:560\n1855#2:562\n1855#2,2:563\n1856#2:565\n1855#2,2:566\n1855#2,2:568\n1855#2,2:570\n1855#2,2:572\n1855#2,2:574\n1855#2,2:576\n1#3:473\n*S KotlinDebug\n*F\n+ 1 RollupUtils.kt\norg/opensearch/indexmanagement/rollup/util/RollupUtilsKt\n*L\n226#1:486,10\n234#1:496,10\n235#1:506,10\n255#1:516,10\n259#1:526,10\n274#1:536,10\n108#1:471,2\n111#1:474\n113#1:475\n113#1:476,5\n129#1:481,2\n111#1:483\n206#1:484,2\n329#1:546,2\n333#1:548,2\n337#1:550,2\n341#1:552,2\n366#1:554,2\n389#1:556\n389#1:557,3\n396#1:560,2\n399#1:562\n400#1:563,2\n399#1:565\n417#1:566,2\n421#1:568,2\n425#1:570,2\n430#1:572,2\n431#1:574,2\n435#1:576,2\n*E\n"})
public final class RollupUtilsKt {
    @NotNull
    public static final String DATE_FIELD_STRICT_DATE_OPTIONAL_TIME_FORMAT = "strict_date_optional_time";
    @NotNull
    public static final String DATE_FIELD_EPOCH_MILLIS_FORMAT = "epoch_millis";

    public static final boolean isRollupIndex(@NotNull String index2, @NotNull ClusterState clusterState) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
        IndexMetadata idx = clusterState.getMetadata().index(index2);
        if (idx == null) {
            return false;
        }
        Object object = RollupSettings.Companion.getROLLUP_INDEX().get(idx.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            return true;
        }
        Object object2 = LegacyOpenDistroRollupSettings.Companion.getROLLUP_INDEX().get(idx.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        return (Boolean)object2 != false;
    }

    public static final boolean isTargetIndexAlias(@NotNull Rollup $this$isTargetIndexAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$isTargetIndexAlias, (String)"<this>");
        return RollupFieldValueExpressionResolver.INSTANCE.getIndexAliasUtils().isAlias($this$isTargetIndexAlias.getTargetIndex());
    }

    @NotNull
    public static final SearchRequest getRollupSearchRequest(@NotNull Rollup $this$getRollupSearchRequest, @NotNull RollupMetadata metadata2) {
        Intrinsics.checkNotNullParameter((Object)$this$getRollupSearchRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        AbstractQueryBuilder query = metadata2.getContinuous() != null ? (AbstractQueryBuilder)new RangeQueryBuilder(RollupUtilsKt.getDateHistogram($this$getRollupSearchRequest).getSourceField()).from((Object)metadata2.getContinuous().getNextWindowStartTime().toEpochMilli(), true).to((Object)metadata2.getContinuous().getNextWindowEndTime().toEpochMilli(), false).format(DATE_FIELD_EPOCH_MILLIS_FORMAT) : (AbstractQueryBuilder)new MatchAllQueryBuilder();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().trackTotalHits(false).size(0).aggregation((AggregationBuilder)RollupUtilsKt.getCompositeAggregationBuilder($this$getRollupSearchRequest, metadata2.getAfterKey())).query((QueryBuilder)query);
        String[] stringArray = new String[]{$this$getRollupSearchRequest.getSourceIndex()};
        SearchRequest searchRequest = new SearchRequest(stringArray).source(searchSourceBuilder).allowPartialSearchResults(false);
        Intrinsics.checkNotNullExpressionValue((Object)searchRequest, (String)"allowPartialSearchResults(...)");
        return searchRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CompositeAggregationBuilder getCompositeAggregationBuilder(@NotNull Rollup $this$getCompositeAggregationBuilder, @Nullable Map<String, ? extends Object> afterKey) {
        CompositeAggregationBuilder compositeAggregationBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$getCompositeAggregationBuilder, (String)"<this>");
        List sources = new ArrayList();
        Iterable $this$forEach$iv = $this$getCompositeAggregationBuilder.getDimensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dimension dimension = (Dimension)element$iv;
            boolean bl = false;
            sources.add(dimension.toSourceBuilder(true));
        }
        CompositeAggregationBuilder compositeAgg = compositeAggregationBuilder = new CompositeAggregationBuilder($this$getCompositeAggregationBuilder.getId(), sources).size($this$getCompositeAggregationBuilder.getPageSize());
        boolean bl = false;
        Map<String, ? extends Object> map = afterKey;
        if (map != null) {
            Map<String, ? extends Object> it = map;
            boolean bl2 = false;
            compositeAgg.aggregateAfter(it);
        }
        Iterable $this$forEach$iv2 = $this$getCompositeAggregationBuilder.getMetrics();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            void $this$flatMapTo$iv$iv;
            RollupMetrics metric = (RollupMetrics)element$iv;
            boolean bl3 = false;
            Iterable $this$flatMap$iv = metric.getMetrics();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                Metric agg = (Metric)element$iv$iv;
                boolean bl4 = false;
                Metric metric2 = agg;
                if (metric2 instanceof Average) {
                    Object[] objectArray = new ValuesSourceAggregationBuilder.LeafOnly[]{new SumAggregationBuilder(metric.targetFieldWithType(agg) + ".sum").field(metric.getSourceField()), new ValueCountAggregationBuilder(metric.targetFieldWithType(agg) + ".value_count").field(metric.getSourceField())};
                    list = CollectionsKt.listOf((Object[])objectArray);
                } else if (metric2 instanceof Sum) {
                    list = CollectionsKt.listOf((Object)new SumAggregationBuilder(metric.targetFieldWithType(agg)).field(metric.getSourceField()));
                } else if (metric2 instanceof Max) {
                    list = CollectionsKt.listOf((Object)new MaxAggregationBuilder(metric.targetFieldWithType(agg)).field(metric.getSourceField()));
                } else if (metric2 instanceof Min) {
                    list = CollectionsKt.listOf((Object)new MinAggregationBuilder(metric.targetFieldWithType(agg)).field(metric.getSourceField()));
                } else if (metric2 instanceof ValueCount) {
                    list = CollectionsKt.listOf((Object)new ValueCountAggregationBuilder(metric.targetFieldWithType(agg)).field(metric.getSourceField()));
                } else {
                    throw new IllegalArgumentException("Found unsupported metric aggregation " + agg.getType().getType());
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List subAggs = (List)destination$iv$iv;
            Iterable $this$forEach$iv3 = subAggs;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                ValuesSourceAggregationBuilder.LeafOnly it = (ValuesSourceAggregationBuilder.LeafOnly)element$iv2;
                boolean bl5 = false;
                compositeAgg.subAggregation((AggregationBuilder)it);
            }
        }
        CompositeAggregationBuilder compositeAggregationBuilder2 = compositeAggregationBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAggregationBuilder2, (String)"also(...)");
        return compositeAggregationBuilder2;
    }

    @NotNull
    public static final DateHistogram getDateHistogram(@NotNull Rollup $this$getDateHistogram) {
        Intrinsics.checkNotNullParameter((Object)$this$getDateHistogram, (String)"<this>");
        Dimension dimension = (Dimension)CollectionsKt.first($this$getDateHistogram.getDimensions());
        if (!(dimension instanceof DateHistogram)) {
            boolean bl = false;
            String string = "The first dimension in rollup must be a date histogram";
            throw new IllegalArgumentException(string.toString());
        }
        return (DateHistogram)dimension;
    }

    @Nullable
    public static final Dimension findMatchingDimension(@NotNull Rollup $this$findMatchingDimension, @NotNull String field, @NotNull Dimension.Type type) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findMatchingDimension, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Iterable iterable = $this$findMatchingDimension.getDimensions();
            for (Object t : iterable) {
                Dimension dimension = (Dimension)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)dimension.getSourceField(), (Object)field) && dimension.getType() == type)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final /* synthetic */ <T> String findMatchingMetricField(Rollup $this$findMatchingMetricField, String field) {
        Intrinsics.checkNotNullParameter((Object)$this$findMatchingMetricField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        boolean $i$f$findMatchingMetricField = false;
        for (RollupMetrics rollupMetrics : $this$findMatchingMetricField.getMetrics()) {
            if (!Intrinsics.areEqual((Object)rollupMetrics.getSourceField(), (Object)field)) continue;
            for (Metric metric : rollupMetrics.getMetrics()) {
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (!(metric instanceof Object)) continue;
                return rollupMetrics.targetFieldWithType(metric);
            }
        }
        throw new IllegalStateException("Did not find matching rollup metric".toString());
    }

    @Nullable
    public static final List<Rollup> getRollupJobs(@NotNull IndexMetadata $this$getRollupJobs) {
        Intrinsics.checkNotNullParameter((Object)$this$getRollupJobs, (String)"<this>");
        List rollupJobs = new ArrayList();
        MappingMetadata mappingMetadata = $this$getRollupJobs.mapping();
        Object object = mappingMetadata != null ? mappingMetadata.source() : null;
        if (object == null) {
            return null;
        }
        CompressedXContent source = object;
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)source.compressedReference(), (MediaType)((MediaType)XContentType.JSON));
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (Intrinsics.areEqual((Object)fieldName, (Object)"_meta")) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String metaField = xcp.currentName();
                    xcp.nextToken();
                    if (Intrinsics.areEqual((Object)metaField, (Object)"rollups")) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            String rollupID = xcp.currentName();
                            xcp.nextToken();
                            Intrinsics.checkNotNull((Object)xcp);
                            Intrinsics.checkNotNull((Object)rollupID);
                            rollupJobs.add(Rollup.Companion.parse$default(Rollup.Companion, xcp, rollupID, 0L, 0L, 12, null));
                        }
                        continue;
                    }
                    xcp.skipChildren();
                }
                continue;
            }
            xcp.skipChildren();
        }
        return rollupJobs.size() > 0 ? rollupJobs : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final AggregationBuilder rewriteAggregationBuilder(@NotNull Rollup $this$rewriteAggregationBuilder, @NotNull AggregationBuilder aggregationBuilder) {
        AggregationBuilder aggregationBuilder2;
        AggregatorFactories.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$rewriteAggregationBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)aggregationBuilder, (String)"aggregationBuilder");
        AggregatorFactories.Builder factories = builder = AggregatorFactories.builder();
        boolean bl3 = false;
        Collection collection = aggregationBuilder.getSubAggregations();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSubAggregations(...)");
        Object $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            AggregationBuilder it = (AggregationBuilder)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            factories.addAggregator(RollupUtilsKt.rewriteAggregationBuilder($this$rewriteAggregationBuilder, it));
        }
        AggregatorFactories.Builder aggFactory = builder;
        builder = aggregationBuilder;
        if (builder instanceof TermsAggregationBuilder) {
            String string = ((TermsAggregationBuilder)aggregationBuilder).field();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field(...)");
            Dimension dimension = RollupUtilsKt.findMatchingDimension($this$rewriteAggregationBuilder, string, Dimension.Type.TERMS);
            Intrinsics.checkNotNull((Object)dimension, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.common.model.dimension.Terms");
            dim = (Terms)dimension;
            TermsAggregationBuilder termsAggregationBuilder = (TermsAggregationBuilder)aggregationBuilder;
            Intrinsics.checkNotNull((Object)aggFactory);
            aggregationBuilder2 = (AggregationBuilder)((Terms)dim).getRewrittenAggregation(termsAggregationBuilder, aggFactory);
        } else if (builder instanceof DateHistogramAggregationBuilder) {
            String string = ((DateHistogramAggregationBuilder)aggregationBuilder).field();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field(...)");
            Dimension dimension = RollupUtilsKt.findMatchingDimension($this$rewriteAggregationBuilder, string, Dimension.Type.DATE_HISTOGRAM);
            Intrinsics.checkNotNull((Object)dimension, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.common.model.dimension.DateHistogram");
            dim = (DateHistogram)dimension;
            DateHistogramAggregationBuilder dateHistogramAggregationBuilder = (DateHistogramAggregationBuilder)aggregationBuilder;
            Intrinsics.checkNotNull((Object)aggFactory);
            aggregationBuilder2 = (AggregationBuilder)((DateHistogram)dim).getRewrittenAggregation(dateHistogramAggregationBuilder, aggFactory);
        } else if (builder instanceof HistogramAggregationBuilder) {
            String string = ((HistogramAggregationBuilder)aggregationBuilder).field();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field(...)");
            Dimension dimension = RollupUtilsKt.findMatchingDimension($this$rewriteAggregationBuilder, string, Dimension.Type.HISTOGRAM);
            Intrinsics.checkNotNull((Object)dimension, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.common.model.dimension.Histogram");
            dim = (Histogram)dimension;
            HistogramAggregationBuilder histogramAggregationBuilder = (HistogramAggregationBuilder)aggregationBuilder;
            Intrinsics.checkNotNull((Object)aggFactory);
            aggregationBuilder2 = (AggregationBuilder)((Histogram)dim).getRewrittenAggregation(histogramAggregationBuilder, aggFactory);
        } else if (builder instanceof SumAggregationBuilder) {
            Metric metric$iv2;
            SumAggregationBuilder sumAggregationBuilder;
            block29: {
                void $this$findMatchingMetricField$iv;
                SumAggregationBuilder sumAggregationBuilder2 = new SumAggregationBuilder(((SumAggregationBuilder)aggregationBuilder).getName());
                Rollup bl3 = $this$rewriteAggregationBuilder;
                String string = ((SumAggregationBuilder)aggregationBuilder).field();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field(...)");
                $this$forEach$iv = string;
                sumAggregationBuilder = sumAggregationBuilder2;
                $i$f$findMatchingMetricField = false;
                for (RollupMetrics rollupMetrics$iv : $this$findMatchingMetricField$iv.getMetrics()) {
                    if (!Intrinsics.areEqual((Object)rollupMetrics$iv.getSourceField(), (Object)field$iv)) continue;
                    for (Metric metric$iv2 : rollupMetrics$iv.getMetrics()) {
                        if (!(metric$iv2 instanceof Sum)) continue;
                        break block29;
                    }
                }
                throw new IllegalStateException("Did not find matching rollup metric".toString());
            }
            var4_3 = sumAggregationBuilder.field(rollupMetrics$iv.targetFieldWithType(metric$iv2));
            Intrinsics.checkNotNull((Object)var4_3);
            aggregationBuilder2 = (AggregationBuilder)var4_3;
        } else if (builder instanceof AvgAggregationBuilder) {
            String string;
            Metric metric$iv3;
            ScriptedMetricAggregationBuilder scriptedMetricAggregationBuilder;
            ScriptType scriptType;
            String string2;
            block31: {
                Rollup $this$findMatchingMetricField$iv;
                block30: {
                    ScriptedMetricAggregationBuilder scriptedMetricAggregationBuilder2 = new ScriptedMetricAggregationBuilder(((AvgAggregationBuilder)aggregationBuilder).getName()).initScript(new Script(ScriptType.INLINE, "painless", "state.sums = 0D; state.counts = 0L;", MapsKt.emptyMap()));
                    $this$findMatchingMetricField$iv = $this$rewriteAggregationBuilder;
                    String string3 = ((AvgAggregationBuilder)aggregationBuilder).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"field(...)");
                    field$iv = string3;
                    string2 = "painless";
                    scriptType = ScriptType.INLINE;
                    scriptedMetricAggregationBuilder = scriptedMetricAggregationBuilder2;
                    $i$f$findMatchingMetricField = false;
                    for (RollupMetrics rollupMetrics$iv : $this$findMatchingMetricField$iv.getMetrics()) {
                        if (!Intrinsics.areEqual((Object)rollupMetrics$iv.getSourceField(), (Object)field$iv)) continue;
                        for (Metric metric$iv3 : rollupMetrics$iv.getMetrics()) {
                            if (!(metric$iv3 instanceof Average)) continue;
                            break block30;
                        }
                    }
                    throw new IllegalStateException("Did not find matching rollup metric".toString());
                }
                string = rollupMetrics$iv.targetFieldWithType(metric$iv3);
                $this$findMatchingMetricField$iv = $this$rewriteAggregationBuilder;
                String string4 = ((AvgAggregationBuilder)aggregationBuilder).field();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"field(...)");
                field$iv = string4;
                $i$f$findMatchingMetricField = false;
                for (RollupMetrics rollupMetrics$iv : $this$findMatchingMetricField$iv.getMetrics()) {
                    if (!Intrinsics.areEqual((Object)rollupMetrics$iv.getSourceField(), (Object)field$iv)) continue;
                    for (Metric metric$iv3 : rollupMetrics$iv.getMetrics()) {
                        if (!(metric$iv3 instanceof Average)) continue;
                        break block31;
                    }
                }
                throw new IllegalStateException("Did not find matching rollup metric".toString());
            }
            String string5 = rollupMetrics$iv.targetFieldWithType(metric$iv3);
            Map map = MapsKt.emptyMap();
            String string6 = "state.sums += doc[\"" + string + ".sum\"].value; state.counts += doc[\"" + string5 + ".value_count\"].value";
            String string7 = string2;
            ScriptType scriptType2 = scriptType;
            var4_3 = scriptedMetricAggregationBuilder.mapScript(new Script(scriptType2, string7, string6, map)).combineScript(new Script(ScriptType.INLINE, "painless", "def d = new double[2]; d[0] = state.sums; d[1] = state.counts; return d", MapsKt.emptyMap())).reduceScript(new Script(ScriptType.INLINE, "painless", "double sum = 0; double count = 0; for (a in states) { sum += a[0]; count += a[1]; } return sum/count", MapsKt.emptyMap()));
            Intrinsics.checkNotNull((Object)var4_3);
            aggregationBuilder2 = (AggregationBuilder)var4_3;
        } else if (builder instanceof MaxAggregationBuilder) {
            Metric metric$iv4;
            MaxAggregationBuilder maxAggregationBuilder;
            block32: {
                MaxAggregationBuilder maxAggregationBuilder2 = new MaxAggregationBuilder(((MaxAggregationBuilder)aggregationBuilder).getName());
                Rollup $this$findMatchingMetricField$iv = $this$rewriteAggregationBuilder;
                String string = ((MaxAggregationBuilder)aggregationBuilder).field();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field(...)");
                field$iv = string;
                maxAggregationBuilder = maxAggregationBuilder2;
                $i$f$findMatchingMetricField = false;
                for (RollupMetrics rollupMetrics$iv : $this$findMatchingMetricField$iv.getMetrics()) {
                    if (!Intrinsics.areEqual((Object)rollupMetrics$iv.getSourceField(), (Object)field$iv)) continue;
                    for (Metric metric$iv4 : rollupMetrics$iv.getMetrics()) {
                        if (!(metric$iv4 instanceof Max)) continue;
                        break block32;
                    }
                }
                throw new IllegalStateException("Did not find matching rollup metric".toString());
            }
            var4_3 = maxAggregationBuilder.field(rollupMetrics$iv.targetFieldWithType(metric$iv4));
            Intrinsics.checkNotNull((Object)var4_3);
            aggregationBuilder2 = (AggregationBuilder)var4_3;
        } else if (builder instanceof MinAggregationBuilder) {
            Metric metric$iv5;
            MinAggregationBuilder minAggregationBuilder;
            block33: {
                MinAggregationBuilder minAggregationBuilder2 = new MinAggregationBuilder(((MinAggregationBuilder)aggregationBuilder).getName());
                Rollup $this$findMatchingMetricField$iv = $this$rewriteAggregationBuilder;
                String string = ((MinAggregationBuilder)aggregationBuilder).field();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field(...)");
                field$iv = string;
                minAggregationBuilder = minAggregationBuilder2;
                $i$f$findMatchingMetricField = false;
                for (RollupMetrics rollupMetrics$iv : $this$findMatchingMetricField$iv.getMetrics()) {
                    if (!Intrinsics.areEqual((Object)rollupMetrics$iv.getSourceField(), (Object)field$iv)) continue;
                    for (Metric metric$iv5 : rollupMetrics$iv.getMetrics()) {
                        if (!(metric$iv5 instanceof Min)) continue;
                        break block33;
                    }
                }
                throw new IllegalStateException("Did not find matching rollup metric".toString());
            }
            var4_3 = minAggregationBuilder.field(rollupMetrics$iv.targetFieldWithType(metric$iv5));
            Intrinsics.checkNotNull((Object)var4_3);
            aggregationBuilder2 = (AggregationBuilder)var4_3;
        } else if (builder instanceof ValueCountAggregationBuilder) {
            Metric metric$iv6;
            ScriptedMetricAggregationBuilder scriptedMetricAggregationBuilder;
            ScriptType scriptType;
            String string;
            block34: {
                ScriptedMetricAggregationBuilder scriptedMetricAggregationBuilder3 = new ScriptedMetricAggregationBuilder(((ValueCountAggregationBuilder)aggregationBuilder).getName()).initScript(new Script(ScriptType.INLINE, "painless", "state.valueCounts = []", MapsKt.emptyMap()));
                Rollup $this$findMatchingMetricField$iv = $this$rewriteAggregationBuilder;
                String string8 = ((ValueCountAggregationBuilder)aggregationBuilder).field();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"field(...)");
                field$iv = string8;
                string = "painless";
                scriptType = ScriptType.INLINE;
                scriptedMetricAggregationBuilder = scriptedMetricAggregationBuilder3;
                $i$f$findMatchingMetricField = false;
                for (RollupMetrics rollupMetrics$iv : $this$findMatchingMetricField$iv.getMetrics()) {
                    if (!Intrinsics.areEqual((Object)rollupMetrics$iv.getSourceField(), (Object)field$iv)) continue;
                    for (Metric metric$iv6 : rollupMetrics$iv.getMetrics()) {
                        if (!(metric$iv6 instanceof ValueCount)) continue;
                        break block34;
                    }
                }
                throw new IllegalStateException("Did not find matching rollup metric".toString());
            }
            String string9 = rollupMetrics$iv.targetFieldWithType(metric$iv6);
            Map map = MapsKt.emptyMap();
            String string10 = "state.valueCounts.add(doc[\"" + string9 + "\"].value)";
            String string11 = string;
            ScriptType scriptType3 = scriptType;
            var4_3 = scriptedMetricAggregationBuilder.mapScript(new Script(scriptType3, string11, string10, map)).combineScript(new Script(ScriptType.INLINE, "painless", "long valueCount = 0; for (vc in state.valueCounts) { valueCount += vc } return valueCount", MapsKt.emptyMap())).reduceScript(new Script(ScriptType.INLINE, "painless", "long valueCount = 0; for (vc in states) { valueCount += vc } return valueCount", MapsKt.emptyMap()));
            Intrinsics.checkNotNull((Object)var4_3);
            aggregationBuilder2 = (AggregationBuilder)var4_3;
        } else {
            aggregationBuilder2 = aggregationBuilder;
        }
        return aggregationBuilder2;
    }

    @NotNull
    public static final QueryBuilder rewriteQueryBuilder(@NotNull Rollup $this$rewriteQueryBuilder, @NotNull QueryBuilder queryBuilder, @NotNull Map<String, String> fieldNameMappingTypeMap, @NotNull String concreteIndexName) {
        QueryBuilder queryBuilder2;
        Intrinsics.checkNotNullParameter((Object)$this$rewriteQueryBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter(fieldNameMappingTypeMap, (String)"fieldNameMappingTypeMap");
        Intrinsics.checkNotNullParameter((Object)concreteIndexName, (String)"concreteIndexName");
        QueryBuilder queryBuilder3 = queryBuilder;
        if (queryBuilder3 instanceof TermQueryBuilder) {
            String updatedFieldName = ((TermQueryBuilder)queryBuilder).fieldName() + "." + Dimension.Type.TERMS.getType();
            TermQueryBuilder updatedTermQueryBuilder = new TermQueryBuilder(updatedFieldName, ((TermQueryBuilder)queryBuilder).value());
            updatedTermQueryBuilder.boost(queryBuilder.boost());
            AbstractQueryBuilder abstractQueryBuilder = updatedTermQueryBuilder.queryName(queryBuilder.queryName());
            Intrinsics.checkNotNull((Object)abstractQueryBuilder);
            queryBuilder2 = (QueryBuilder)abstractQueryBuilder;
        } else if (queryBuilder3 instanceof TermsQueryBuilder) {
            String updatedFieldName = ((TermsQueryBuilder)queryBuilder).fieldName() + "." + Dimension.Type.TERMS.getType();
            TermsQueryBuilder updatedTermsQueryBuilder = new TermsQueryBuilder(updatedFieldName, (Iterable)((TermsQueryBuilder)queryBuilder).values());
            updatedTermsQueryBuilder.boost(queryBuilder.boost());
            AbstractQueryBuilder abstractQueryBuilder = updatedTermsQueryBuilder.queryName(queryBuilder.queryName());
            Intrinsics.checkNotNull((Object)abstractQueryBuilder);
            queryBuilder2 = (QueryBuilder)abstractQueryBuilder;
        } else if (queryBuilder3 instanceof RangeQueryBuilder) {
            String string = ((RangeQueryBuilder)queryBuilder).fieldName();
            String string2 = ((RangeQueryBuilder)queryBuilder).fieldName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fieldName(...)");
            String updatedFieldName = string + "." + MapsKt.getValue(fieldNameMappingTypeMap, (Object)string2);
            RangeQueryBuilder updatedRangeQueryBuilder = new RangeQueryBuilder(updatedFieldName);
            updatedRangeQueryBuilder.includeLower(((RangeQueryBuilder)queryBuilder).includeLower());
            updatedRangeQueryBuilder.includeUpper(((RangeQueryBuilder)queryBuilder).includeUpper());
            updatedRangeQueryBuilder.from(((RangeQueryBuilder)queryBuilder).from());
            updatedRangeQueryBuilder.to(((RangeQueryBuilder)queryBuilder).to());
            if (((RangeQueryBuilder)queryBuilder).timeZone() != null) {
                updatedRangeQueryBuilder.timeZone(((RangeQueryBuilder)queryBuilder).timeZone());
            }
            if (((RangeQueryBuilder)queryBuilder).format() != null) {
                updatedRangeQueryBuilder.format(((RangeQueryBuilder)queryBuilder).format());
            }
            ShapeRelation shapeRelation = ((RangeQueryBuilder)queryBuilder).relation();
            if ((shapeRelation != null ? shapeRelation.getRelationName() : null) != null) {
                updatedRangeQueryBuilder.relation(((RangeQueryBuilder)queryBuilder).relation().getRelationName());
            }
            updatedRangeQueryBuilder.queryName(queryBuilder.queryName());
            AbstractQueryBuilder abstractQueryBuilder = updatedRangeQueryBuilder.boost(queryBuilder.boost());
            Intrinsics.checkNotNull((Object)abstractQueryBuilder);
            queryBuilder2 = (QueryBuilder)abstractQueryBuilder;
        } else if (queryBuilder3 instanceof BoolQueryBuilder) {
            QueryBuilder it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            BoolQueryBuilder newBoolQueryBuilder = new BoolQueryBuilder();
            List list = ((BoolQueryBuilder)queryBuilder).must();
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (QueryBuilder)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    QueryBuilder newMustQueryBuilder = RollupUtilsKt.rewriteQueryBuilder($this$rewriteQueryBuilder, it, fieldNameMappingTypeMap, concreteIndexName);
                    newBoolQueryBuilder.must(newMustQueryBuilder);
                }
            }
            List list2 = ((BoolQueryBuilder)queryBuilder).mustNot();
            if (list2 != null) {
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (QueryBuilder)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    QueryBuilder newMustNotQueryBuilder = RollupUtilsKt.rewriteQueryBuilder($this$rewriteQueryBuilder, it, fieldNameMappingTypeMap, concreteIndexName);
                    newBoolQueryBuilder.mustNot(newMustNotQueryBuilder);
                }
            }
            List list3 = ((BoolQueryBuilder)queryBuilder).should();
            if (list3 != null) {
                $this$forEach$iv = list3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (QueryBuilder)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    QueryBuilder newShouldQueryBuilder = RollupUtilsKt.rewriteQueryBuilder($this$rewriteQueryBuilder, it, fieldNameMappingTypeMap, concreteIndexName);
                    newBoolQueryBuilder.should(newShouldQueryBuilder);
                }
            }
            List list4 = ((BoolQueryBuilder)queryBuilder).filter();
            if (list4 != null) {
                $this$forEach$iv = list4;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (QueryBuilder)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    QueryBuilder newFilterQueryBuilder = RollupUtilsKt.rewriteQueryBuilder($this$rewriteQueryBuilder, it, fieldNameMappingTypeMap, concreteIndexName);
                    newBoolQueryBuilder.filter(newFilterQueryBuilder);
                }
            }
            newBoolQueryBuilder.minimumShouldMatch(((BoolQueryBuilder)queryBuilder).minimumShouldMatch());
            newBoolQueryBuilder.adjustPureNegative(((BoolQueryBuilder)queryBuilder).adjustPureNegative());
            newBoolQueryBuilder.queryName(queryBuilder.queryName());
            AbstractQueryBuilder abstractQueryBuilder = newBoolQueryBuilder.boost(queryBuilder.boost());
            Intrinsics.checkNotNull((Object)abstractQueryBuilder);
            queryBuilder2 = (QueryBuilder)abstractQueryBuilder;
        } else if (queryBuilder3 instanceof BoostingQueryBuilder) {
            QueryBuilder queryBuilder4 = ((BoostingQueryBuilder)queryBuilder).positiveQuery();
            Intrinsics.checkNotNullExpressionValue((Object)queryBuilder4, (String)"positiveQuery(...)");
            QueryBuilder newPositiveQueryBuilder = RollupUtilsKt.rewriteQueryBuilder($this$rewriteQueryBuilder, queryBuilder4, fieldNameMappingTypeMap, concreteIndexName);
            QueryBuilder queryBuilder5 = ((BoostingQueryBuilder)queryBuilder).negativeQuery();
            Intrinsics.checkNotNullExpressionValue((Object)queryBuilder5, (String)"negativeQuery(...)");
            QueryBuilder newNegativeQueryBuilder = RollupUtilsKt.rewriteQueryBuilder($this$rewriteQueryBuilder, queryBuilder5, fieldNameMappingTypeMap, concreteIndexName);
            BoostingQueryBuilder newBoostingQueryBuilder = new BoostingQueryBuilder(newPositiveQueryBuilder, newNegativeQueryBuilder);
            if (((BoostingQueryBuilder)queryBuilder).negativeBoost() >= 0.0f) {
                newBoostingQueryBuilder.negativeBoost(((BoostingQueryBuilder)queryBuilder).negativeBoost());
            }
            newBoostingQueryBuilder.queryName(queryBuilder.queryName());
            AbstractQueryBuilder abstractQueryBuilder = newBoostingQueryBuilder.boost(queryBuilder.boost());
            Intrinsics.checkNotNull((Object)abstractQueryBuilder);
            queryBuilder2 = (QueryBuilder)abstractQueryBuilder;
        } else if (queryBuilder3 instanceof ConstantScoreQueryBuilder) {
            QueryBuilder queryBuilder6 = ((ConstantScoreQueryBuilder)queryBuilder).innerQuery();
            Intrinsics.checkNotNullExpressionValue((Object)queryBuilder6, (String)"innerQuery(...)");
            QueryBuilder newInnerQueryBuilder = RollupUtilsKt.rewriteQueryBuilder($this$rewriteQueryBuilder, queryBuilder6, fieldNameMappingTypeMap, concreteIndexName);
            ConstantScoreQueryBuilder newConstantScoreQueryBuilder = new ConstantScoreQueryBuilder(newInnerQueryBuilder);
            newConstantScoreQueryBuilder.boost(queryBuilder.boost());
            AbstractQueryBuilder abstractQueryBuilder = newConstantScoreQueryBuilder.queryName(queryBuilder.queryName());
            Intrinsics.checkNotNull((Object)abstractQueryBuilder);
            queryBuilder2 = (QueryBuilder)abstractQueryBuilder;
        } else if (queryBuilder3 instanceof DisMaxQueryBuilder) {
            DisMaxQueryBuilder newDisMaxQueryBuilder = new DisMaxQueryBuilder();
            List list = ((DisMaxQueryBuilder)queryBuilder).innerQueries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"innerQueries(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                QueryBuilder it = (QueryBuilder)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                newDisMaxQueryBuilder.add(RollupUtilsKt.rewriteQueryBuilder($this$rewriteQueryBuilder, it, fieldNameMappingTypeMap, concreteIndexName));
            }
            newDisMaxQueryBuilder.tieBreaker(((DisMaxQueryBuilder)queryBuilder).tieBreaker());
            newDisMaxQueryBuilder.queryName(queryBuilder.queryName());
            AbstractQueryBuilder abstractQueryBuilder = newDisMaxQueryBuilder.boost(queryBuilder.boost());
            Intrinsics.checkNotNull((Object)abstractQueryBuilder);
            queryBuilder2 = (QueryBuilder)abstractQueryBuilder;
        } else if (queryBuilder3 instanceof MatchPhraseQueryBuilder) {
            String newFieldName = ((MatchPhraseQueryBuilder)queryBuilder).fieldName() + "." + Dimension.Type.TERMS.getType();
            MatchPhraseQueryBuilder newMatchPhraseQueryBuilder = new MatchPhraseQueryBuilder(newFieldName, ((MatchPhraseQueryBuilder)queryBuilder).value());
            newMatchPhraseQueryBuilder.queryName(queryBuilder.queryName());
            AbstractQueryBuilder abstractQueryBuilder = newMatchPhraseQueryBuilder.boost(queryBuilder.boost());
            Intrinsics.checkNotNull((Object)abstractQueryBuilder);
            queryBuilder2 = (QueryBuilder)abstractQueryBuilder;
        } else {
            queryBuilder2 = queryBuilder3 instanceof QueryStringQueryBuilder ? (QueryBuilder)QueryStringQueryUtil.INSTANCE.rewriteQueryStringQuery(queryBuilder, concreteIndexName) : queryBuilder;
        }
        return queryBuilder2;
    }

    public static /* synthetic */ QueryBuilder rewriteQueryBuilder$default(Rollup rollup2, QueryBuilder queryBuilder, Map map, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return RollupUtilsKt.rewriteQueryBuilder(rollup2, queryBuilder, map, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final QueryBuilder buildRollupQuery(@NotNull Set<Rollup> $this$buildRollupQuery, @NotNull Map<String, String> fieldNameMappingTypeMap, @NotNull QueryBuilder oldQuery, @NotNull String targetIndexName) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$buildRollupQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter(fieldNameMappingTypeMap, (String)"fieldNameMappingTypeMap");
        Intrinsics.checkNotNullParameter((Object)oldQuery, (String)"oldQuery");
        Intrinsics.checkNotNullParameter((Object)targetIndexName, (String)"targetIndexName");
        BoolQueryBuilder wrappedQueryBuilder = new BoolQueryBuilder();
        wrappedQueryBuilder.must(RollupUtilsKt.rewriteQueryBuilder((Rollup)CollectionsKt.first((Iterable)$this$buildRollupQuery), oldQuery, fieldNameMappingTypeMap, targetIndexName));
        Iterable iterable = $this$buildRollupQuery;
        String string = "rollup._id";
        BoolQueryBuilder boolQueryBuilder = wrappedQueryBuilder;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Rollup rollup2 = (Rollup)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        collection = (List)destination$iv$iv;
        Iterable iterable2 = collection;
        String string2 = string;
        boolQueryBuilder.should((QueryBuilder)new TermsQueryBuilder(string2, iterable2));
        wrappedQueryBuilder.minimumShouldMatch(1);
        return (QueryBuilder)wrappedQueryBuilder;
    }

    public static /* synthetic */ QueryBuilder buildRollupQuery$default(Set set, Map map, QueryBuilder queryBuilder, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return RollupUtilsKt.buildRollupQuery(set, map, queryBuilder, string);
    }

    @NotNull
    public static final Set<RollupFieldMapping> populateFieldMappings(@NotNull Rollup $this$populateFieldMappings) {
        Intrinsics.checkNotNullParameter((Object)$this$populateFieldMappings, (String)"<this>");
        Set fieldMappings = new LinkedHashSet();
        Iterable $this$forEach$iv = $this$populateFieldMappings.getDimensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dimension it = (Dimension)element$iv;
            boolean bl = false;
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, it.getSourceField(), it.getType().getType(), null, 8, null));
        }
        $this$forEach$iv = $this$populateFieldMappings.getMetrics();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RollupMetrics rollupMetric = (RollupMetrics)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = rollupMetric.getMetrics();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Metric metric = (Metric)element$iv2;
                boolean bl2 = false;
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, rollupMetric.getSourceField(), metric.getType().getType(), null, 8, null));
            }
        }
        return fieldMappings;
    }

    @NotNull
    public static final SearchSourceBuilder rewriteSearchSourceBuilder(@NotNull SearchSourceBuilder $this$rewriteSearchSourceBuilder, @NotNull Set<Rollup> jobs, @NotNull Map<String, String> fieldNameMappingTypeMap, @NotNull String concreteIndexName) {
        FieldAndFormat it;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$this$rewriteSearchSourceBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter(jobs, (String)"jobs");
        Intrinsics.checkNotNullParameter(fieldNameMappingTypeMap, (String)"fieldNameMappingTypeMap");
        Intrinsics.checkNotNullParameter((Object)concreteIndexName, (String)"concreteIndexName");
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        Object object = $this$rewriteSearchSourceBuilder.aggregations();
        if (object != null && (object = object.getAggregatorFactories()) != null) {
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                AggregationBuilder it2 = (AggregationBuilder)element$iv;
                boolean bl = false;
                Rollup rollup2 = (Rollup)CollectionsKt.first((Iterable)jobs);
                Intrinsics.checkNotNull((Object)it2);
                ssb.aggregation(RollupUtilsKt.rewriteAggregationBuilder(rollup2, it2));
            }
        }
        if ($this$rewriteSearchSourceBuilder.explain() != null) {
            ssb.explain($this$rewriteSearchSourceBuilder.explain());
        }
        if ($this$rewriteSearchSourceBuilder.ext() != null) {
            ssb.ext($this$rewriteSearchSourceBuilder.ext());
        }
        ssb.fetchSource($this$rewriteSearchSourceBuilder.fetchSource());
        List list = $this$rewriteSearchSourceBuilder.docValueFields();
        if (list != null) {
            $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FieldAndFormat)element$iv;
                boolean bl = false;
                ssb.docValueField(it.field, it.format);
            }
        }
        ssb.storedFields($this$rewriteSearchSourceBuilder.storedFields());
        if ($this$rewriteSearchSourceBuilder.from() >= 0) {
            ssb.from($this$rewriteSearchSourceBuilder.from());
        }
        ssb.highlighter($this$rewriteSearchSourceBuilder.highlighter());
        List list2 = $this$rewriteSearchSourceBuilder.indexBoosts();
        if (list2 != null) {
            $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SearchSourceBuilder.IndexBoost)element$iv;
                boolean bl = false;
                ssb.indexBoost(it.getIndex(), it.getBoost());
            }
        }
        if ($this$rewriteSearchSourceBuilder.minScore() != null) {
            Float f = $this$rewriteSearchSourceBuilder.minScore();
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"minScore(...)");
            ssb.minScore(((Number)f).floatValue());
        }
        if ($this$rewriteSearchSourceBuilder.postFilter() != null) {
            ssb.postFilter($this$rewriteSearchSourceBuilder.postFilter());
        }
        ssb.profile($this$rewriteSearchSourceBuilder.profile());
        if ($this$rewriteSearchSourceBuilder.query() != null) {
            QueryBuilder queryBuilder = $this$rewriteSearchSourceBuilder.query();
            Intrinsics.checkNotNullExpressionValue((Object)queryBuilder, (String)"query(...)");
            ssb.query(RollupUtilsKt.buildRollupQuery(jobs, fieldNameMappingTypeMap, queryBuilder, concreteIndexName));
        }
        List list3 = $this$rewriteSearchSourceBuilder.rescores();
        if (list3 != null) {
            $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (RescorerBuilder)element$iv;
                boolean bl = false;
                ssb.addRescorer((RescorerBuilder)it);
            }
        }
        List list4 = $this$rewriteSearchSourceBuilder.scriptFields();
        if (list4 != null) {
            $this$forEach$iv = list4;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SearchSourceBuilder.ScriptField)element$iv;
                boolean bl = false;
                ssb.scriptField(it.fieldName(), it.script(), it.ignoreFailure());
            }
        }
        if ($this$rewriteSearchSourceBuilder.searchAfter() != null) {
            ssb.searchAfter($this$rewriteSearchSourceBuilder.searchAfter());
        }
        if ($this$rewriteSearchSourceBuilder.slice() != null) {
            ssb.slice($this$rewriteSearchSourceBuilder.slice());
        }
        if ($this$rewriteSearchSourceBuilder.size() >= 0) {
            ssb.size($this$rewriteSearchSourceBuilder.size());
        }
        List list5 = $this$rewriteSearchSourceBuilder.sorts();
        if (list5 != null) {
            $this$forEach$iv = list5;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SortBuilder)element$iv;
                boolean bl = false;
                ssb.sort((SortBuilder)it);
            }
        }
        if ($this$rewriteSearchSourceBuilder.stats() != null) {
            ssb.stats($this$rewriteSearchSourceBuilder.stats());
        }
        if ($this$rewriteSearchSourceBuilder.suggest() != null) {
            ssb.suggest($this$rewriteSearchSourceBuilder.suggest());
        }
        if ($this$rewriteSearchSourceBuilder.terminateAfter() >= 0) {
            ssb.terminateAfter($this$rewriteSearchSourceBuilder.terminateAfter());
        }
        if ($this$rewriteSearchSourceBuilder.timeout() != null) {
            ssb.timeout($this$rewriteSearchSourceBuilder.timeout());
        }
        ssb.trackScores($this$rewriteSearchSourceBuilder.trackScores());
        Integer n = $this$rewriteSearchSourceBuilder.trackTotalHitsUpTo();
        if (n != null) {
            Integer it3 = n;
            boolean bl = false;
            ssb.trackTotalHitsUpTo(it3.intValue());
        }
        if ($this$rewriteSearchSourceBuilder.version() != null) {
            ssb.version($this$rewriteSearchSourceBuilder.version());
        }
        if ($this$rewriteSearchSourceBuilder.seqNoAndPrimaryTerm() != null) {
            ssb.seqNoAndPrimaryTerm($this$rewriteSearchSourceBuilder.seqNoAndPrimaryTerm());
        }
        if ($this$rewriteSearchSourceBuilder.collapse() != null) {
            ssb.collapse($this$rewriteSearchSourceBuilder.collapse());
        }
        return ssb;
    }

    @NotNull
    public static final SearchSourceBuilder rewriteSearchSourceBuilder(@NotNull SearchSourceBuilder $this$rewriteSearchSourceBuilder, @NotNull Rollup job, @NotNull Map<String, String> fieldNameMappingTypeMap, @NotNull String concreteIndexName) {
        Intrinsics.checkNotNullParameter((Object)$this$rewriteSearchSourceBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter(fieldNameMappingTypeMap, (String)"fieldNameMappingTypeMap");
        Intrinsics.checkNotNullParameter((Object)concreteIndexName, (String)"concreteIndexName");
        return RollupUtilsKt.rewriteSearchSourceBuilder($this$rewriteSearchSourceBuilder, SetsKt.setOf((Object)job), fieldNameMappingTypeMap, concreteIndexName);
    }

    @NotNull
    public static final Map<String, Object> getInitialDocValues(@NotNull Rollup $this$getInitialDocValues, long docCount) {
        Intrinsics.checkNotNullParameter((Object)$this$getInitialDocValues, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"rollup._id", (Object)$this$getInitialDocValues.getId()), TuplesKt.to((Object)"_doc_count", (Object)docCount), TuplesKt.to((Object)"rollup._schema_version", (Object)$this$getInitialDocValues.getSchemaVersion())};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @NotNull
    public static final Rollup parseRollup(@NotNull GetResponse response2, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
        Intrinsics.checkNotNull((Object)xcp);
        String string = response2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return (Rollup)OpenSearchExtensionsKt.parseWithType(xcp, string, response2.getSeqNo(), response2.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, Rollup>((Object)Rollup.Companion){

            @NotNull
            public final Rollup invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Rollup.Companion)this.receiver).parse(p0, p1, p2, p3);
            }
        });
    }

    public static /* synthetic */ Rollup parseRollup$default(GetResponse getResponse2, NamedXContentRegistry namedXContentRegistry, int n, Object object) {
        if ((n & 2) != 0) {
            NamedXContentRegistry namedXContentRegistry2 = NamedXContentRegistry.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)namedXContentRegistry2, (String)"EMPTY");
            namedXContentRegistry = namedXContentRegistry2;
        }
        return RollupUtilsKt.parseRollup(getResponse2, namedXContentRegistry);
    }
}

