/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.action.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.indexmanagement.transform.model.Transform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/indexmanagement/transform/action/index/IndexTransformRequest;", "Lorg/opensearch/action/index/IndexRequest;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "refreshPolicy", "Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;)V", "getTransform", "()Lorg/opensearch/indexmanagement/transform/model/Transform;", "setTransform", "(Lorg/opensearch/indexmanagement/transform/model/Transform;)V", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "opensearch-index-management"})
public final class IndexTransformRequest
extends IndexRequest {
    @NotNull
    private Transform transform;

    @NotNull
    public final Transform getTransform() {
        return this.transform;
    }

    public final void setTransform(@NotNull Transform transform2) {
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"<set-?>");
        this.transform = transform2;
    }

    public IndexTransformRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        super(sin);
        this.transform = new Transform(sin);
        super.setRefreshPolicy(WriteRequest.RefreshPolicy.readFrom((StreamInput)sin));
    }

    public IndexTransformRequest(@NotNull Transform transform2, @NotNull WriteRequest.RefreshPolicy refreshPolicy) {
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        this.transform = transform2;
        if (transform2.getSeqNo() == -2L || transform2.getPrimaryTerm() == 0L) {
            this.opType(DocWriteRequest.OpType.CREATE);
        } else {
            this.setIfSeqNo(transform2.getSeqNo()).setIfPrimaryTerm(transform2.getPrimaryTerm());
        }
        super.setRefreshPolicy(refreshPolicy);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (StringsKt.isBlank((CharSequence)this.transform.getId())) {
            validationException = ValidateActions.addValidationError((String)"transformID is missing", validationException);
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        this.transform.writeTo(out);
        this.getRefreshPolicy().writeTo(out);
    }
}

