/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.util;

import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.time.DateFormatter;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"DATE_FORMAT", "", "DEFAULT_DATE_FORMAT", "dateFormatter", "Lorg/opensearch/common/time/DateFormatter;", "kotlin.jvm.PlatformType", "timezone", "Ljava/time/ZoneId;", "formatMillis", "dateTimeInMillis", "", "opensearch-index-management"})
public final class TransformUtilsKt {
    @NotNull
    public static final String DEFAULT_DATE_FORMAT = "strict_date_optional_time||epoch_millis";
    @NotNull
    private static final String DATE_FORMAT = "uuuu-MM-dd'T'HH:mm:ss.SSSZZ";
    @NotNull
    private static final ZoneId timezone;
    private static final DateFormatter dateFormatter;

    @NotNull
    public static final String formatMillis(long dateTimeInMillis) {
        String string = dateFormatter.formatMillis(dateTimeInMillis);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatMillis(...)");
        return string;
    }

    static {
        ZoneId zoneId = ZoneId.of("UTC");
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(...)");
        timezone = zoneId;
        dateFormatter = DateFormatter.forPattern((String)DATE_FORMAT).withZone(timezone);
    }
}

