/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.engine.states.creation;

import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.GetSnapshotsResult;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.SMResult;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.State;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.creation.CreatingState;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMMetadata;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.snapshots.ConcurrentSnapshotExecutionException;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.ClusterAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J,\u0010\u0018\u001a\u00020\u00112\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/creation/CreatingState;", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/State;", "()V", "CONCURRENT_SNAPSHOT_MESSAGE", "", "SNAPSHOT_ERROR_MESSAGE", "continuous", "", "getContinuous", "()Z", "checkCreatedSnapshots", "lastExecutionTime", "Ljava/time/Instant;", "snapshots", "", "Lorg/opensearch/snapshots/SnapshotInfo;", "execute", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMResult;", "context", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/SMStateMachine;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/engine/SMStateMachine;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCreateSnapshotErrorMessage", "snapshotName", "getSnapshotCreationStartedMessage", "handleException", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "metadataBuilder", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Builder;", "log", "Lorg/apache/logging/log4j/Logger;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nCreatingState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreatingState.kt\norg/opensearch/indexmanagement/snapshotmanagement/engine/states/creation/CreatingState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1045#2:138\n*S KotlinDebug\n*F\n+ 1 CreatingState.kt\norg/opensearch/indexmanagement/snapshotmanagement/engine/states/creation/CreatingState\n*L\n126#1:138\n*E\n"})
public final class CreatingState
implements State {
    @NotNull
    public static final CreatingState INSTANCE = new CreatingState();
    private static final boolean continuous;
    @NotNull
    public static final String CONCURRENT_SNAPSHOT_MESSAGE = "Concurrent snapshot exception happened, retrying...";
    @NotNull
    private static final String SNAPSHOT_ERROR_MESSAGE = "Caught exception while getting snapshots to decide if snapshot has been created in previous execution period.";

    private CreatingState() {
    }

    @Override
    public boolean getContinuous() {
        return continuous;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull SMStateMachine var1_1, @NotNull Continuation<? super SMResult> var2_2) {
        if (!(var2_2 instanceof execute.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ CreatingState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((SMStateMachine)null, (Continuation<? super SMResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                client = context.getClient();
                job = context.getJob();
                metadata = context.getMetadata();
                log = context.getLog();
                metadataBuilder = new SMMetadata.Builder(metadata).workflow(WorkflowType.CREATION);
                v0 = metadata.getCreation().getStarted();
                v1 = snapshotName = v0 != null ? (String)CollectionsKt.first(v0) : null;
                if (snapshotName != null) ** GOTO lbl49
                $continuation.L$0 = this;
                $continuation.L$1 = client;
                $continuation.L$2 = job;
                $continuation.L$3 = log;
                $continuation.label = 1;
                v2 = SMUtilsKt.getSnapshots(client, job, job.getPolicyName() + "*", metadataBuilder, log, null, "Caught exception while getting snapshots to decide if snapshot has been created in previous execution period.", (Continuation<? super GetSnapshotsResult>)$continuation);
                if (v2 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl36
            }
            case 1: {
                log = (Logger)$continuation.L$3;
                job = (SMPolicy)$continuation.L$2;
                client = (Client)$continuation.L$1;
                this = (CreatingState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl36:
                // 2 sources

                getSnapshotsResult = (GetSnapshotsResult)v2;
                metadataBuilder = getSnapshotsResult.getMetadataBuilder();
                if (getSnapshotsResult.getFailed()) {
                    return new SMResult.Fail(metadataBuilder, WorkflowType.CREATION, null, 4, null);
                }
                getSnapshots = getSnapshotsResult.getSnapshots();
                latestExecutionStartTime = (Instant)job.getCreation().getSchedule().getPeriodStartingAt(null).v1();
                Intrinsics.checkNotNull((Object)latestExecutionStartTime);
                snapshotName = this.checkCreatedSnapshots(latestExecutionStartTime, (List<SnapshotInfo>)getSnapshots);
                if (snapshotName != null) {
                    log.info("Already created snapshot [" + snapshotName + "] during this execution period starting at " + latestExecutionStartTime + ".");
                    SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.IN_PROGRESS, false, null, false, null, null, 62, null).setCreationStarted(snapshotName);
                    return new SMResult.Next(metadataBuilder);
                }
lbl49:
                // 3 sources

                snapshotName = SMUtilsKt.generateSnapshotName(job);
                v3 = job.getSnapshotConfig().get("repository");
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.String");
                req = new CreateSnapshotRequest((String)v3, snapshotName).source(SMUtilsKt.addSMPolicyInSnapshotMetadata(job.getSnapshotConfig(), job.getPolicyName())).waitForCompletion(false);
                getSnapshots = client.admin().cluster();
                Intrinsics.checkNotNullExpressionValue((Object)getSnapshots, (String)"cluster(...)");
                $continuation.L$0 = this;
                $continuation.L$1 = log;
                $continuation.L$2 = metadataBuilder;
                $continuation.L$3 = snapshotName;
                $continuation.label = 2;
                v4 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)getSnapshots, (Function2)new Function2<ClusterAdminClient, ActionListener<CreateSnapshotResponse>, Unit>(req){
                    final /* synthetic */ CreateSnapshotRequest $req;
                    {
                        this.$req = $req;
                        super(2);
                    }

                    public final void invoke(@NotNull ClusterAdminClient $this$suspendUntil, @NotNull ActionListener<CreateSnapshotResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.createSnapshot(this.$req, it);
                    }
                }, $continuation);
                ** if (v4 != var14_5) goto lbl65
lbl64:
                // 1 sources

                return var14_5;
lbl65:
                // 1 sources

                ** GOTO lbl75
            }
            case 2: {
                snapshotName = (String)$continuation.L$3;
                metadataBuilder = (SMMetadata.Builder)$continuation.L$2;
                log = (Logger)$continuation.L$1;
                this = (CreatingState)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl75:
                    // 2 sources

                    SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.IN_PROGRESS, false, this.getSnapshotCreationStartedMessage(snapshotName), false, null, null, 58, null).setCreationStarted(snapshotName);
                }
                catch (RemoteTransportException ex) {
                    v5 = ExceptionsHelper.unwrapCause((Throwable)ex);
                    Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    unwrappedException = (Exception)v5;
                    return this.handleException(unwrappedException, snapshotName, metadataBuilder, log);
                }
                catch (Exception ex) {
                    return this.handleException(ex, snapshotName, metadataBuilder, log);
                }
                return new SMResult.Next(metadataBuilder);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final SMResult handleException(Exception ex, String snapshotName, SMMetadata.Builder metadataBuilder, Logger log) {
        if (ex instanceof ConcurrentSnapshotExecutionException) {
            log.error(CONCURRENT_SNAPSHOT_MESSAGE, (Throwable)ex);
            SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.RETRYING, false, CONCURRENT_SNAPSHOT_MESSAGE, false, null, null, 58, null);
            return new SMResult.Stay(metadataBuilder);
        }
        log.error(this.getCreateSnapshotErrorMessage(snapshotName), (Throwable)ex);
        SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.RETRYING, false, this.getCreateSnapshotErrorMessage(snapshotName), false, ex, null, 42, null);
        return new SMResult.Fail(metadataBuilder, WorkflowType.CREATION, null, 4, null);
    }

    private final String getSnapshotCreationStartedMessage(String snapshotName) {
        return "Snapshot " + snapshotName + " creation has been started and waiting for completion.";
    }

    private final String getCreateSnapshotErrorMessage(String snapshotName) {
        return "Caught exception while creating snapshot " + snapshotName + ".";
    }

    private final String checkCreatedSnapshots(Instant lastExecutionTime, List<SnapshotInfo> snapshots) {
        if (snapshots.isEmpty()) {
            return null;
        }
        Iterable $this$sortedBy$iv = snapshots;
        boolean $i$f$sortedBy = false;
        int n = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SnapshotInfo it = (SnapshotInfo)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.startTime());
                it = (SnapshotInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.startTime()));
            }
        }).size() + -1;
        if (0 <= n) {
            int i;
            return !Instant.ofEpochMilli(snapshots.get(i = n--).startTime()).isBefore(lastExecutionTime) ? snapshots.get(i).snapshotId().getName() : null;
        }
        return null;
    }
}

