/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.explain;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.opensearch.knn.index.query.KNNScorer;

public class KnnExplanation {
    private final Map<Object, Integer> annResultPerLeaf = new ConcurrentHashMap<Object, Integer>();
    private final Map<Integer, Float> rawScores = new ConcurrentHashMap<Integer, Float>();
    private final Map<Object, KNNScorer> knnScorerPerLeaf = new ConcurrentHashMap<Object, KNNScorer>();
    private int cardinality = 0;

    public void addLeafResult(Object leafId, int annResult) {
        this.annResultPerLeaf.put(leafId, annResult);
    }

    public void addRawScore(int docId, float rawScore) {
        this.rawScores.put(docId, Float.valueOf(rawScore));
    }

    public void addKnnScorer(Object leafId, KNNScorer knnScorer) {
        this.knnScorerPerLeaf.put(leafId, knnScorer);
    }

    public Integer getAnnResult(Object leafId) {
        return this.annResultPerLeaf.get(leafId);
    }

    public Float getRawScore(int docId) {
        return this.rawScores.get(docId);
    }

    public KNNScorer getKnnScorer(Object leafId) {
        return this.knnScorerPerLeaf.get(leafId);
    }

    @Generated
    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    @Generated
    public int getCardinality() {
        return this.cardinality;
    }
}

