/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.memoryoptsearch.faiss.IndexTypeToFaissIndexMapping;

public abstract class FaissIndex {
    protected String indexType;
    protected int dimension;
    protected int totalNumberOfVectors;
    protected SpaceType spaceType;

    public FaissIndex(String indexType) {
        this.indexType = indexType;
    }

    public static FaissIndex load(IndexInput input) throws IOException {
        String indexType = FaissIndex.readIndexType(input);
        FaissIndex faissIndex = IndexTypeToFaissIndexMapping.getFaissIndex(indexType);
        faissIndex.doLoad(input);
        return faissIndex;
    }

    protected abstract void doLoad(IndexInput var1) throws IOException;

    protected void readCommonHeader(IndexInput readStream) throws IOException {
        this.dimension = readStream.readInt();
        this.totalNumberOfVectors = Math.toIntExact(readStream.readLong());
        readStream.readLong();
        readStream.readLong();
        boolean isTrained = readStream.readByte() == 1;
        int metricTypeIndex = readStream.readInt();
        if (metricTypeIndex == 0) {
            this.spaceType = SpaceType.INNER_PRODUCT;
        } else if (metricTypeIndex == 1) {
            this.spaceType = SpaceType.L2;
        } else {
            throw new IllegalStateException("Partial loading does not support metric type index=" + metricTypeIndex + " from FAISS.");
        }
    }

    private static String readIndexType(IndexInput input) throws IOException {
        byte[] fourBytes = new byte[4];
        input.readBytes(fourBytes, 0, fourBytes.length);
        return new String(fourBytes);
    }

    public abstract VectorEncoding getVectorEncoding();

    public KNNVectorSimilarityFunction getVectorSimilarityFunction() {
        return this.spaceType.getKnnVectorSimilarityFunction();
    }

    public abstract FloatVectorValues getFloatValues(IndexInput var1) throws IOException;

    public abstract ByteVectorValues getByteValues(IndexInput var1) throws IOException;

    @Generated
    public String getIndexType() {
        return this.indexType;
    }

    @Generated
    public int getDimension() {
        return this.dimension;
    }

    @Generated
    public int getTotalNumberOfVectors() {
        return this.totalNumberOfVectors;
    }

    @Generated
    public SpaceType getSpaceType() {
        return this.spaceType;
    }
}

