/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.opensearch.neuralsearch.processor.SearchShard;
import org.opensearch.neuralsearch.search.util.HybridSearchResultFormatUtil;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.query.QuerySearchResult;

public class CompoundTopDocs {
    @Generated
    private static final Logger log = LogManager.getLogger(CompoundTopDocs.class);
    private TotalHits totalHits;
    private List<TopDocs> topDocs;
    private List<ScoreDoc> scoreDocs;
    private SearchShard searchShard;

    public CompoundTopDocs(TotalHits totalHits, List<TopDocs> topDocs, boolean isSortEnabled, SearchShard searchShard) {
        this.initialize(totalHits, topDocs, isSortEnabled, searchShard);
    }

    private void initialize(TotalHits totalHits, List<TopDocs> topDocs, boolean isSortEnabled, SearchShard searchShard) {
        this.totalHits = totalHits;
        this.topDocs = topDocs;
        this.scoreDocs = this.cloneLargestScoreDocs(topDocs, isSortEnabled);
        this.searchShard = searchShard;
    }

    public CompoundTopDocs(QuerySearchResult querySearchResult) {
        ScoreDoc[] scoreDocs;
        TopDocs topDocs = querySearchResult.topDocs().topDocs;
        SearchShardTarget searchShardTarget = querySearchResult.getSearchShardTarget();
        SearchShard searchShard = SearchShard.createSearchShard(searchShardTarget);
        boolean isSortEnabled = false;
        if (topDocs instanceof TopFieldDocs) {
            isSortEnabled = true;
        }
        if (Objects.isNull(scoreDocs = topDocs.scoreDocs) || scoreDocs.length < 2) {
            this.initialize(topDocs.totalHits, new ArrayList<TopDocs>(), isSortEnabled, searchShard);
            return;
        }
        ArrayList<TopDocs> topDocsList = new ArrayList<TopDocs>();
        ArrayList<ScoreDoc> scoreDocList = new ArrayList<ScoreDoc>();
        for (int index = 2; index < scoreDocs.length; ++index) {
            ScoreDoc scoreDoc = scoreDocs[index];
            if (HybridSearchResultFormatUtil.isHybridQueryDelimiterElement(scoreDoc) || HybridSearchResultFormatUtil.isHybridQueryStartStopElement(scoreDoc)) {
                ScoreDoc[] subQueryScores = scoreDocList.toArray(new ScoreDoc[0]);
                TotalHits totalHits = new TotalHits((long)subQueryScores.length, TotalHits.Relation.EQUAL_TO);
                Object subQueryTopDocs = isSortEnabled ? new TopFieldDocs(totalHits, subQueryScores, ((TopFieldDocs)topDocs).fields) : new TopDocs(totalHits, subQueryScores);
                topDocsList.add((TopDocs)subQueryTopDocs);
                scoreDocList.clear();
                continue;
            }
            scoreDocList.add(scoreDoc);
        }
        this.initialize(topDocs.totalHits, topDocsList, isSortEnabled, searchShard);
    }

    private List<ScoreDoc> cloneLargestScoreDocs(List<TopDocs> docs, boolean isSortEnabled) {
        if (docs == null) {
            return null;
        }
        ScoreDoc[] maxScoreDocs = new ScoreDoc[]{};
        int maxLength = -1;
        for (TopDocs topDoc : docs) {
            if (topDoc == null || topDoc.scoreDocs == null || topDoc.scoreDocs.length <= maxLength) continue;
            maxLength = topDoc.scoreDocs.length;
            maxScoreDocs = topDoc.scoreDocs;
        }
        ArrayList<ScoreDoc> scoreDocs = new ArrayList<ScoreDoc>();
        for (ScoreDoc scoreDoc : maxScoreDocs) {
            scoreDocs.add(this.deepCopyScoreDoc(scoreDoc, isSortEnabled));
        }
        return scoreDocs;
    }

    private ScoreDoc deepCopyScoreDoc(ScoreDoc scoreDoc, boolean isSortEnabled) {
        if (!isSortEnabled) {
            return new ScoreDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex);
        }
        FieldDoc fieldDoc = (FieldDoc)scoreDoc;
        return new FieldDoc(fieldDoc.doc, fieldDoc.score, fieldDoc.fields, fieldDoc.shardIndex);
    }

    @Generated
    public CompoundTopDocs(TotalHits totalHits, List<TopDocs> topDocs, List<ScoreDoc> scoreDocs, SearchShard searchShard) {
        this.totalHits = totalHits;
        this.topDocs = topDocs;
        this.scoreDocs = scoreDocs;
        this.searchShard = searchShard;
    }

    @Generated
    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    @Generated
    public List<TopDocs> getTopDocs() {
        return this.topDocs;
    }

    @Generated
    public List<ScoreDoc> getScoreDocs() {
        return this.scoreDocs;
    }

    @Generated
    public String toString() {
        return "CompoundTopDocs(totalHits=" + this.getTotalHits() + ", topDocs=" + this.getTopDocs() + ", scoreDocs=" + this.getScoreDocs() + ", searchShard=" + this.getSearchShard() + ")";
    }

    @Generated
    public void setTotalHits(TotalHits totalHits) {
        this.totalHits = totalHits;
    }

    @Generated
    public void setScoreDocs(List<ScoreDoc> scoreDocs) {
        this.scoreDocs = scoreDocs;
    }

    @Generated
    public SearchShard getSearchShard() {
        return this.searchShard;
    }
}

