/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.opensearch.ml.common.utils.IndexUtils;

public enum MLIndex {
    MODEL_GROUP(".plugins-ml-model-group", false, "index-mappings/ml_model_group.json"),
    MODEL(".plugins-ml-model", false, "index-mappings/ml_model.json"),
    TASK(".plugins-ml-task", false, "index-mappings/ml_task.json"),
    CONNECTOR(".plugins-ml-connector", false, "index-mappings/ml_connector.json"),
    CONFIG(".plugins-ml-config", false, "index-mappings/ml_config.json"),
    CONTROLLER(".plugins-ml-controller", false, "index-mappings/ml_controller.json"),
    AGENT(".plugins-ml-agent", false, "index-mappings/ml_agent.json"),
    MEMORY_META(".plugins-ml-memory-meta", false, "index-mappings/ml_memory_meta.json"),
    MEMORY_MESSAGE(".plugins-ml-memory-message", false, "index-mappings/ml_memory_message.json"),
    MCP_SESSION_MANAGEMENT("index-mappings/ml_mcp_session_management.json", false, "index-mappings/ml_mcp_session_management.json");

    private final String indexName;
    private final boolean alias;
    private final String mapping;
    private final Integer version;

    private MLIndex(String name, boolean alias, String mappingPath) {
        this.indexName = name;
        this.alias = alias;
        this.mapping = this.getMapping(mappingPath);
        this.version = IndexUtils.getVersionFromMapping(this.mapping);
    }

    private String getMapping(String mappingPath) {
        if (mappingPath == null) {
            throw new IllegalArgumentException("Mapping path cannot be null");
        }
        try {
            return IndexUtils.getMappingFromFile(mappingPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to fetch index mapping from file: " + mappingPath, e);
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public String getMapping() {
        return this.mapping;
    }

    public Integer getVersion() {
        return this.version;
    }
}

