/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.connector.ConnectorProtocols;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;

@org.opensearch.ml.common.annotation.Connector(value="mcp_sse")
public class McpConnector
implements Connector {
    @Generated
    private static final Logger log = LogManager.getLogger(McpConnector.class);
    protected String name;
    protected String description;
    protected String version;
    protected String protocol;
    protected Map<String, String> credential;
    protected Map<String, String> decryptedHeaders;
    protected Map<String, String> decryptedCredential;
    protected List<String> backendRoles;
    protected User owner;
    protected AccessMode access;
    protected Instant createdTime;
    protected Instant lastUpdateTime;
    protected ConnectorClientConfig connectorClientConfig;
    protected String tenantId;
    protected String url;
    protected Map<String, String> headers;

    public McpConnector(String name, String description, String version, String protocol, Map<String, String> credential, List<String> backendRoles, AccessMode accessMode, User owner, ConnectorClientConfig connectorClientConfig, String tenantId, String url, Map<String, String> headers) {
        ConnectorProtocols.validateProtocol(protocol);
        this.name = name;
        this.description = description;
        this.version = version;
        this.protocol = protocol;
        this.credential = credential;
        this.backendRoles = backendRoles;
        this.access = accessMode;
        this.owner = owner;
        this.connectorClientConfig = connectorClientConfig;
        this.tenantId = tenantId;
        this.url = url;
        this.headers = headers;
    }

    public McpConnector(String protocol, XContentParser parser) throws IOException {
        this.protocol = protocol;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block32: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    this.name = parser.text();
                    continue block32;
                }
                case "version": {
                    this.version = parser.text();
                    continue block32;
                }
                case "description": {
                    this.description = parser.text();
                    continue block32;
                }
                case "protocol": {
                    this.protocol = parser.text();
                    continue block32;
                }
                case "credential": {
                    this.credential = new HashMap<String, String>();
                    this.credential.putAll(parser.mapStrings());
                    continue block32;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    this.backendRoles = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.backendRoles.add(parser.text());
                    }
                    continue block32;
                }
                case "owner": {
                    this.owner = User.parse((XContentParser)parser);
                    continue block32;
                }
                case "access": {
                    this.access = AccessMode.from(parser.text());
                    continue block32;
                }
                case "created_time": {
                    this.createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block32;
                }
                case "last_updated_time": {
                    this.lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block32;
                }
                case "client_config": {
                    this.connectorClientConfig = ConnectorClientConfig.parse(parser);
                    continue block32;
                }
                case "tenant_id": {
                    this.tenantId = parser.textOrNull();
                    continue block32;
                }
                case "url": {
                    this.url = parser.textOrNull();
                    continue block32;
                }
                case "headers": {
                    this.headers = new HashMap<String, String>();
                    this.headers.putAll(parser.mapStrings());
                    continue block32;
                }
            }
            parser.skipChildren();
        }
    }

    protected Map<String, String> createDecryptedHeaders(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        HashMap<String, String> decryptedHeaders = new HashMap<String, String>();
        StringSubstitutor substitutor = new StringSubstitutor(this.getDecryptedCredential(), "${credential.", "}");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            decryptedHeaders.put(entry.getKey(), substitutor.replace(entry.getValue()));
        }
        return decryptedHeaders;
    }

    @Override
    public void decrypt(String action, BiFunction<String, String, String> function, String tenantId) {
        HashMap<String, String> decrypted = new HashMap<String, String>();
        for (String key : this.credential.keySet()) {
            decrypted.put(key, function.apply(this.credential.get(key), tenantId));
        }
        this.decryptedCredential = decrypted;
        this.decryptedHeaders = this.createDecryptedHeaders(this.headers);
    }

    @Override
    public void encrypt(BiFunction<String, String, String> function, String tenantId) {
        for (String key : this.credential.keySet()) {
            String encrypted = function.apply(this.credential.get(key), tenantId);
            this.credential.put(key, encrypted);
        }
    }

    @Override
    public Connector cloneConnector() {
        McpConnector mcpConnector;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            this.writeTo((StreamOutput)bytesStreamOutput);
            StreamInput streamInput = bytesStreamOutput.bytes().streamInput();
            mcpConnector = new McpConnector(streamInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bytesStreamOutput.close();
        return mcpConnector;
    }

    public McpConnector(StreamInput input) throws IOException {
        this.protocol = input.readString();
        this.parseFromStream(input);
    }

    private void parseFromStream(StreamInput input) throws IOException {
        this.name = input.readOptionalString();
        this.version = input.readOptionalString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.credential = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.backendRoles = input.readOptionalStringList();
        if (input.readBoolean()) {
            this.access = (AccessMode)input.readEnum(AccessMode.class);
        }
        if (input.readBoolean()) {
            this.owner = new User(input);
        }
        this.createdTime = input.readOptionalInstant();
        this.lastUpdateTime = input.readOptionalInstant();
        if (input.readBoolean()) {
            this.connectorClientConfig = new ConnectorClientConfig(input);
        }
        this.tenantId = input.readOptionalString();
        this.url = input.readString();
        if (input.readBoolean()) {
            this.headers = input.readMap(s -> s.readString(), s -> s.readString());
        }
    }

    @Override
    public void removeCredential() {
        this.credential = null;
        this.decryptedCredential = null;
        this.decryptedHeaders = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.protocol);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.description);
        if (this.credential != null) {
            out.writeBoolean(true);
            out.writeMap(this.credential, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalStringCollection(this.backendRoles);
        if (this.access != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.access);
        } else {
            out.writeBoolean(false);
        }
        if (this.owner != null) {
            out.writeBoolean(true);
            this.owner.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        if (this.connectorClientConfig != null) {
            out.writeBoolean(true);
            this.connectorClientConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.tenantId);
        out.writeString(this.url);
        if (this.headers != null) {
            out.writeBoolean(true);
            out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void update(MLCreateConnectorInput updateContent, BiFunction<String, String, String> function) {
        if (updateContent.getName() != null) {
            this.name = updateContent.getName();
        }
        if (updateContent.getDescription() != null) {
            this.description = updateContent.getDescription();
        }
        if (updateContent.getVersion() != null) {
            this.version = updateContent.getVersion();
        }
        if (updateContent.getProtocol() != null) {
            this.protocol = updateContent.getProtocol();
        }
        if (updateContent.getCredential() != null && !updateContent.getCredential().isEmpty()) {
            this.credential = updateContent.getCredential();
            this.encrypt(function, this.tenantId);
        }
        if (updateContent.getBackendRoles() != null) {
            this.backendRoles = updateContent.getBackendRoles();
        }
        if (updateContent.getAccess() != null) {
            this.access = updateContent.getAccess();
        }
        if (updateContent.getConnectorClientConfig() != null) {
            this.connectorClientConfig = updateContent.getConnectorClientConfig();
        }
        if (updateContent.getUrl() != null) {
            this.url = updateContent.getUrl();
        }
        if (updateContent.getHeaders() != null) {
            this.headers = updateContent.getHeaders();
        }
    }

    @Override
    public <T> void parseResponse(T orElse, List<ModelTensor> modelTensors, boolean b) throws IOException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.version != null) {
            builder.field("version", this.version);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        if (this.protocol != null) {
            builder.field("protocol", this.protocol);
        }
        if (this.credential != null) {
            builder.field("credential", this.credential);
        }
        if (this.backendRoles != null) {
            builder.field("backend_roles", this.backendRoles);
        }
        if (this.owner != null) {
            builder.field("owner", (ToXContent)this.owner);
        }
        if (this.access != null) {
            builder.field("access", this.access.getValue());
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field("last_updated_time", this.lastUpdateTime.toEpochMilli());
        }
        if (this.connectorClientConfig != null) {
            builder.field("client_config", (ToXContent)this.connectorClientConfig);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        if (this.url != null) {
            builder.field("url", this.url);
        }
        if (this.headers != null) {
            builder.field("headers", this.headers);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void validateConnectorURL(List<String> urlRegexes) {
        boolean hasMatchedUrl = false;
        for (String urlRegex : urlRegexes) {
            Pattern pattern = Pattern.compile(urlRegex);
            Matcher matcher = pattern.matcher(this.url);
            if (!matcher.matches()) continue;
            hasMatchedUrl = true;
            break;
        }
        if (!hasMatchedUrl) {
            throw new IllegalArgumentException("Connector URL is not matching the trusted connector endpoint regex, URL is: " + this.url);
        }
    }

    @Override
    public Map<String, String> getParameters() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public List<ConnectorAction> getActions() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public void addAction(ConnectorAction action) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public String getActionEndpoint(String action, Map<String, String> parameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public String getActionHttpMethod(String action) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public <T> T createPayload(String action, Map<String, String> parameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public Optional<ConnectorAction> findAction(String action) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Generated
    public static McpConnectorBuilder builder() {
        return new McpConnectorBuilder();
    }

    @Generated
    public McpConnector() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McpConnector)) {
            return false;
        }
        McpConnector other = (McpConnector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Map<String, String> this$credential = this.getCredential();
        Map<String, String> other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
            return false;
        }
        Map<String, String> this$decryptedHeaders = this.getDecryptedHeaders();
        Map<String, String> other$decryptedHeaders = other.getDecryptedHeaders();
        if (this$decryptedHeaders == null ? other$decryptedHeaders != null : !((Object)this$decryptedHeaders).equals(other$decryptedHeaders)) {
            return false;
        }
        Map<String, String> this$decryptedCredential = this.getDecryptedCredential();
        Map<String, String> other$decryptedCredential = other.getDecryptedCredential();
        if (this$decryptedCredential == null ? other$decryptedCredential != null : !((Object)this$decryptedCredential).equals(other$decryptedCredential)) {
            return false;
        }
        List<String> this$backendRoles = this.getBackendRoles();
        List<String> other$backendRoles = other.getBackendRoles();
        if (this$backendRoles == null ? other$backendRoles != null : !((Object)this$backendRoles).equals(other$backendRoles)) {
            return false;
        }
        User this$owner = this.getOwner();
        User other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        AccessMode this$access = this.getAccess();
        AccessMode other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)((Object)this$access)).equals((Object)other$access)) {
            return false;
        }
        Instant this$createdTime = this.getCreatedTime();
        Instant other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Instant this$lastUpdateTime = this.getLastUpdateTime();
        Instant other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        ConnectorClientConfig this$connectorClientConfig = this.getConnectorClientConfig();
        ConnectorClientConfig other$connectorClientConfig = other.getConnectorClientConfig();
        if (this$connectorClientConfig == null ? other$connectorClientConfig != null : !((Object)this$connectorClientConfig).equals(other$connectorClientConfig)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof McpConnector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Map<String, String> $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
        Map<String, String> $decryptedHeaders = this.getDecryptedHeaders();
        result = result * 59 + ($decryptedHeaders == null ? 43 : ((Object)$decryptedHeaders).hashCode());
        Map<String, String> $decryptedCredential = this.getDecryptedCredential();
        result = result * 59 + ($decryptedCredential == null ? 43 : ((Object)$decryptedCredential).hashCode());
        List<String> $backendRoles = this.getBackendRoles();
        result = result * 59 + ($backendRoles == null ? 43 : ((Object)$backendRoles).hashCode());
        User $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        AccessMode $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)((Object)$access)).hashCode());
        Instant $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Instant $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        ConnectorClientConfig $connectorClientConfig = this.getConnectorClientConfig();
        result = result * 59 + ($connectorClientConfig == null ? 43 : ((Object)$connectorClientConfig).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public Map<String, String> getCredential() {
        return this.credential;
    }

    @Override
    @Generated
    public Map<String, String> getDecryptedHeaders() {
        return this.decryptedHeaders;
    }

    @Override
    @Generated
    public Map<String, String> getDecryptedCredential() {
        return this.decryptedCredential;
    }

    @Override
    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Override
    @Generated
    public User getOwner() {
        return this.owner;
    }

    @Override
    @Generated
    public AccessMode getAccess() {
        return this.access;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    @Generated
    public ConnectorClientConfig getConnectorClientConfig() {
        return this.connectorClientConfig;
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public void setDecryptedCredential(Map<String, String> decryptedCredential) {
        this.decryptedCredential = decryptedCredential;
    }

    @Override
    @Generated
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Override
    @Generated
    public void setOwner(User owner) {
        this.owner = owner;
    }

    @Override
    @Generated
    public void setAccess(AccessMode access) {
        this.access = access;
    }

    @Override
    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    @Generated
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public void setConnectorClientConfig(ConnectorClientConfig connectorClientConfig) {
        this.connectorClientConfig = connectorClientConfig;
    }

    @Override
    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Generated
    public static class McpConnectorBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private String protocol;
        @Generated
        private Map<String, String> credential;
        @Generated
        private List<String> backendRoles;
        @Generated
        private AccessMode accessMode;
        @Generated
        private User owner;
        @Generated
        private ConnectorClientConfig connectorClientConfig;
        @Generated
        private String tenantId;
        @Generated
        private String url;
        @Generated
        private Map<String, String> headers;

        @Generated
        McpConnectorBuilder() {
        }

        @Generated
        public McpConnectorBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public McpConnectorBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public McpConnectorBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public McpConnectorBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public McpConnectorBuilder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        @Generated
        public McpConnectorBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public McpConnectorBuilder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        @Generated
        public McpConnectorBuilder owner(User owner) {
            this.owner = owner;
            return this;
        }

        @Generated
        public McpConnectorBuilder connectorClientConfig(ConnectorClientConfig connectorClientConfig) {
            this.connectorClientConfig = connectorClientConfig;
            return this;
        }

        @Generated
        public McpConnectorBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public McpConnectorBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public McpConnectorBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public McpConnector build() {
            return new McpConnector(this.name, this.description, this.version, this.protocol, this.credential, this.backendRoles, this.accessMode, this.owner, this.connectorClientConfig, this.tenantId, this.url, this.headers);
        }

        @Generated
        public String toString() {
            return "McpConnector.McpConnectorBuilder(name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", protocol=" + this.protocol + ", credential=" + String.valueOf(this.credential) + ", backendRoles=" + String.valueOf(this.backendRoles) + ", accessMode=" + String.valueOf((Object)this.accessMode) + ", owner=" + String.valueOf(this.owner) + ", connectorClientConfig=" + String.valueOf(this.connectorClientConfig) + ", tenantId=" + this.tenantId + ", url=" + this.url + ", headers=" + String.valueOf(this.headers) + ")";
        }
    }
}

