/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.mcpserver.requests.register;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class McpTool
implements ToXContentObject,
Writeable {
    @Generated
    private static final Logger log = LogManager.getLogger(McpTool.class);
    private static final String TYPE_FIELD = "type";
    private static final String NAME_FIELD = "name";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String PARAMS_FIELD = "parameters";
    private static final String ATTRIBUTES_FIELD = "attributes";
    public static final String SCHEMA_FIELD = "input_schema";
    private final String type;
    private String name;
    private final String description;
    private Map<String, Object> parameters;
    private Map<String, Object> attributes;
    private static final String TYPE_NOT_SHOWN_EXCEPTION_MESSAGE = "type field required";

    public McpTool(StreamInput streamInput) throws IOException {
        this.type = streamInput.readString();
        if (this.type == null) {
            throw new IllegalArgumentException(TYPE_NOT_SHOWN_EXCEPTION_MESSAGE);
        }
        this.name = streamInput.readOptionalString();
        this.description = streamInput.readOptionalString();
        if (streamInput.readBoolean()) {
            this.parameters = streamInput.readMap(StreamInput::readString, StreamInput::readGenericValue);
        }
        if (streamInput.readBoolean()) {
            this.attributes = streamInput.readMap(StreamInput::readString, StreamInput::readGenericValue);
        }
    }

    public McpTool(String name, String type, String description, Map<String, Object> parameters, Map<String, Object> attributes) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.parameters = parameters;
        this.attributes = attributes;
    }

    public static McpTool parse(XContentParser parser) throws IOException {
        String type = null;
        String name = null;
        String description = null;
        Map params = null;
        Map attrubutes = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block14;
                }
                case "name": {
                    name = parser.text();
                    continue block14;
                }
                case "description": {
                    description = parser.text();
                    continue block14;
                }
                case "parameters": {
                    params = parser.map();
                    continue block14;
                }
                case "attributes": {
                    attrubutes = parser.map();
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        if (type == null) {
            throw new IllegalArgumentException(TYPE_NOT_SHOWN_EXCEPTION_MESSAGE);
        }
        return new McpTool(name, type, description, params, attrubutes);
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeString(this.type);
        streamOutput.writeOptionalString(this.name);
        streamOutput.writeOptionalString(this.description);
        if (this.parameters != null) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            streamOutput.writeBoolean(false);
        }
        if (this.attributes != null) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            streamOutput.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params xcontentParams) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD, this.type);
        if (this.name != null) {
            builder.field(NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            builder.field(PARAMS_FIELD, this.parameters);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            builder.field(SCHEMA_FIELD, this.attributes);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McpTool)) {
            return false;
        }
        McpTool other = (McpTool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, Object> this$attributes = this.getAttributes();
        Map<String, Object> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof McpTool;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, Object> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "McpTool(type=" + this.getType() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + String.valueOf(this.getParameters()) + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
    }
}

