/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.mcpserver.requests.register;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.mcpserver.requests.register.McpTool;

public class McpTools
implements ToXContentObject,
Writeable {
    private static final String TOOLS_FIELD = "tools";
    private static final String CREATED_TIME_FIELD = "create_time";
    private static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    private List<McpTool> tools;
    private final Instant createdTime;
    private final Instant lastUpdateTime;

    public McpTools(StreamInput streamInput) throws IOException {
        if (streamInput.readBoolean()) {
            this.tools = streamInput.readList(si -> new McpTool(streamInput));
        }
        this.createdTime = streamInput.readOptionalInstant();
        this.lastUpdateTime = streamInput.readOptionalInstant();
    }

    public McpTools(List<McpTool> tools, Instant createdTime, Instant lastUpdateTime) {
        this.tools = tools;
        this.createdTime = createdTime;
        this.lastUpdateTime = lastUpdateTime;
    }

    public static McpTools parse(XContentParser parser) throws IOException {
        List<McpTool> tools = List.of();
        Instant createdTime = null;
        Instant lastUpdateTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "tools": {
                    tools = new ArrayList<McpTool>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        tools.add(McpTool.parse(parser));
                    }
                    continue block10;
                }
                case "create_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block10;
                }
                case "last_updated_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        return new McpTools(tools, createdTime, lastUpdateTime);
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        if (this.tools != null) {
            streamOutput.writeBoolean(true);
            streamOutput.writeList(this.tools);
        } else {
            streamOutput.writeBoolean(false);
        }
        streamOutput.writeOptionalInstant(this.createdTime);
        streamOutput.writeOptionalInstant(this.lastUpdateTime);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.tools != null && !this.tools.isEmpty()) {
            builder.field(TOOLS_FIELD, this.tools);
        }
        if (this.createdTime != null) {
            builder.field(CREATED_TIME_FIELD, this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATED_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public List<McpTool> getTools() {
        return this.tools;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }
}

