/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.text.Text;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.neuralsearch.highlight.SemanticHighlighterEngine;
import org.opensearch.search.fetch.subphase.highlight.FieldHighlightContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.opensearch.search.fetch.subphase.highlight.Highlighter;

public class SemanticHighlighter
implements Highlighter {
    @Generated
    private static final Logger log = LogManager.getLogger(SemanticHighlighter.class);
    public static final String NAME = "semantic";
    private SemanticHighlighterEngine semanticHighlighterEngine;

    public void initialize(SemanticHighlighterEngine semanticHighlighterEngine) {
        if (this.semanticHighlighterEngine != null) {
            throw new IllegalStateException("SemanticHighlighterEngine has already been initialized. Multiple initializations are not permitted.");
        }
        this.semanticHighlighterEngine = semanticHighlighterEngine;
    }

    public boolean canHighlight(MappedFieldType fieldType) {
        return true;
    }

    public HighlightField highlight(FieldHighlightContext fieldContext) {
        String[] postTags;
        if (this.semanticHighlighterEngine == null) {
            throw new IllegalStateException("SemanticHighlighter has not been initialized");
        }
        String fieldText = this.semanticHighlighterEngine.getFieldText(fieldContext);
        String modelId = this.semanticHighlighterEngine.getModelId(fieldContext.field.fieldOptions().options());
        String originalQueryText = this.semanticHighlighterEngine.extractOriginalQuery(fieldContext.query, fieldContext.fieldName);
        if (originalQueryText == null || originalQueryText.isEmpty()) {
            log.warn("No query text found for field {}", (Object)fieldContext.fieldName);
            return null;
        }
        String[] preTags = fieldContext.field.fieldOptions().preTags();
        String highlightedResponse = this.semanticHighlighterEngine.getHighlightedSentences(modelId, originalQueryText, fieldText, preTags[0], (postTags = fieldContext.field.fieldOptions().postTags())[0]);
        if (highlightedResponse == null || highlightedResponse.isEmpty()) {
            log.warn("No highlighted text found for field {}", (Object)fieldContext.fieldName);
            return null;
        }
        Text[] fragments = new Text[]{new Text(highlightedResponse)};
        return new HighlightField(fieldContext.fieldName, fragments);
    }
}

