/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.FilterFieldType;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.neuralsearch.mapper.dto.SemanticParameters;

public class SemanticFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "semantic";
    private final SemanticParameters semanticParameters;
    private ParametrizedFieldMapper delegateFieldMapper;

    protected SemanticFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, ParametrizedFieldMapper delegateFieldMapper, SemanticParameters semanticParameters) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.delegateFieldMapper = delegateFieldMapper;
        this.semanticParameters = semanticParameters;
    }

    public Builder getMergeBuilder() {
        Builder semanticFieldMapperBuilder = (Builder)new Builder(this.simpleName()).init((FieldMapper)this);
        ParametrizedFieldMapper.Builder delegateBuilder = this.delegateFieldMapper.getMergeBuilder();
        semanticFieldMapperBuilder.setDelegateBuilder(delegateBuilder);
        return semanticFieldMapperBuilder;
    }

    public final ParametrizedFieldMapper merge(Mapper mergeWith) {
        if (mergeWith instanceof SemanticFieldMapper) {
            try {
                this.delegateFieldMapper = this.delegateFieldMapper.merge((Mapper)((SemanticFieldMapper)mergeWith).delegateFieldMapper);
            }
            catch (IllegalArgumentException e) {
                String err = String.format(Locale.ROOT, "Failed to update the mapper %s because failed to update the delegate mapper for the raw_field_type %s due to %s", this.name(), this.semanticParameters.getRawFieldType(), e.getMessage());
                throw new IllegalArgumentException(err, e);
            }
        }
        return super.merge(mergeWith);
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        this.delegateFieldMapper.parse(context);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        List<ParametrizedFieldMapper.Parameter<?>> parameters = this.getMergeBuilder().getParameters();
        for (ParametrizedFieldMapper.Parameter<?> parameter : parameters) {
            if ("raw_field_type".equals(parameter.name)) {
                parameter.toXContent(builder, true);
                continue;
            }
            parameter.toXContent(builder, includeDefaults);
        }
        this.delegateFieldMapper.multiFields().toXContent(builder, params);
        this.delegateFieldMapper.copyTo().toXContent(builder, params);
        this.delegateFieldMapper.getMergeBuilder().toXContent(builder, includeDefaults);
    }

    @Generated
    public void setDelegateFieldMapper(ParametrizedFieldMapper delegateFieldMapper) {
        this.delegateFieldMapper = delegateFieldMapper;
    }

    @Generated
    public ParametrizedFieldMapper getDelegateFieldMapper() {
        return this.delegateFieldMapper;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        protected final ParametrizedFieldMapper.Parameter<String> modelId = ParametrizedFieldMapper.Parameter.stringParam((String)"model_id", (boolean)true, m -> ((SemanticFieldMapper)m).semanticParameters.getModelId(), null);
        protected final ParametrizedFieldMapper.Parameter<String> searchModelId = ParametrizedFieldMapper.Parameter.stringParam((String)"search_model_id", (boolean)true, m -> ((SemanticFieldMapper)m).semanticParameters.getSearchModelId(), null);
        protected final ParametrizedFieldMapper.Parameter<String> rawFieldType = ParametrizedFieldMapper.Parameter.stringParam((String)"raw_field_type", (boolean)false, m -> ((SemanticFieldMapper)m).semanticParameters.getRawFieldType(), (String)"text");
        protected final ParametrizedFieldMapper.Parameter<String> semanticInfoFieldName = ParametrizedFieldMapper.Parameter.stringParam((String)"semantic_info_field_name", (boolean)false, m -> ((SemanticFieldMapper)m).semanticParameters.getSemanticInfoFieldName(), null);
        protected ParametrizedFieldMapper.Builder delegateBuilder;

        protected Builder(String name) {
            super(name);
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return List.of(this.modelId, this.searchModelId, this.rawFieldType, this.semanticInfoFieldName);
        }

        public SemanticFieldMapper build(Mapper.BuilderContext context) {
            ParametrizedFieldMapper delegateMapper = this.delegateBuilder.build(context);
            SemanticParameters semanticParameters = this.getSemanticParameters();
            SemanticFieldType semanticFieldType = new SemanticFieldType(delegateMapper.fieldType(), semanticParameters);
            return new SemanticFieldMapper(this.name, (MappedFieldType)semanticFieldType, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), delegateMapper, semanticParameters);
        }

        public SemanticParameters getSemanticParameters() {
            return new SemanticParameters((String)this.modelId.getValue(), (String)this.searchModelId.getValue(), (String)this.rawFieldType.getValue(), (String)this.semanticInfoFieldName.getValue());
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<String> getModelId() {
            return this.modelId;
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<String> getSearchModelId() {
            return this.searchModelId;
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<String> getRawFieldType() {
            return this.rawFieldType;
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<String> getSemanticInfoFieldName() {
            return this.semanticInfoFieldName;
        }

        @Generated
        public void setDelegateBuilder(ParametrizedFieldMapper.Builder delegateBuilder) {
            this.delegateBuilder = delegateBuilder;
        }
    }

    public static class SemanticFieldType
    extends FilterFieldType {
        private SemanticParameters semanticParameters;

        public SemanticFieldType(@NonNull MappedFieldType delegate, @NonNull SemanticParameters semanticParameters) {
            super(delegate);
            Objects.requireNonNull(delegate, "delegate is marked non-null but is null");
            Objects.requireNonNull(semanticParameters, "semanticParameters is marked non-null but is null");
            this.semanticParameters = semanticParameters;
        }

        public String typeName() {
            return SemanticFieldMapper.CONTENT_TYPE;
        }

        @Generated
        public SemanticParameters getSemanticParameters() {
            return this.semanticParameters;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private static final Set<String> SUPPORTED_RAW_FIELD_TYPE = Set.of("text", "keyword", "match_only_text", "wildcard", "token_count", "binary");

        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            String rawFieldType = (String)node.getOrDefault("raw_field_type", "text");
            this.validateRawFieldType(rawFieldType);
            ParametrizedFieldMapper.TypeParser typeParser = (ParametrizedFieldMapper.TypeParser)parserContext.typeParser(rawFieldType);
            Builder semanticFieldMapperBuilder = new Builder(name);
            Map<String, Object> semanticConfig = this.extractSemanticConfig(node, semanticFieldMapperBuilder.getParameters(), rawFieldType);
            semanticFieldMapperBuilder.parse(name, parserContext, semanticConfig);
            ParametrizedFieldMapper.Builder delegateBuilder = typeParser.parse(name, node, parserContext);
            semanticFieldMapperBuilder.setDelegateBuilder(delegateBuilder);
            return semanticFieldMapperBuilder;
        }

        private void validateRawFieldType(String rawFieldType) {
            if (rawFieldType == null || !SUPPORTED_RAW_FIELD_TYPE.contains(rawFieldType)) {
                String err = String.format(Locale.ROOT, "raw_field_type %s is not supported. It should be one of [%s]", rawFieldType, String.join((CharSequence)", ", SUPPORTED_RAW_FIELD_TYPE));
                throw new IllegalArgumentException(err);
            }
        }

        private Map<String, Object> extractSemanticConfig(Map<String, Object> node, List<ParametrizedFieldMapper.Parameter<?>> parameters, String rawFieldType) {
            HashMap<String, Object> semanticConfig = new HashMap<String, Object>();
            for (ParametrizedFieldMapper.Parameter<?> parameter : parameters) {
                Object config = node.get(parameter.name);
                if (config == null) continue;
                semanticConfig.put(parameter.name, config);
                node.remove(parameter.name);
            }
            semanticConfig.put("type", SemanticFieldMapper.CONTENT_TYPE);
            node.put("type", rawFieldType);
            return semanticConfig;
        }
    }
}

