/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.events;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.opensearch.neuralsearch.stats.common.StatName;
import org.opensearch.neuralsearch.stats.events.EventStat;
import org.opensearch.neuralsearch.stats.events.EventStatType;
import org.opensearch.neuralsearch.stats.events.TimestampedEventStat;

public enum EventStatName implements StatName
{
    TEXT_EMBEDDING_PROCESSOR_EXECUTIONS("text_embedding_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER);

    private final String nameString;
    private final String path;
    private final EventStatType statType;
    private EventStat eventStat;
    private static final Map<String, EventStatName> BY_NAME;

    private EventStatName(String nameString, String path, EventStatType statType) {
        this.nameString = nameString;
        this.path = path;
        this.statType = statType;
        switch (statType) {
            case TIMESTAMPED_EVENT_COUNTER: {
                this.eventStat = new TimestampedEventStat(this);
            }
        }
        if (this.eventStat == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to initialize event stat [%s]. Unrecognized event stat type: [%s]", nameString, statType));
        }
    }

    public static EventStatName from(String name) {
        if (!BY_NAME.containsKey(name)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Event stat not found: %s", name));
        }
        return BY_NAME.get(name);
    }

    @Override
    public String getFullPath() {
        if (StringUtils.isBlank((String)this.path)) {
            return this.nameString;
        }
        return String.join((CharSequence)".", this.path, this.nameString);
    }

    public String toString() {
        return this.getNameString();
    }

    @Override
    @Generated
    public String getNameString() {
        return this.nameString;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public EventStatType getStatType() {
        return this.statType;
    }

    @Generated
    public EventStat getEventStat() {
        return this.eventStat;
    }

    static {
        BY_NAME = Arrays.stream(EventStatName.values()).collect(Collectors.toMap(stat -> stat.nameString, stat -> stat));
    }
}

