/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.info;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.neuralsearch.settings.NeuralSearchSettingsAccessor;
import org.opensearch.neuralsearch.stats.common.StatSnapshot;
import org.opensearch.neuralsearch.stats.info.CountableInfoStatSnapshot;
import org.opensearch.neuralsearch.stats.info.InfoStatName;
import org.opensearch.neuralsearch.stats.info.InfoStatType;
import org.opensearch.neuralsearch.stats.info.SettableInfoStatSnapshot;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;
import org.opensearch.neuralsearch.util.PipelineServiceUtil;

public class InfoStatsManager {
    public static final String PROCESSORS_KEY = "processors";
    private final NeuralSearchClusterUtil neuralSearchClusterUtil;
    private final NeuralSearchSettingsAccessor settingsAccessor;
    private final PipelineServiceUtil pipelineServiceUtil;

    public InfoStatsManager(NeuralSearchClusterUtil neuralSearchClusterUtil, NeuralSearchSettingsAccessor settingsAccessor, PipelineServiceUtil pipelineServiceUtil) {
        this.neuralSearchClusterUtil = neuralSearchClusterUtil;
        this.settingsAccessor = settingsAccessor;
        this.pipelineServiceUtil = pipelineServiceUtil;
    }

    public Map<InfoStatName, StatSnapshot<?>> getStats(EnumSet<InfoStatName> statsToRetrieve) {
        Map<InfoStatName, CountableInfoStatSnapshot> countableInfoStats = this.getCountableStats();
        Map<InfoStatName, SettableInfoStatSnapshot<?>> settableInfoStats = this.getSettableStats();
        HashMap<InfoStatName, StatSnapshot<Long>> prefilteredStats = new HashMap<InfoStatName, StatSnapshot<Long>>();
        prefilteredStats.putAll(countableInfoStats);
        prefilteredStats.putAll(settableInfoStats);
        Map<InfoStatName, StatSnapshot<?>> filteredStats = prefilteredStats.entrySet().stream().filter(entry -> statsToRetrieve.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return filteredStats;
    }

    private Map<InfoStatName, CountableInfoStatSnapshot> getCountableStats() {
        HashMap<InfoStatName, CountableInfoStatSnapshot> countableInfoStats = new HashMap<InfoStatName, CountableInfoStatSnapshot>();
        for (InfoStatName stat : EnumSet.allOf(InfoStatName.class)) {
            if (stat.getStatType() != InfoStatType.INFO_COUNTER) continue;
            countableInfoStats.put(stat, new CountableInfoStatSnapshot(stat));
        }
        this.addIngestProcessorStats(countableInfoStats);
        return countableInfoStats;
    }

    private Map<InfoStatName, SettableInfoStatSnapshot<?>> getSettableStats() {
        HashMap settableInfoStats = new HashMap();
        for (InfoStatName statName : EnumSet.allOf(InfoStatName.class)) {
            switch (statName.getStatType()) {
                case INFO_BOOLEAN: {
                    settableInfoStats.put(statName, new SettableInfoStatSnapshot(statName));
                    break;
                }
                case INFO_STRING: {
                    settableInfoStats.put(statName, new SettableInfoStatSnapshot(statName));
                }
            }
        }
        this.addClusterVersionStat(settableInfoStats);
        return settableInfoStats;
    }

    private void addClusterVersionStat(Map<InfoStatName, SettableInfoStatSnapshot<?>> stats) {
        InfoStatName infoStatName = InfoStatName.CLUSTER_VERSION;
        String version = this.neuralSearchClusterUtil.getClusterMinVersion().toString();
        stats.put(infoStatName, new SettableInfoStatSnapshot<String>(infoStatName, version));
    }

    private void addIngestProcessorStats(Map<InfoStatName, CountableInfoStatSnapshot> stats) {
        List<Map<String, Object>> pipelineConfigs = this.pipelineServiceUtil.getIngestPipelineConfigs();
        for (Map<String, Object> pipelineConfig : pipelineConfigs) {
            List<Map<String, Object>> ingestProcessors = this.asListOfMaps(pipelineConfig.get(PROCESSORS_KEY));
            for (Map<String, Object> ingestProcessor : ingestProcessors) {
                for (Map.Entry<String, Object> entry : ingestProcessor.entrySet()) {
                    String processorType = entry.getKey();
                    Map<String, Object> processorConfig = this.asMap(entry.getValue());
                    switch (processorType) {
                        case "text_embedding": {
                            this.increment(stats, InfoStatName.TEXT_EMBEDDING_PROCESSORS);
                        }
                    }
                }
            }
        }
    }

    private void increment(Map<InfoStatName, CountableInfoStatSnapshot> stats, InfoStatName infoStatName) {
        this.incrementBy(stats, infoStatName, 1L);
    }

    private void incrementBy(Map<InfoStatName, CountableInfoStatSnapshot> stats, InfoStatName statName, Long amount) {
        if (stats.containsKey(statName)) {
            stats.get(statName).incrementBy(amount);
        }
    }

    private <T> T getValue(Map<String, Object> map, String key, Class<T> clazz) {
        if (map == null || key == null) {
            return null;
        }
        Object value = map.get(key);
        return clazz.isInstance(value) ? (T)clazz.cast(value) : null;
    }

    private Map<String, Object> asMap(Object value) {
        return value instanceof Map ? (Map)value : null;
    }

    private List<Map<String, Object>> asListOfMaps(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            for (Object item : list) {
                if (item instanceof Map) continue;
                return null;
            }
            return (List)value;
        }
        return null;
    }
}

