/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util.prune;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public enum PruneType {
    NONE("none"),
    TOP_K("top_k"),
    ALPHA_MASS("alpha_mass"),
    MAX_RATIO("max_ratio"),
    ABS_VALUE("abs_value");

    private final String value;

    private PruneType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PruneType fromString(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return NONE;
        }
        for (PruneType type : PruneType.values()) {
            if (!type.value.equals(value)) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown prune type: %s", value));
    }
}

