/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.LruCacheKey;

public abstract class AbstractLruCache<Key extends LruCacheKey> {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractLruCache.class);
    protected final Map<Key, Boolean> accessRecencyMap = Collections.synchronizedMap(new LinkedHashMap(16, 0.75f, true));

    protected AbstractLruCache() {
    }

    protected void updateAccess(Key key) {
        if (key == null) {
            return;
        }
        this.accessRecencyMap.put(key, true);
    }

    protected Key getLeastRecentlyUsedItem() {
        Iterator<Map.Entry<Key, Boolean>> iterator = this.accessRecencyMap.entrySet().iterator();
        if (iterator.hasNext()) {
            return (Key)((LruCacheKey)iterator.next().getKey());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(long ramBytesToRelease) {
        long ramBytesReleased;
        if (ramBytesToRelease <= 0L) {
            return;
        }
        Map<Key, Boolean> map = this.accessRecencyMap;
        synchronized (map) {
            Key leastRecentlyUsedKey;
            for (ramBytesReleased = 0L; ramBytesReleased < ramBytesToRelease && (leastRecentlyUsedKey = this.getLeastRecentlyUsedItem()) != null; ramBytesReleased += this.evictItem(leastRecentlyUsedKey)) {
            }
        }
        log.debug("Freed {} bytes of memory", (Object)ramBytesReleased);
    }

    protected long evictItem(Key key) {
        if (this.accessRecencyMap.remove(key) == null) {
            return 0L;
        }
        return this.doEviction(key);
    }

    public void onIndexRemoval(@NonNull CacheKey cacheKey) {
        Objects.requireNonNull(cacheKey, "cacheKey is marked non-null but is null");
        this.accessRecencyMap.keySet().removeIf(key -> key.getCacheKey().equals(cacheKey));
    }

    protected abstract long doEviction(Key var1);
}

