/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.RcaConsts;

public class RcaControllerHelper {
    private static final Logger LOG = LogManager.getLogger(RcaControllerHelper.class);
    public static final String CAT_CLUSTER_MANAGER_URL = "http://localhost:9200/_cat/cluster_manager?h=ip";
    private static String ELECTED_CLUSTER_MANAGER_RCA_CONF_PATH = RcaConsts.RCA_CONF_CLUSTER_MANAGER_PATH;
    private static String CLUSTER_MANAGER_RCA_CONF_PATH = RcaConsts.RCA_CONF_IDLE_CLUSTER_MANAGER_PATH;
    private static String RCA_CONF_PATH = RcaConsts.RCA_CONF_PATH;

    public static RcaConf pickRcaConfForRole(AllMetrics.NodeRole nodeRole) {
        if (AllMetrics.NodeRole.ELECTED_CLUSTER_MANAGER == nodeRole) {
            LOG.debug("picking elected cluster_manager conf");
            return new RcaConf(ELECTED_CLUSTER_MANAGER_RCA_CONF_PATH);
        }
        if (AllMetrics.NodeRole.CLUSTER_MANAGER == nodeRole) {
            LOG.debug("picking idle cluster_manager conf");
            return new RcaConf(CLUSTER_MANAGER_RCA_CONF_PATH);
        }
        if (AllMetrics.NodeRole.DATA == nodeRole) {
            LOG.debug("picking data node conf");
            return new RcaConf(RCA_CONF_PATH);
        }
        LOG.debug("picking default conf");
        return new RcaConf(RCA_CONF_PATH);
    }

    public static String getElectedClusterManagerHostAddress() {
        try {
            LOG.info("Making _cat/cluster_manager call");
            ServiceMetrics.RCA_RUNTIME_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaRuntimeMetrics.OPEN_SEARCH_APIS_CALLED, "catClusterManager", (Number)1);
            URL url = new URL(CAT_CLUSTER_MANAGER_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String inputLine = in.readLine();
            in.close();
            return inputLine;
        }
        catch (IOException e) {
            LOG.error("Could not get the elected cluster_manager node", (Throwable)e);
            return "";
        }
    }

    public static ExecutorService buildNetworkThreadPool(int queueLength) {
        ThreadFactory rcaNetThreadFactory = new ThreadFactoryBuilder().setNameFormat("rca-net-%d").setDaemon(true).build();
        LinkedBlockingQueue<Runnable> threadPoolQueue = new LinkedBlockingQueue<Runnable>(queueLength);
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, threadPoolQueue, rcaNetThreadFactory);
    }

    public static void set(String rcaConfPath, String rcaMaterConfPath, String rcaElectedClusterManagerConfPath) {
        RCA_CONF_PATH = rcaConfPath;
        CLUSTER_MANAGER_RCA_CONF_PATH = rcaMaterConfPath;
        ELECTED_CLUSTER_MANAGER_RCA_CONF_PATH = rcaElectedClusterManagerConfPath;
    }

    public static List<String> getAllConfFilePaths() {
        return ImmutableList.of((Object)ELECTED_CLUSTER_MANAGER_RCA_CONF_PATH, (Object)CLUSTER_MANAGER_RCA_CONF_PATH, (Object)RCA_CONF_PATH);
    }
}

