/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.AccountKind;
import com.azure.storage.blob.models.SkuName;
import java.time.OffsetDateTime;

public final class ContainersGetAccountInfoHeaders {
    private String xMsVersion;
    private AccountKind xMsAccountKind;
    private SkuName xMsSkuName;
    private String xMsRequestId;
    private String xMsClientRequestId;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_ACCOUNT_KIND = HttpHeaderName.fromString((String)"x-ms-account-kind");
    private static final HttpHeaderName X_MS_SKU_NAME = HttpHeaderName.fromString((String)"x-ms-sku-name");

    public ContainersGetAccountInfoHeaders(HttpHeaders rawHeaders) {
        String xMsSkuName;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsAccountKind = rawHeaders.getValue(X_MS_ACCOUNT_KIND);
        if (xMsAccountKind != null) {
            this.xMsAccountKind = AccountKind.fromString(xMsAccountKind);
        }
        if ((xMsSkuName = rawHeaders.getValue(X_MS_SKU_NAME)) != null) {
            this.xMsSkuName = SkuName.fromString(xMsSkuName);
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public ContainersGetAccountInfoHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public AccountKind getXMsAccountKind() {
        return this.xMsAccountKind;
    }

    public ContainersGetAccountInfoHeaders setXMsAccountKind(AccountKind xMsAccountKind) {
        this.xMsAccountKind = xMsAccountKind;
        return this;
    }

    public SkuName getXMsSkuName() {
        return this.xMsSkuName;
    }

    public ContainersGetAccountInfoHeaders setXMsSkuName(SkuName xMsSkuName) {
        this.xMsSkuName = xMsSkuName;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public ContainersGetAccountInfoHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public ContainersGetAccountInfoHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public ContainersGetAccountInfoHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

