/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class FSTreeTraverser {
    public static final Logger LOG = LoggerFactory.getLogger(FSTreeTraverser.class);
    private final FSDirectory dir;
    private long readLockReportingThresholdMs;
    private Timer timer;

    public FSTreeTraverser(FSDirectory dir, Configuration conf) {
        this.dir = dir;
        this.readLockReportingThresholdMs = conf.getLong("dfs.namenode.read-lock-reporting-threshold-ms", 5000L);
        this.timer = new Timer();
    }

    public FSDirectory getFSDirectory() {
        return this.dir;
    }

    protected void traverseDir(INodeDirectory parent, long startId, byte[] startAfter, TraverseInfo traverseInfo) throws IOException, InterruptedException {
        ArrayList<byte[]> startAfters = new ArrayList<byte[]>();
        if (parent == null) {
            return;
        }
        INode curr = parent;
        startAfters.add(startAfter);
        while (((INode)curr).getId() != startId) {
            startAfters.add(0, curr.getLocalNameBytes());
            curr = curr.getParent();
        }
        curr = this.traverseDirInt(startId, parent, startAfters, traverseInfo);
        while (!startAfters.isEmpty()) {
            if (curr == null) {
                curr = this.resolvePaths(startId, startAfters);
            }
            curr = this.traverseDirInt(startId, curr, startAfters, traverseInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected INode traverseDirInt(long startId, INode curr, List<byte[]> startAfters, TraverseInfo traverseInfo) throws IOException, InterruptedException {
        assert (this.dir.hasReadLock());
        assert (this.dir.getFSNamesystem().hasReadLock());
        long lockStartTime = this.timer.monotonicNow();
        Preconditions.checkNotNull((Object)curr, (Object)"Current inode can't be null");
        this.checkINodeReady(startId);
        INodeDirectory parent = curr.isDirectory() ? curr.asDirectory() : curr.getParent();
        ReadOnlyList<INode> children = parent.getChildrenList(0x7FFFFFFE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Traversing directory {}", (Object)parent.getFullPathName());
        }
        byte[] startAfter = startAfters.get(startAfters.size() - 1);
        boolean lockReleased = false;
        for (int i = INodeDirectory.nextChild(children, startAfter); i < children.size(); ++i) {
            INode inode = children.get(i);
            if (!this.processFileInode(inode, traverseInfo)) {
                if (!inode.isDirectory() || !this.canTraverseDir(inode)) continue;
                curr = inode;
                if (!startAfters.isEmpty()) {
                    startAfters.remove(startAfters.size() - 1);
                    startAfters.add(curr.getLocalNameBytes());
                }
                startAfters.add(HdfsFileStatus.EMPTY_NAME);
                return lockReleased ? null : curr;
            }
            if (this.shouldSubmitCurrentBatch()) {
                byte[] currentStartAfter = inode.getLocalNameBytes();
                String parentPath = parent.getFullPathName();
                lockReleased = true;
                this.readUnlock();
                this.submitCurrentBatch(startId);
                try {
                    this.throttle();
                    this.checkPauseForTesting();
                }
                finally {
                    this.readLock();
                    lockStartTime = this.timer.monotonicNow();
                }
                this.checkINodeReady(startId);
                FSPermissionChecker pc = this.dir.getPermissionChecker();
                INode newParent = this.dir.resolvePath(pc, parentPath, FSDirectory.DirOp.READ).getLastINode();
                if (newParent == null || !newParent.equals(parent)) {
                    return null;
                }
                children = parent.getChildrenList(0x7FFFFFFE);
                i = INodeDirectory.nextChild(children, currentStartAfter) - 1;
            }
            if (this.timer.monotonicNow() - lockStartTime <= this.readLockReportingThresholdMs) continue;
            this.readUnlock();
            try {
                this.throttle();
                continue;
            }
            finally {
                this.readLock();
                lockStartTime = this.timer.monotonicNow();
            }
        }
        startAfters.remove(startAfters.size() - 1);
        if (!startAfters.isEmpty()) {
            startAfters.remove(startAfters.size() - 1);
            startAfters.add(curr.getLocalNameBytes());
        }
        curr = curr.getParent();
        return lockReleased ? null : curr;
    }

    private INode resolvePaths(long startId, List<byte[]> startAfters) throws IOException {
        INode zoneNode = this.dir.getInode(startId);
        if (zoneNode == null) {
            throw new FileNotFoundException("Zone " + startId + " is deleted.");
        }
        INodeDirectory parent = zoneNode.asDirectory();
        for (int i = 0; i < startAfters.size() && i != startAfters.size() - 1; ++i) {
            INode curr = parent.getChild(startAfters.get(i), 0x7FFFFFFE);
            if (curr == null) {
                while (i < startAfters.size()) {
                    startAfters.remove(startAfters.size() - 1);
                    ++i;
                }
                break;
            }
            parent = curr.asDirectory();
        }
        return parent;
    }

    protected void readLock() {
        this.dir.getFSNamesystem().readLock();
        this.dir.readLock();
    }

    protected void readUnlock() {
        this.dir.readUnlock();
        this.dir.getFSNamesystem().readUnlock("FSTreeTraverser");
    }

    protected abstract void checkPauseForTesting() throws InterruptedException;

    protected abstract boolean processFileInode(INode var1, TraverseInfo var2) throws IOException, InterruptedException;

    protected abstract boolean shouldSubmitCurrentBatch();

    protected abstract void checkINodeReady(long var1) throws IOException;

    protected abstract void submitCurrentBatch(Long var1) throws IOException, InterruptedException;

    protected abstract void throttle() throws InterruptedException;

    protected abstract boolean canTraverseDir(INode var1) throws IOException;

    public static class TraverseInfo {
    }
}

