/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3.async;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.StreamContext;
import org.opensearch.common.blobstore.stream.write.WritePriority;
import org.opensearch.common.io.InputStreamContainer;
import org.opensearch.repositories.s3.S3TransferRejectedException;
import org.opensearch.repositories.s3.SocketAccess;
import org.opensearch.repositories.s3.StatsMetricPublisher;
import org.opensearch.repositories.s3.async.TransferSemaphoresHolder;
import org.opensearch.repositories.s3.async.UploadRequest;
import org.opensearch.repositories.s3.io.CheckedContainer;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.utils.CompletableFutureUtils;

public class AsyncPartsHandler {
    private static final Logger log = LogManager.getLogger(AsyncPartsHandler.class);

    public static List<CompletableFuture<CompletedPart>> uploadParts(S3AsyncClient s3AsyncClient, ExecutorService executorService, ExecutorService priorityExecutorService, ExecutorService urgentExecutorService, UploadRequest uploadRequest, StreamContext streamContext, String uploadId, AtomicReferenceArray<CompletedPart> completedParts, AtomicReferenceArray<CheckedContainer> inputStreamContainers, StatsMetricPublisher statsMetricPublisher, boolean uploadRetryEnabled, TransferSemaphoresHolder transferSemaphoresHolder, long maxRetryablePartSize) throws InterruptedException {
        ArrayList<CompletableFuture<CompletedPart>> futures = new ArrayList<CompletableFuture<CompletedPart>>();
        TransferSemaphoresHolder.RequestContext requestContext = transferSemaphoresHolder.createRequestContext();
        for (int partIdx = 0; partIdx < streamContext.getNumberOfParts(); ++partIdx) {
            Semaphore semaphore = AsyncPartsHandler.maybeAcquireSemaphore(transferSemaphoresHolder, requestContext, uploadRequest.getWritePriority(), uploadRequest.getKey());
            try {
                InputStreamContainer inputStreamContainer = streamContext.provideStream(partIdx);
                inputStreamContainers.set(partIdx, new CheckedContainer(inputStreamContainer.getContentLength()));
                UploadPartRequest.Builder uploadPartRequestBuilder = UploadPartRequest.builder().bucket(uploadRequest.getBucket()).partNumber(Integer.valueOf(partIdx + 1)).key(uploadRequest.getKey()).uploadId(uploadId).overrideConfiguration(o -> o.addMetricPublisher(statsMetricPublisher.multipartUploadMetricCollector)).contentLength(Long.valueOf(inputStreamContainer.getContentLength()));
                if (uploadRequest.doRemoteDataIntegrityCheck()) {
                    uploadPartRequestBuilder.checksumAlgorithm(ChecksumAlgorithm.CRC32);
                }
                AsyncPartsHandler.uploadPart(s3AsyncClient, executorService, priorityExecutorService, urgentExecutorService, completedParts, inputStreamContainers, futures, (UploadPartRequest)uploadPartRequestBuilder.build(), inputStreamContainer, uploadRequest, uploadRetryEnabled, maxRetryablePartSize, semaphore);
                continue;
            }
            catch (Exception ex) {
                if (semaphore == null) continue;
                semaphore.release();
            }
        }
        return futures;
    }

    public static void cleanUpParts(S3AsyncClient s3AsyncClient, UploadRequest uploadRequest, String uploadId) {
        AbortMultipartUploadRequest abortMultipartUploadRequest = (AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(uploadRequest.getBucket()).key(uploadRequest.getKey()).uploadId(uploadId).build();
        SocketAccess.doPrivileged(() -> s3AsyncClient.abortMultipartUpload(abortMultipartUploadRequest).exceptionally(throwable -> {
            log.warn(() -> new ParameterizedMessage("Failed to abort previous multipart upload (id: {}). You may need to call S3AsyncClient#abortMultiPartUpload to free all storage consumed by all parts. ", (Object)uploadId), throwable);
            return null;
        }));
    }

    public static InputStream maybeRetryInputStream(InputStream inputStream, WritePriority writePriority, boolean uploadRetryEnabled, long contentLength, long maxRetryablePartSize) {
        if (uploadRetryEnabled && (contentLength <= maxRetryablePartSize || writePriority == WritePriority.HIGH || writePriority == WritePriority.URGENT)) {
            return new UploadTrackedBufferedInputStream(inputStream, (int)(contentLength + 1L));
        }
        return inputStream;
    }

    public static Semaphore maybeAcquireSemaphore(TransferSemaphoresHolder transferSemaphoresHolder, TransferSemaphoresHolder.RequestContext requestContext, WritePriority writePriority, String file) throws InterruptedException {
        TransferSemaphoresHolder.TypeSemaphore semaphore;
        if (writePriority != WritePriority.HIGH && writePriority != WritePriority.URGENT) {
            semaphore = transferSemaphoresHolder.acquirePermit(writePriority, requestContext);
            if (semaphore == null) {
                throw new S3TransferRejectedException("Permit not available for transfer of file " + file);
            }
        } else {
            semaphore = null;
        }
        return semaphore;
    }

    private static void uploadPart(S3AsyncClient s3AsyncClient, ExecutorService executorService, ExecutorService priorityExecutorService, ExecutorService urgentExecutorService, AtomicReferenceArray<CompletedPart> completedParts, AtomicReferenceArray<CheckedContainer> inputStreamContainers, List<CompletableFuture<CompletedPart>> futures, UploadPartRequest uploadPartRequest, InputStreamContainer inputStreamContainer, UploadRequest uploadRequest, boolean uploadRetryEnabled, long maxRetryablePartSize, Semaphore semaphore) {
        Integer partNumber = uploadPartRequest.partNumber();
        ExecutorService streamReadExecutor = uploadRequest.getWritePriority() == WritePriority.URGENT ? urgentExecutorService : (uploadRequest.getWritePriority() == WritePriority.HIGH ? priorityExecutorService : executorService);
        InputStream inputStream = AsyncPartsHandler.maybeRetryInputStream(inputStreamContainer.getInputStream(), uploadRequest.getWritePriority(), uploadRetryEnabled, uploadPartRequest.contentLength(), maxRetryablePartSize);
        CompletableFuture uploadPartResponseFuture = SocketAccess.doPrivileged(() -> s3AsyncClient.uploadPart(uploadPartRequest, AsyncRequestBody.fromInputStream((InputStream)inputStream, (Long)inputStreamContainer.getContentLength(), (ExecutorService)streamReadExecutor)));
        CompletionStage convertFuture = ((CompletableFuture)uploadPartResponseFuture.whenComplete((resp, throwable) -> {
            if (semaphore != null) {
                semaphore.release();
            }
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                log.error(() -> new ParameterizedMessage("Failed to close stream while uploading a part of idx {} and file {}.", (Object)uploadPartRequest.partNumber(), (Object)uploadPartRequest.key()), (Throwable)ex);
            }
        })).thenApply(uploadPartResponse -> AsyncPartsHandler.convertUploadPartResponse(completedParts, inputStreamContainers, uploadPartResponse, partNumber, uploadRequest.doRemoteDataIntegrityCheck()));
        futures.add((CompletableFuture<CompletedPart>)convertFuture);
        CompletableFutureUtils.forwardExceptionTo((CompletableFuture)convertFuture, (CompletableFuture)uploadPartResponseFuture);
    }

    private static CompletedPart convertUploadPartResponse(AtomicReferenceArray<CompletedPart> completedParts, AtomicReferenceArray<CheckedContainer> inputStreamContainers, UploadPartResponse partResponse, int partNumber, boolean isRemoteDataIntegrityCheckEnabled) {
        CompletedPart.Builder completedPartBuilder = CompletedPart.builder().eTag(partResponse.eTag()).partNumber(Integer.valueOf(partNumber));
        if (isRemoteDataIntegrityCheckEnabled) {
            completedPartBuilder.checksumCRC32(partResponse.checksumCRC32());
            CheckedContainer inputStreamCRC32Container = inputStreamContainers.get(partNumber - 1);
            inputStreamCRC32Container.setChecksum(partResponse.checksumCRC32());
            inputStreamContainers.set(partNumber - 1, inputStreamCRC32Container);
        }
        CompletedPart completedPart = (CompletedPart)completedPartBuilder.build();
        completedParts.set(partNumber - 1, completedPart);
        return completedPart;
    }

    static class UploadTrackedBufferedInputStream
    extends BufferedInputStream {
        AtomicBoolean closed = new AtomicBoolean();

        public UploadTrackedBufferedInputStream(InputStream in, int length) {
            super(in, length);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed.set(true);
        }
    }
}

