/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.ssl.SslContextHandler;
import org.opensearch.security.ssl.SslSettingsManager;
import org.opensearch.security.ssl.config.CertType;
import org.opensearch.security.ssl.config.Certificate;
import org.opensearch.threadpool.ThreadPool;

@Deprecated
public class SecuritySSLCertsApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(SecuritySSLCertsApiAction.class);
    private static final List<RestHandler.Route> ROUTES = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/ssl/certs", "[/ssl/certs] is a deprecated endpoint. Please use [/certificates] instead."), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/ssl/{certType}/reloadcerts")));
    private final SslSettingsManager sslSettingsManager;
    private final boolean certificatesReloadEnabled;

    public SecuritySSLCertsApiAction(ClusterService clusterService, ThreadPool threadPool, SslSettingsManager sslSettingsManager, boolean certificatesReloadEnabled, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.SSL, clusterService, threadPool, securityApiDependencies);
        this.sslSettingsManager = sslSettingsManager;
        this.certificatesReloadEnabled = certificatesReloadEnabled;
        this.requestHandlersBuilder.configureRequestHandlers(this::securitySSLCertsRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    @Override
    public String getName() {
        return "SSL Certificates Action";
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("certType");
    }

    @Override
    protected CType<?> getConfigType() {
        return null;
    }

    private void securitySSLCertsRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.withAccessHandler(this::accessHandler).allMethodsNotImplemented().verifyAccessForAllMethods().override(RestRequest.Method.GET, (channel, request, client) -> this.withSecurityKeyStore().valid((CheckedConsumer<SslSettingsManager, IOException>)((CheckedConsumer)ignore -> this.loadCertificates(channel))).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)))).override(RestRequest.Method.PUT, (channel, request, client) -> this.withSecurityKeyStore().valid((CheckedConsumer<SslSettingsManager, IOException>)((CheckedConsumer)ignore -> {
            if (!this.certificatesReloadEnabled) {
                Responses.badRequest(channel, String.format("no handler found for uri [%s] and method [%s]. In order to use SSL reload functionality set %s to true", request.path(), request.method(), "plugins.security.ssl_cert_reload_enabled"));
            } else {
                this.reloadCertificates(channel, request);
            }
        })).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent))));
    }

    boolean accessHandler(RestRequest request) {
        if (request.method() == RestRequest.Method.GET) {
            return this.securityApiDependencies.restApiAdminPrivilegesEvaluator().isCurrentUserAdminFor(this.endpoint, "certs/info");
        }
        if (request.method() == RestRequest.Method.PUT) {
            return this.securityApiDependencies.restApiAdminPrivilegesEvaluator().isCurrentUserAdminFor(this.endpoint, "certs/reload");
        }
        return false;
    }

    ValidationResult<SslSettingsManager> withSecurityKeyStore() {
        if (this.sslSettingsManager == null) {
            return ValidationResult.error(RestStatus.OK, Responses.badRequestMessage("keystore is not initialized"));
        }
        return ValidationResult.success(this.sslSettingsManager);
    }

    protected void loadCertificates(RestChannel channel) throws IOException {
        Responses.ok(channel, (builder, params) -> builder.startObject().field("http_certificates_list", this.generateCertDetailList(this.sslSettingsManager.sslContextHandler(CertType.HTTP).map(SslContextHandler::keyMaterialCertificates).orElse(null))).field("transport_certificates_list", this.generateCertDetailList(this.sslSettingsManager.sslContextHandler(CertType.TRANSPORT).map(SslContextHandler::keyMaterialCertificates).orElse(null))).endObject());
    }

    private List<Map<String, String>> generateCertDetailList(Stream<Certificate> certs) {
        if (certs == null) {
            return null;
        }
        return certs.map(c -> ImmutableMap.of((Object)"issuer_dn", (Object)c.issuer(), (Object)"subject_dn", (Object)c.subject(), (Object)"san", (Object)c.subjectAlternativeNames(), (Object)"not_before", (Object)c.notBefore(), (Object)"not_after", (Object)c.notAfter())).collect(Collectors.toList());
    }

    protected void reloadCertificates(RestChannel channel, RestRequest request) throws IOException {
        String certType = request.param("certType").toLowerCase().trim();
        try {
            switch (certType) {
                case "http": {
                    if (this.sslSettingsManager.sslConfiguration(CertType.HTTP).isPresent()) {
                        this.sslSettingsManager.reloadSslContext(CertType.HTTP);
                        Responses.ok(channel, (builder, params) -> builder.startObject().field("message", "updated http certs").endObject());
                        break;
                    }
                    Responses.badRequest(channel, "SSL for HTTP is disabled");
                    break;
                }
                case "transport": {
                    this.sslSettingsManager.reloadSslContext(CertType.TRANSPORT);
                    this.sslSettingsManager.reloadSslContext(CertType.TRANSPORT_CLIENT);
                    Responses.ok(channel, (builder, params) -> builder.startObject().field("message", "updated transport certs").endObject());
                    break;
                }
                default: {
                    Responses.forbidden(channel, "invalid uri path, please use /_plugins/_security/api/ssl/http/reload or /_plugins/_security/api/ssl/transport/reload");
                    break;
                }
            }
        }
        catch (OpenSearchSecurityException e) {
            throw new IOException(e);
        }
    }
}

